/*
 * Decompiled with CFR 0.152.
 */
package com.android.sync.analyzer;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.output.DownloadInfoDataModel;
import com.android.build.output.LongDownloadsNotifier;
import com.android.sync.analyzer.SyncAnalyzerDataManager;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerDataManager;", "", "()V", "idToData", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "getIdToData$annotations", "getIdToData", "()Ljava/util/concurrent/ConcurrentHashMap;", "clearDataForTask", "", "id", "getDataForTaskIfExists", "getOrCreateDataForTask", "DataHolder", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nSyncAnalyzerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncAnalyzerManagerImpl.kt\ncom/android/sync/analyzer/SyncAnalyzerDataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class SyncAnalyzerDataManager {
    @NotNull
    private final ConcurrentHashMap<ExternalSystemTaskId, DataHolder> idToData = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<ExternalSystemTaskId, DataHolder> getIdToData() {
        return this.idToData;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIdToData$annotations() {
    }

    @NotNull
    public final DataHolder getOrCreateDataForTask(@NotNull ExternalSystemTaskId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        DataHolder dataHolder = this.idToData.computeIfAbsent(id2, getOrCreateDataForTask.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)dataHolder, (String)"idToData.computeIfAbsent(id) { DataHolder(it) }");
        return dataHolder;
    }

    @Nullable
    public final DataHolder getDataForTaskIfExists(@NotNull ExternalSystemTaskId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.idToData.get(id2);
    }

    public final void clearDataForTask(@NotNull ExternalSystemTaskId id2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            DataHolder dataHolder = this.idToData.remove(id2);
            if (dataHolder == null) break block0;
            DataHolder it = dataHolder;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getBuildDisposable()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;)V", "buildDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getBuildDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "buildStartTimestampMs", "", "getBuildStartTimestampMs", "()J", "downloadsInfoDataModel", "Lcom/android/build/output/DownloadInfoDataModel;", "getDownloadsInfoDataModel", "()Lcom/android/build/output/DownloadInfoDataModel;", "downloadsStatsAccumulator", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "getDownloadsStatsAccumulator", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "getId", "()Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "intellij.android.build-attribution"})
    public static final class DataHolder {
        @NotNull
        private final ExternalSystemTaskId id;
        private final long buildStartTimestampMs;
        @NotNull
        private final CheckedDisposable buildDisposable;
        @NotNull
        private final DownloadsAnalyzer.DownloadStatsAccumulator downloadsStatsAccumulator;
        @Nullable
        private final DownloadInfoDataModel downloadsInfoDataModel;

        /*
         * WARNING - void declaration
         */
        public DataHolder(@NotNull ExternalSystemTaskId id2) {
            DownloadInfoDataModel downloadInfoDataModel;
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.id = id2;
            this.buildStartTimestampMs = System.currentTimeMillis();
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((String)("SyncAnalyzer disposable for " + this.id));
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(\"Sy\u2026yzer disposable for $id\")");
            this.buildDisposable = checkedDisposable;
            this.downloadsStatsAccumulator = new DownloadsAnalyzer.DownloadStatsAccumulator();
            DataHolder dataHolder = this;
            Object t = StudioFlags.BUILD_OUTPUT_DOWNLOADS_INFORMATION.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"BUILD_OUTPUT_DOWNLOADS_INFORMATION.get()");
            if (((Boolean)t).booleanValue()) {
                Project project = this.id.findProject();
                if (project != null) {
                    void project2;
                    Project project3 = project;
                    DataHolder dataHolder2 = dataHolder;
                    boolean bl = false;
                    LongDownloadsNotifier notifier = new LongDownloadsNotifier(this.id, (Project)project2, this.buildDisposable, this.buildStartTimestampMs, null, null, 48, null);
                    downloadInfoDataModel = new DownloadInfoDataModel((Disposable)this.buildDisposable, notifier);
                    dataHolder = dataHolder2;
                } else {
                    downloadInfoDataModel = null;
                }
            } else {
                downloadInfoDataModel = null;
            }
            dataHolder.downloadsInfoDataModel = downloadInfoDataModel;
        }

        @NotNull
        public final ExternalSystemTaskId getId() {
            return this.id;
        }

        public final long getBuildStartTimestampMs() {
            return this.buildStartTimestampMs;
        }

        @NotNull
        public final CheckedDisposable getBuildDisposable() {
            return this.buildDisposable;
        }

        @NotNull
        public final DownloadsAnalyzer.DownloadStatsAccumulator getDownloadsStatsAccumulator() {
            return this.downloadsStatsAccumulator;
        }

        @Nullable
        public final DownloadInfoDataModel getDownloadsInfoDataModel() {
            return this.downloadsInfoDataModel;
        }
    }
}

