/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.reflection;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.application.ApplicationManager;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\rB\u001f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eB'\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B/\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/android/layoutlib/reflection/TrackingThread;", "Ljava/lang/Thread;", "()V", "target", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "group", "Ljava/lang/ThreadGroup;", "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;)V", "name", "", "(Ljava/lang/String;)V", "(Ljava/lang/ThreadGroup;Ljava/lang/String;)V", "(Ljava/lang/Runnable;Ljava/lang/String;)V", "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;)V", "stackSize", "", "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;J)V", "inheritThreadLocals", "", "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;JZ)V", "createThrowable", "", "getLogger", "Lcom/android/ide/common/rendering/api/ILayoutLog;", "logWarning", "", "throwable", "reportIllegalThread", "intellij.android.core"})
public class TrackingThread
extends Thread {
    public TrackingThread() {
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull Runnable target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        super(target2);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull ThreadGroup group2, @NotNull Runnable target2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        super(group2, target2);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull ThreadGroup group2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(group2, name2);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull Runnable target2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(target2, name2);
        if (!Intrinsics.areEqual((Object)name2, (Object)"kotlinx.coroutines.DefaultExecutor")) {
            this.reportIllegalThread();
        }
    }

    public TrackingThread(@NotNull ThreadGroup group2, @NotNull Runnable target2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(group2, target2, name2);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull ThreadGroup group2, @NotNull Runnable target2, @NotNull String name2, long stackSize) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(group2, target2, name2, stackSize);
        this.reportIllegalThread();
    }

    public TrackingThread(@NotNull ThreadGroup group2, @NotNull Runnable target2, @NotNull String name2, long stackSize, boolean inheritThreadLocals) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(group2, target2, name2, stackSize, inheritThreadLocals);
        this.reportIllegalThread();
    }

    private final void reportIllegalThread() {
        if (!((Boolean)StudioFlags.NELE_WARN_NEW_THREADS.get()).booleanValue()) {
            return;
        }
        Throwable throwable = this.createThrowable();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw throwable;
        }
        this.logWarning(throwable);
    }

    private final void logWarning(Throwable throwable) {
        try {
            ILayoutLog logger2 = this.getLogger();
            logger2.warning("thread-creation", "Do not create Threads in the preview", null, (Object)throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private final ILayoutLog getLogger() {
        Class<?> bridgeClass = Class.forName("com.android.layoutlib.bridge.Bridge");
        Field loggerField = bridgeClass.getDeclaredField("sCurrentLog");
        loggerField.setAccessible(true);
        Object loggerObject = loggerField.get(null);
        Intrinsics.checkNotNull((Object)loggerObject, (String)"null cannot be cast to non-null type com.android.ide.common.rendering.api.ILayoutLog");
        return (ILayoutLog)loggerObject;
    }

    private final Throwable createThrowable() {
        IllegalStateException throwable = new IllegalStateException("It is not allowed to create new threads in the preview");
        int elementsToRemove = 3;
        Object[] stacktrace = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stacktrace, (String)"stacktrace");
        Object[] objectArray = stacktrace;
        int n = stacktrace.length;
        throwable.setStackTrace((StackTraceElement[])ArraysKt.copyOfRange((Object[])objectArray, (int)elementsToRemove, (int)n));
        return throwable;
    }
}

