/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.output.DownloadRequestItem;
import com.android.build.output.RequestsTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import icons.StudioIcons;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/build/output/RequestsTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/output/DownloadRequestItem;", "()V", "cellRenderer", "com/android/build/output/RequestsTableModel$cellRenderer$1", "Lcom/android/build/output/RequestsTableModel$cellRenderer$1;", "fileNameColumn", "Lcom/intellij/util/ui/ColumnInfo;", "", "getFileNameColumn", "()Lcom/intellij/util/ui/ColumnInfo;", "sizeColumn", "getSizeColumn", "speedColumn", "getSpeedColumn", "statusColumn", "Lcom/android/build/output/RequestsTableModel$Status;", "getStatusColumn", "timeColumn", "getTimeColumn", "addOrUpdate", "", "requestItem", "Status", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadsInfoUIModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RequestsTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n350#2,7:276\n*S KotlinDebug\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RequestsTableModel\n*L\n266#1:276,7\n*E\n"})
public final class RequestsTableModel
extends ListTableModel<DownloadRequestItem> {
    @NotNull
    private final cellRenderer.1 cellRenderer = new ColoredTableCellRenderer(){

        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof String) {
                this.append((String)value2);
            }
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> fileNameColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("File");
        }

        @NotNull
        public String valueOf(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return item2.getRequestKey().getUrl();
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        @NotNull
        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<DownloadRequestItem> comparator2 = Comparator.comparing((Function)fileNameColumn.getComparator.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.requestKey.url }");
            return comparator2;
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> timeColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Time");
        }

        @NotNull
        public String valueOf(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            String string = StringUtil.formatDuration((long)item2.getDuration());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(item.duration)");
            return string;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        @NotNull
        public String getPreferredStringValue() {
            return "12 s 123 ms";
        }

        @NotNull
        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        @NotNull
        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<DownloadRequestItem> comparator2 = Comparator.comparing((Function)timeColumn.getComparator.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.duration }");
            return comparator2;
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> sizeColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Size");
        }

        @NotNull
        public String valueOf(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            String string = StringUtil.formatFileSize((long)item2.getReceivedBytes());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(item.receivedBytes)");
            return string;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        @NotNull
        public String getPreferredStringValue() {
            return "123.45 MB";
        }

        @NotNull
        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        @NotNull
        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<DownloadRequestItem> comparator2 = Comparator.comparing((Function)sizeColumn.getComparator.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.receivedBytes }");
            return comparator2;
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> speedColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Avg Speed");
        }

        @NotNull
        public String valueOf(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return BuildAttributionUIUtilKt.formatAvgDownloadSpeed(item2.getReceivedBytes(), item2.getDuration());
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        @NotNull
        public String getPreferredStringValue() {
            return "123.45 MB/s";
        }

        @NotNull
        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, Status> statusColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, Status>(){
        @NotNull
        private final statusColumn.columnCellRenderer.1 columnCellRenderer;
        {
            this.columnCellRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column2) {
                    Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                    if (value2 instanceof Status) {
                        this.setToolTipText(((Status)value2).getTooltip());
                        this.setIcon(((Status)value2).getIcon());
                        this.setTransparentIconBackground(true);
                        this.append(((Status)value2).getText(), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
                        this.setTextAlign(4);
                    }
                }
            };
        }

        @NotNull
        public final statusColumn.columnCellRenderer.1 getColumnCellRenderer() {
            return this.columnCellRenderer;
        }

        @NotNull
        public Status valueOf(@NotNull DownloadRequestItem item2) {
            Status status2;
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            if (!item2.getCompleted()) {
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                status2 = new Status("Running", (Icon)animatedIcon, "");
            } else if (item2.getFailed()) {
                Icon icon2 = StudioIcons.Common.WARNING_INLINE;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"WARNING_INLINE");
                String string = item2.getFailureMessage();
                if (string == null || (string = StringsKt.replace$default((String)string, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null)) == null) {
                    string = "";
                }
                status2 = new Status("Failed", icon2, string);
            } else {
                Icon icon3 = StudioIcons.Common.SUCCESS_INLINE;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SUCCESS_INLINE");
                status2 = new Status("Finished", icon3, "");
            }
            return status2;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull DownloadRequestItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return (TableCellRenderer)((Object)this.columnCellRenderer);
        }

        @NotNull
        public String getPreferredStringValue() {
            return "Download Failed";
        }

        @NotNull
        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        @NotNull
        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<DownloadRequestItem> comparator2 = Comparator.comparing(new Function(this){
                final /* synthetic */ statusColumn.1 this$0;
                {
                    this.this$0 = $receiver;
                }

                public final String apply(DownloadRequestItem it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return this.this$0.valueOf(it).getText();
                }
            });
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"override fun getComparat\u2026ring { valueOf(it).text }");
            return comparator2;
        }
    };

    public RequestsTableModel() {
        super(new ColumnInfo[0]);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{this.statusColumn, this.fileNameColumn, this.timeColumn, this.sizeColumn, this.speedColumn};
        this.setColumnInfos(columnInfoArray);
        this.setSortable(true);
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getFileNameColumn() {
        return this.fileNameColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getTimeColumn() {
        return this.timeColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getSizeColumn() {
        return this.sizeColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getSpeedColumn() {
        return this.speedColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, Status> getStatusColumn() {
        return this.statusColumn;
    }

    public final void addOrUpdate(@NotNull DownloadRequestItem requestItem) {
        int itemIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)requestItem, (String)"requestItem");
            List list2 = this.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"items");
            List $this$indexOfFirst$iv = list2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                DownloadRequestItem it = (DownloadRequestItem)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)requestItem.getRequestKey(), (Object)it.getRequestKey())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = itemIndex = -1;
        }
        if (itemIndex == -1) {
            this.addRow(requestItem);
        } else {
            this.setItem(itemIndex, requestItem);
        }
    }

    public static final /* synthetic */ cellRenderer.1 access$getCellRenderer$p(RequestsTableModel $this) {
        return $this.cellRenderer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/output/RequestsTableModel$Status;", "", "text", "", "icon", "Ljavax/swing/Icon;", "tooltip", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getText", "()Ljava/lang/String;", "getTooltip", "toString", "intellij.android.build-attribution"})
    public static final class Status {
        @NotNull
        private final String text;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String tooltip;

        public Status(@NotNull String text2, @NotNull Icon icon2, @NotNull String tooltip2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)tooltip2, (String)"tooltip");
            this.text = text2;
            this.icon = icon2;
            this.tooltip = tooltip2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String toString() {
            return this.text;
        }
    }
}

