/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.output.DownloadRequestItem;
import com.android.build.output.DownloadRequestKey;
import com.android.build.output.LongDownloadsNotifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001$B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000bH\u0007J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000bJ\b\u0010\u001f\u001a\u00020\u0011H\u0007J\b\u0010 \u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\rH\u0007J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\rH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/output/DownloadInfoDataModel;", "", "buildFinishedDisposable", "Lcom/intellij/openapi/Disposable;", "longDownloadsNotifier", "Lcom/android/build/output/LongDownloadsNotifier;", "(Lcom/intellij/openapi/Disposable;Lcom/android/build/output/LongDownloadsNotifier;)V", "immediateUpdateScheduled", "", "processedEvents", "", "Lcom/android/build/output/DownloadRequestItem;", "subscribedModels", "Lcom/android/build/output/DownloadInfoDataModel$Listener;", "updatesQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "downloadFinished", "", "downloadResult", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "downloadStarted", "startTimestamp", "", "url", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "notifyListenersOnUpdate", "updatedItem", "onNewItemUpdate", "downloadRequest", "processUpdatesQueue", "scheduleImmediateUpdateIfNecessary", "subscribeUiModel", "modelListener", "unsubscribeUiModel", "Listener", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadInfoDataModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadInfoDataModel.kt\ncom/android/build/output/DownloadInfoDataModel\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n58#2,3:130\n1851#3,2:133\n1851#3,2:135\n*S KotlinDebug\n*F\n+ 1 DownloadInfoDataModel.kt\ncom/android/build/output/DownloadInfoDataModel\n*L\n88#1:130,3\n112#1:133,2\n122#1:135,2\n*E\n"})
public final class DownloadInfoDataModel {
    @Nullable
    private final LongDownloadsNotifier longDownloadsNotifier;
    @NotNull
    private final ConcurrentLinkedQueue<DownloadRequestItem> updatesQueue;
    private volatile boolean immediateUpdateScheduled;
    @NotNull
    private final List<DownloadRequestItem> processedEvents;
    @NotNull
    private final List<Listener> subscribedModels;

    public DownloadInfoDataModel(@NotNull Disposable buildFinishedDisposable, @Nullable LongDownloadsNotifier longDownloadsNotifier) {
        Intrinsics.checkNotNullParameter((Object)buildFinishedDisposable, (String)"buildFinishedDisposable");
        this.longDownloadsNotifier = longDownloadsNotifier;
        this.updatesQueue = new ConcurrentLinkedQueue();
        Disposer.register((Disposable)buildFinishedDisposable, (Disposable)new Disposable(){

            public final void dispose() {
                DownloadInfoDataModel downloadInfoDataModel = this;
                Object modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(downloadInfoDataModel){
                    final /* synthetic */ DownloadInfoDataModel this$0;
                    {
                        this.this$0 = downloadInfoDataModel;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.this$0.processUpdatesQueue();
                    }
                }, ModalityState.defaultModalityState());
            }
        });
        this.processedEvents = new ArrayList();
        this.subscribedModels = new ArrayList();
    }

    public /* synthetic */ DownloadInfoDataModel(Disposable disposable2, LongDownloadsNotifier longDownloadsNotifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            longDownloadsNotifier = null;
        }
        this(disposable2, longDownloadsNotifier);
    }

    public final void downloadStarted(long startTimestamp, @NotNull String url, @NotNull DownloadsAnalyzer.Repository repository2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        DownloadRequestKey requestKey = new DownloadRequestKey(startTimestamp, url);
        DownloadRequestItem requestItem = new DownloadRequestItem(requestKey, repository2, false, 0L, 0L, null);
        this.onNewItemUpdate(requestItem);
    }

    public final void downloadFinished(@NotNull DownloadsAnalyzer.DownloadResult downloadResult) {
        Intrinsics.checkNotNullParameter((Object)downloadResult, (String)"downloadResult");
        DownloadRequestKey downloadRequestKey = new DownloadRequestKey(downloadResult.getTimestamp(), downloadResult.getUrl());
        DownloadsAnalyzer.Repository repository2 = downloadResult.getRepository();
        long l = downloadResult.getBytes();
        long l2 = downloadResult.getDuration();
        DownloadRequestItem requestItem = new DownloadRequestItem(downloadRequestKey, repository2, true, l, l2, switch (WhenMappings.$EnumSwitchMapping$0[downloadResult.getStatus().ordinal()]) {
            case 1 -> null;
            case 2 -> "Not Found";
            case 3 -> downloadResult.getFailureMessage();
            default -> throw new NoWhenBranchMatchedException();
        });
        this.onNewItemUpdate(requestItem);
    }

    public final void onNewItemUpdate(@NotNull DownloadRequestItem downloadRequest) {
        Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
        this.updatesQueue.add(downloadRequest);
        LongDownloadsNotifier longDownloadsNotifier = this.longDownloadsNotifier;
        if (longDownloadsNotifier != null) {
            longDownloadsNotifier.updateDownloadRequest(downloadRequest);
        }
        this.scheduleImmediateUpdateIfNecessary();
    }

    private final void scheduleImmediateUpdateIfNecessary() {
        if (!this.immediateUpdateScheduled) {
            this.immediateUpdateScheduled = true;
            Object modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ DownloadInfoDataModel this$0;
                {
                    this.this$0 = downloadInfoDataModel;
                }

                public final void run() {
                    boolean bl = false;
                    DownloadInfoDataModel.access$setImmediateUpdateScheduled$p(this.this$0, false);
                    this.this$0.processUpdatesQueue();
                }
            }, ModalityState.defaultModalityState());
        }
    }

    @UiThread
    public final void processUpdatesQueue() {
        while (this.updatesQueue.poll() != null) {
            DownloadRequestItem requestItem;
            this.processedEvents.add(requestItem);
            this.notifyListenersOnUpdate(requestItem);
        }
    }

    @UiThread
    public final void subscribeUiModel(@NotNull Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        this.subscribedModels.add(modelListener2);
        Iterable $this$forEach$iv = this.processedEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadRequestItem it = (DownloadRequestItem)element$iv;
            boolean bl = false;
            modelListener2.updateDownloadRequest(it);
        }
    }

    @UiThread
    public final void unsubscribeUiModel(@NotNull Listener modelListener2) {
        Intrinsics.checkNotNullParameter((Object)modelListener2, (String)"modelListener");
        this.subscribedModels.remove(modelListener2);
    }

    @UiThread
    public final void notifyListenersOnUpdate(@NotNull DownloadRequestItem updatedItem) {
        Intrinsics.checkNotNullParameter((Object)updatedItem, (String)"updatedItem");
        Iterable $this$forEach$iv = this.subscribedModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.updateDownloadRequest(updatedItem);
        }
    }

    public static final /* synthetic */ void access$setImmediateUpdateScheduled$p(DownloadInfoDataModel $this, boolean bl) {
        $this.immediateUpdateScheduled = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/build/output/DownloadInfoDataModel$Listener;", "", "updateDownloadRequest", "", "downloadRequest", "Lcom/android/build/output/DownloadRequestItem;", "intellij.android.build-attribution"})
    public static interface Listener {
        public void updateDownloadRequest(@NotNull DownloadRequestItem var1);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DownloadsAnalyzer.DownloadStatus.values().length];
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.MISSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DownloadsAnalyzer.DownloadStatus.FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

