/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.details;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.CriticalPathTaskCategoryUiData;
import com.android.build.attribution.ui.data.TaskCategoryIssueUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.EntryDetailsNodeDescriptor;
import com.android.build.attribution.ui.model.TaskDetailsNodeDescriptor;
import com.android.build.attribution.ui.model.TaskDetailsPageType;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.utils.HtmlBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/ui/view/details/TaskViewDetailPagesFactory;", "", "model", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "(Lcom/android/build/attribution/ui/model/TasksDataPageModel;Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "getActionHandlers", "()Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "getModel", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "createDetailsPage", "Ljavax/swing/JComponent;", "pageId", "Lcom/android/build/attribution/ui/model/TasksPageId;", "nodeDescriptor", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "createEmptyPage", "Ljavax/swing/JPanel;", "createEntryDetailsPage", "descriptor", "Lcom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor;", "createTaskDetailsPage", "Lcom/android/build/attribution/ui/model/TaskDetailsNodeDescriptor;", "entryDetailsHtml", "", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTaskViewDetailPagesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskViewDetailPagesFactory.kt\ncom/android/build/attribution/ui/view/details/TaskViewDetailPagesFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n766#2:159\n857#2,2:160\n1851#2:162\n1851#2,2:163\n1852#2:165\n*S KotlinDebug\n*F\n+ 1 TaskViewDetailPagesFactory.kt\ncom/android/build/attribution/ui/view/details/TaskViewDetailPagesFactory\n*L\n96#1:159\n96#1:160,2\n140#1:162\n148#1:163,2\n140#1:165\n*E\n"})
public final class TaskViewDetailPagesFactory {
    @NotNull
    private final TasksDataPageModel model;
    @NotNull
    private final ViewActionHandlers actionHandlers;

    public TaskViewDetailPagesFactory(@NotNull TasksDataPageModel model2, @NotNull ViewActionHandlers actionHandlers) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        this.model = model2;
        this.actionHandlers = actionHandlers;
    }

    @NotNull
    public final TasksDataPageModel getModel() {
        return this.model;
    }

    @NotNull
    public final ViewActionHandlers getActionHandlers() {
        return this.actionHandlers;
    }

    @NotNull
    public final JComponent createDetailsPage(@NotNull TasksPageId pageId) {
        Object object;
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
                    if (pageId.getPageType() != TaskDetailsPageType.EMPTY_SELECTION) break block2;
                    object = this.createEmptyPage();
                    break block3;
                }
                object = this.model.getNodeDescriptorById(pageId);
                if (object == null) break block4;
                Object nodeDescriptor = object;
                boolean bl = false;
                JComponent jComponent = this.createDetailsPage((TasksTreePresentableNodeDescriptor)nodeDescriptor);
                object = jComponent;
                if (jComponent != null) break block3;
            }
            object = new JPanel();
        }
        return object;
    }

    private final JPanel createEmptyPage() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel $this$createEmptyPage_u24lambda_u242 = jPanel = new JPanel();
        boolean bl = false;
        $this$createEmptyPage_u24lambda_u242.setLayout(new BorderLayout());
        $this$createEmptyPage_u24lambda_u242.setName("empty-details");
        JLabel $this$createEmptyPage_u24lambda_u242_u24lambda_u241 = jLabel = new JLabel("Select page for details");
        boolean bl2 = false;
        $this$createEmptyPage_u24lambda_u242_u24lambda_u241.setVerticalAlignment(0);
        $this$createEmptyPage_u24lambda_u242_u24lambda_u241.setHorizontalAlignment(0);
        JLabel messageLabel2 = jLabel;
        $this$createEmptyPage_u24lambda_u242.add((Component)messageLabel2, "Center");
        return jPanel;
    }

    @NotNull
    public final JComponent createDetailsPage(@NotNull TasksTreePresentableNodeDescriptor nodeDescriptor) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)nodeDescriptor, (String)"nodeDescriptor");
        Object object = nodeDescriptor;
        if (object instanceof TaskDetailsNodeDescriptor) {
            jComponent = this.createTaskDetailsPage((TaskDetailsNodeDescriptor)nodeDescriptor);
        } else if (object instanceof EntryDetailsNodeDescriptor) {
            jComponent = this.createEntryDetailsPage((EntryDetailsNodeDescriptor)nodeDescriptor);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object $this$createDetailsPage_u24lambda_u243 = object = jComponent;
        boolean bl = false;
        ((Component)$this$createDetailsPage_u24lambda_u243).setName(nodeDescriptor.getPageId().getId());
        return object;
    }

    private final JComponent createTaskDetailsPage(TaskDetailsNodeDescriptor descriptor2) {
        return BuildAttributionPanelsKt.taskDetailsPage(descriptor2.getTaskData(), this.actionHandlers);
    }

    private final JComponent createEntryDetailsPage(EntryDetailsNodeDescriptor descriptor2) {
        JPanel jPanel;
        JPanel $this$createEntryDetailsPage_u24lambda_u244 = jPanel = new JPanel();
        boolean bl = false;
        $this$createEntryDetailsPage_u24lambda_u244.setLayout(new BoxLayout($this$createEntryDetailsPage_u24lambda_u244, 1));
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(this.actionHandlers);
        String detailsPanelHtml = this.entryDetailsHtml(descriptor2, linksHandler);
        JEditorPane htmlLabel = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(detailsPanelHtml, linksHandler);
        htmlLabel.setAlignmentX(0.0f);
        $this$createEntryDetailsPage_u24lambda_u244.add(htmlLabel);
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String entryDetailsHtml(@NotNull EntryDetailsNodeDescriptor descriptor2, @NotNull HtmlLinksHandler linksHandler) {
        List<TaskCategoryIssueUiData> taskCategoryWarnings;
        List<TaskCategoryIssueUiData> taskCategoryInfo;
        void $this$filterTo$iv$iv;
        HtmlBuilder htmlBuilder;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)linksHandler, (String)"linksHandler");
        HtmlBuilder $this$entryDetailsHtml_u24lambda_u248 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        int filteredTasksNumber = descriptor2.getFilteredTaskNodes().size();
        Iterable $this$filter$iv = descriptor2.getFilteredTaskNodes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TaskUiData it = (TaskUiData)element$iv$iv;
            boolean bl2 = false;
            if (!it.getHasWarning()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTasksWithWarnings = (List)destination$iv$iv;
        $this$entryDetailsHtml_u24lambda_u248.addBold(descriptor2.getEntryData().getName()).newline();
        if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData) {
            $this$entryDetailsHtml_u24lambda_u248.add(((CriticalPathTaskCategoryUiData)descriptor2.getEntryData()).getTaskCategoryDescription()).newline().newline();
        }
        $this$entryDetailsHtml_u24lambda_u248.add("Total duration: ").addHtml(BuildAttributionUIUtilKt.durationStringHtml(descriptor2.getFilteredEntryTime().toTimeWithPercentage())).newline();
        $this$entryDetailsHtml_u24lambda_u248.add("Number of tasks: " + BuildAttributionUIUtilKt.withPluralization(filteredTasksNumber, "task")).newline();
        $this$entryDetailsHtml_u24lambda_u248.newline();
        if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData && !((Collection)(taskCategoryInfo = ((CriticalPathTaskCategoryUiData)descriptor2.getEntryData()).getTaskCategoryIssues(TaskCategoryIssue.Severity.INFO, false))).isEmpty()) {
            BuildAttributionUIUtilKt.createTaskCategoryIssueMessage($this$entryDetailsHtml_u24lambda_u248, taskCategoryInfo, linksHandler, this.actionHandlers);
            $this$entryDetailsHtml_u24lambda_u248.newline();
        }
        $this$entryDetailsHtml_u24lambda_u248.addBold("Warnings").newline();
        int warningCount = filteredTasksWithWarnings.size();
        List<TaskCategoryIssueUiData> list2 = taskCategoryWarnings = descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData ? ((CriticalPathTaskCategoryUiData)descriptor2.getEntryData()).getTaskCategoryIssues(TaskCategoryIssue.Severity.WARNING, false) : CollectionsKt.emptyList();
        if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData) {
            warningCount += taskCategoryWarnings.size();
        }
        if (warningCount == 0) {
            if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData) {
                $this$entryDetailsHtml_u24lambda_u248.add("No warnings detected for " + descriptor2.getEntryData().getName() + " category.");
            } else {
                $this$entryDetailsHtml_u24lambda_u248.add("No warnings detected for this plugin.");
            }
        } else {
            if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData) {
                $this$entryDetailsHtml_u24lambda_u248.add(BuildAttributionUIUtilKt.withPluralization(warningCount, "warning") + " associated with " + descriptor2.getEntryData().getName() + " category.").newline();
            } else {
                $this$entryDetailsHtml_u24lambda_u248.add(BuildAttributionUIUtilKt.withPluralization(warningCount, "task") + " with warnings associated with this plugin.").newline();
            }
            if (warningCount > 10) {
                $this$entryDetailsHtml_u24lambda_u248.add("Top 10 warnings shown below, you can find the full list in the tree on the left.").newline();
            }
            if (descriptor2.getEntryData() instanceof CriticalPathTaskCategoryUiData && !((Collection)taskCategoryWarnings).isEmpty()) {
                BuildAttributionUIUtilKt.createTaskCategoryIssueMessage($this$entryDetailsHtml_u24lambda_u248, taskCategoryWarnings, linksHandler, this.actionHandlers);
                warningCount -= taskCategoryWarnings.size();
            }
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)filteredTasksWithWarnings, (int)Math.min(warningCount, 10));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskUiData task2 = (TaskUiData)element$iv;
                boolean bl3 = false;
                String linkToTask2 = linksHandler.actionLink(task2.getTaskPath(), task2.getTaskPath(), new Runnable(this, task2, descriptor2){
                    final /* synthetic */ TaskViewDetailPagesFactory this$0;
                    final /* synthetic */ TaskUiData $task;
                    final /* synthetic */ EntryDetailsNodeDescriptor $descriptor;
                    {
                        this.this$0 = $receiver;
                        this.$task = $task;
                        this.$descriptor = $descriptor;
                    }

                    public final void run() {
                        this.this$0.getActionHandlers().tasksDetailsLinkClicked(TasksPageId.Companion.task(this.$task, this.$descriptor.getEntryData().getModelGrouping()));
                    }
                });
                $this$entryDetailsHtml_u24lambda_u248.beginTable();
                String[] stringArray = new String[]{"<icon alt='Warning' src='AllIcons.General.BalloonWarning'>", linkToTask2};
                $this$entryDetailsHtml_u24lambda_u248.addTableRow(stringArray);
                stringArray = new String[]{"", "Type: " + task2.getTaskType() + "<BR/>Duration: " + BuildAttributionUIUtilKt.durationStringHtml(task2.getExecutionTime())};
                $this$entryDetailsHtml_u24lambda_u248.addTableRow(stringArray);
                $this$entryDetailsHtml_u24lambda_u248.endTable();
                Iterable $this$forEach$iv2 = task2.getIssues();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TaskIssueUiData issue2 = (TaskIssueUiData)element$iv2;
                    boolean bl4 = false;
                    String description2 = StringsKt.replace$default((String)(issue2.getExplanation() + "\n" + linksHandler.externalLink("Learn more", issue2.getHelpLink())), (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null);
                    $this$entryDetailsHtml_u24lambda_u248.addHtml(description2).newline();
                }
            }
        }
        String string = htmlBuilder.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder().apply {\n  \u2026     }\n      }\n    }.html");
        return string;
    }
}

