/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.details;

import com.android.build.attribution.analyzers.AGPUpdateRequired;
import com.android.build.attribution.analyzers.ConfigurationCacheCompatibilityTestFlow;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOff;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOn;
import com.android.build.attribution.analyzers.IncompatiblePluginsDetected;
import com.android.build.attribution.analyzers.NoDataFromSavedResult;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.build.attribution.ui.view.details.ConfigurationCacheRootWarningDetailsView;
import com.android.build.attribution.ui.view.details.ConfigurationCacheWarningDetailsKt;
import com.intellij.ui.components.panels.VerticalLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u001c\u0010\u0016\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/attribution/ui/view/details/ConfigurationCacheRootWarningDetailsView;", "", "uiData", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "projectConfigurationTime", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "(Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;Lcom/android/build/attribution/ui/data/TimeWithPercentage;Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "pagePanel", "Ljavax/swing/JPanel;", "getPagePanel", "()Ljavax/swing/JPanel;", "createAGPUpdateRequiredPanel", "", "Lcom/android/build/attribution/analyzers/AGPUpdateRequired;", "createConfigurationCacheTestFlowPanel", "data", "Lcom/android/build/attribution/analyzers/ConfigurationCacheCompatibilityTestFlow;", "createIncompatiblePluginsDetectedPanel", "Lcom/android/build/attribution/analyzers/IncompatiblePluginsDetected;", "configurationTime", "createNoIncompatiblePluginsPanel", "Lcom/android/build/attribution/analyzers/NoIncompatiblePlugins;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheWarningDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheWarningDetails.kt\ncom/android/build/attribution/ui/view/details/ConfigurationCacheRootWarningDetailsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class ConfigurationCacheRootWarningDetailsView {
    @NotNull
    private final ConfigurationCachingCompatibilityProjectResult uiData;
    @NotNull
    private final TimeWithPercentage projectConfigurationTime;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final JPanel pagePanel;

    /*
     * WARNING - void declaration
     */
    public ConfigurationCacheRootWarningDetailsView(@NotNull ConfigurationCachingCompatibilityProjectResult uiData, @NotNull TimeWithPercentage projectConfigurationTime, @NotNull ViewActionHandlers actionHandlers) {
        void $this$pagePanel_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)uiData, (String)"uiData");
        Intrinsics.checkNotNullParameter((Object)projectConfigurationTime, (String)"projectConfigurationTime");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        this.uiData = uiData;
        this.projectConfigurationTime = projectConfigurationTime;
        this.actionHandlers = actionHandlers;
        JPanel jPanel2 = jPanel = new JPanel();
        ConfigurationCacheRootWarningDetailsView configurationCacheRootWarningDetailsView = this;
        boolean bl = false;
        $this$pagePanel_u24lambda_u240.setLayout((LayoutManager)new VerticalLayout(10, 2));
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = this.uiData;
        if (configurationCachingCompatibilityProjectResult instanceof AGPUpdateRequired) {
            this.createAGPUpdateRequiredPanel((JPanel)$this$pagePanel_u24lambda_u240, (AGPUpdateRequired)this.uiData, this.projectConfigurationTime);
        } else if (configurationCachingCompatibilityProjectResult instanceof NoIncompatiblePlugins) {
            this.createNoIncompatiblePluginsPanel((JPanel)$this$pagePanel_u24lambda_u240, (NoIncompatiblePlugins)this.uiData, this.projectConfigurationTime);
        } else if (configurationCachingCompatibilityProjectResult instanceof IncompatiblePluginsDetected) {
            this.createIncompatiblePluginsDetectedPanel((JPanel)$this$pagePanel_u24lambda_u240, (IncompatiblePluginsDetected)this.uiData, this.projectConfigurationTime);
        } else if (configurationCachingCompatibilityProjectResult instanceof ConfigurationCacheCompatibilityTestFlow) {
            this.createConfigurationCacheTestFlowPanel((JPanel)$this$pagePanel_u24lambda_u240, (ConfigurationCacheCompatibilityTestFlow)this.uiData);
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOn.INSTANCE) || Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOff.INSTANCE) || Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)NoDataFromSavedResult.INSTANCE)) {
            // empty if block
        }
        configurationCacheRootWarningDetailsView.pagePanel = jPanel;
    }

    @NotNull
    public final JPanel getPagePanel() {
        return this.pagePanel;
    }

    /*
     * WARNING - void declaration
     */
    private final void createAGPUpdateRequiredPanel(JPanel $this$createAGPUpdateRequiredPanel, AGPUpdateRequired uiData, TimeWithPercentage projectConfigurationTime) {
        void $this$createAGPUpdateRequiredPanel_u24lambda_u241;
        JButton jButton;
        String appliedAGPPluginsList2 = CollectionsKt.joinToString$default((Iterable)uiData.getAppliedPlugins(), (CharSequence)"", (CharSequence)"Android Gradle plugins applied in this build:<ul>", (CharSequence)"</ul>", (int)0, null, (Function1)createAGPUpdateRequiredPanel.appliedAGPPluginsList.1.INSTANCE, (int)24, null);
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(this.actionHandlers);
        String contentHtml = BuildAttributionUIUtilKt.insertBRTags(StringsKt.trimIndent((String)("\n        <b>Android Gradle plugin update required to make Configuration cache available</b>\n        " + ConfigurationCacheWarningDetailsKt.access$configurationCachingDescriptionHeader(projectConfigurationTime, linksHandler) + "\n        Android Gradle plugin supports Configuration cache from " + uiData.getRecommendedVersion() + ". Current version is " + uiData.getCurrentVersion() + ".\n        \n        " + appliedAGPPluginsList2 + "\n      ")));
        $this$createAGPUpdateRequiredPanel.add(ConfigurationCacheWarningDetailsKt.access$alignWithButton(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(contentHtml, linksHandler)));
        JButton jButton2 = jButton = new JButton("Update Android Gradle plugin");
        JPanel jPanel = $this$createAGPUpdateRequiredPanel;
        boolean bl = false;
        $this$createAGPUpdateRequiredPanel_u24lambda_u241.addActionListener(new ActionListener(this){
            final /* synthetic */ ConfigurationCacheRootWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ConfigurationCacheRootWarningDetailsView.access$getActionHandlers$p(this.this$0).runAgpUpgrade();
            }
        });
        jPanel.add(jButton);
    }

    private final void createIncompatiblePluginsDetectedPanel(JPanel $this$createIncompatiblePluginsDetectedPanel, IncompatiblePluginsDetected uiData, TimeWithPercentage configurationTime) {
        Object object;
        Object object2;
        int it = uiData.getIncompatiblePluginWarnings().size();
        boolean bl = false;
        switch (it) {
            case 0: {
                object2 = null;
                break;
            }
            case 1: {
                object2 = "1 plugin is not known to have a compatible version yet, please contact plugin providers for details.";
                break;
            }
            default: {
                object2 = it + " plugins are not known to have a compatible version yet, please contact plugin providers for details.";
            }
        }
        Object incompatiblePluginsCountLine = object2;
        int it22 = uiData.getUpgradePluginWarnings().size();
        boolean bl2 = false;
        switch (it22) {
            case 0: {
                object = null;
                break;
            }
            case 1: {
                object = "1 plugin can be updated to the compatible version.";
                break;
            }
            default: {
                object = it22 + " plugins can be updated to the compatible version.";
            }
        }
        Object upgradablePluginsCountLine = object;
        Object[] it22 = new String[]{upgradablePluginsCountLine, incompatiblePluginsCountLine};
        String pluginsCountLines2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])it22)), (CharSequence)"", (CharSequence)"<ul>", (CharSequence)"</ul>", (int)0, null, (Function1)createIncompatiblePluginsDetectedPanel.pluginsCountLines.1.INSTANCE, (int)24, null);
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(this.actionHandlers);
        String contentHtml = BuildAttributionUIUtilKt.insertBRTags(StringsKt.trimIndent((String)("\n        <b>Some plugins are not compatible with Configuration cache</b>\n        " + ConfigurationCacheWarningDetailsKt.access$configurationCachingDescriptionHeader(configurationTime, linksHandler) + "\n        Some of the plugins applied are known to be not compatible with Configuration cache in versions used in this build.\n        " + pluginsCountLines2 + "\n        You can find details on each plugin on corresponding sub-pages.\n      ")));
        $this$createIncompatiblePluginsDetectedPanel.add(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(contentHtml, linksHandler));
    }

    private final void createNoIncompatiblePluginsPanel(JPanel $this$createNoIncompatiblePluginsPanel, NoIncompatiblePlugins uiData, TimeWithPercentage configurationTime) {
        JButton jButton;
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(this.actionHandlers);
        String contentHtml = BuildAttributionUIUtilKt.insertBRTags(StringsKt.trimIndent((String)("\n        <b>Try to turn Configuration cache on</b>\n        " + ConfigurationCacheWarningDetailsKt.access$configurationCachingDescriptionHeader(configurationTime, linksHandler) + "\n        The known plugins applied in this build are compatible with Configuration cache.\n      ")));
        JButton $this$createNoIncompatiblePluginsPanel_u24lambda_u244 = jButton = new JButton("Try Configuration cache in a build");
        boolean bl = false;
        $this$createNoIncompatiblePluginsPanel_u24lambda_u244.addActionListener(new ActionListener(this){
            final /* synthetic */ ConfigurationCacheRootWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ConfigurationCacheRootWarningDetailsView.access$getActionHandlers$p(this.this$0).runTestConfigurationCachingBuild();
            }
        });
        JButton runTestBuildActionButton2 = jButton;
        String unknownPluginsNoteHtml = uiData.getConfigurationCacheIsStableFeature() ? BuildAttributionUIUtilKt.insertBRTags("Note: There could be unknown plugins that aren't compatible and are discovered after\nyou build with Configuration cache turned on.") : BuildAttributionUIUtilKt.insertBRTags("Note: <b>Configuration cache is currently an experimental Gradle feature.</b> There could be unknown plugins that aren't compatible and are discovered after\nyou build with Configuration cache turned on.");
        String unknownPluginsListHtml2 = CollectionsKt.joinToString$default((Iterable)uiData.getUnrecognizedPlugins(), (CharSequence)"", (CharSequence)"<b>List of applied plugins we were not able to recognise:</b><ul>", (CharSequence)"</ul>", (int)0, null, (Function1)createNoIncompatiblePluginsPanel.unknownPluginsListHtml.1.INSTANCE, (int)24, null);
        $this$createNoIncompatiblePluginsPanel.add(ConfigurationCacheWarningDetailsKt.access$alignWithButton(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(contentHtml, linksHandler)));
        $this$createNoIncompatiblePluginsPanel.add(ConfigurationCacheWarningDetailsKt.access$alignWithButton(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(unknownPluginsNoteHtml, null, 2, null)));
        $this$createNoIncompatiblePluginsPanel.add(runTestBuildActionButton2);
        if (!((Collection)uiData.getUnrecognizedPlugins()).isEmpty()) {
            $this$createNoIncompatiblePluginsPanel.add(ConfigurationCacheWarningDetailsKt.access$alignWithButton(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(unknownPluginsListHtml2, null, 2, null)));
        }
    }

    private final void createConfigurationCacheTestFlowPanel(JPanel $this$createConfigurationCacheTestFlowPanel, ConfigurationCacheCompatibilityTestFlow data) {
        JButton jButton;
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(this.actionHandlers);
        String configurationCacheLink = linksHandler.externalLink("Configuration cache", BuildAnalyzerBrowserLinks.CONFIGURATION_CACHING);
        String contentHtml = BuildAttributionUIUtilKt.insertBRTags(StringsKt.trimIndent((String)("\n      <b>Test builds with Configuration cache finished successfully</b>\n      With " + configurationCacheLink + ", Gradle can skip the configuration phase entirely when nothing that affects the build configuration has changed.\n      \n      Gradle successfully serialized the task graph and reused it with Configuration cache on.\n      ")));
        JButton $this$createConfigurationCacheTestFlowPanel_u24lambda_u245 = jButton = new JButton("Turn on Configuration cache in gradle.properties");
        boolean bl = false;
        $this$createConfigurationCacheTestFlowPanel_u24lambda_u245.addActionListener(new ActionListener(this, data){
            final /* synthetic */ ConfigurationCacheRootWarningDetailsView this$0;
            final /* synthetic */ ConfigurationCacheCompatibilityTestFlow $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
            }

            public final void actionPerformed(ActionEvent it) {
                ConfigurationCacheRootWarningDetailsView.access$getActionHandlers$p(this.this$0).turnConfigurationCachingOnInProperties(this.$data.getConfigurationCacheIsStableFeature());
            }
        });
        JButton addToPropertiesActionButton2 = jButton;
        $this$createConfigurationCacheTestFlowPanel.add(ConfigurationCacheWarningDetailsKt.access$alignWithButton(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(contentHtml, linksHandler)));
        $this$createConfigurationCacheTestFlowPanel.add(addToPropertiesActionButton2);
    }

    public static final /* synthetic */ ViewActionHandlers access$getActionHandlers$p(ConfigurationCacheRootWarningDetailsView $this) {
        return $this.actionHandlers;
    }
}

