/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.AGPUpdateRequired;
import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.ConfigurationCacheCompatibilityTestFlow;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOff;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOn;
import com.android.build.attribution.analyzers.IncompatiblePluginsDetected;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsageProjectStatus;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.analyzers.NoDataFromSavedResult;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.CriticalPathTaskCategoryUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\n\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"rightAlignedNodeDurationTextFromMs", "", "timeMs", "", "countTotalWarnings", "", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "shouldShowWarning", "", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "warningsCount", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nWarningsDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarningsDataPageModel.kt\ncom/android/build/attribution/ui/model/WarningsDataPageModelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,583:1\n1#2:584\n*E\n"})
public final class WarningsDataPageModelKt {
    private static final int warningsCount(ConfigurationCachingCompatibilityProjectResult $this$warningsCount) {
        int n;
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = $this$warningsCount;
        if (configurationCachingCompatibilityProjectResult instanceof AGPUpdateRequired) {
            n = 1;
        } else if (configurationCachingCompatibilityProjectResult instanceof IncompatiblePluginsDetected) {
            n = ((IncompatiblePluginsDetected)$this$warningsCount).getIncompatiblePluginWarnings().size() + ((IncompatiblePluginsDetected)$this$warningsCount).getUpgradePluginWarnings().size();
        } else if (configurationCachingCompatibilityProjectResult instanceof NoIncompatiblePlugins) {
            n = 1;
        } else if (configurationCachingCompatibilityProjectResult instanceof ConfigurationCacheCompatibilityTestFlow) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOn.INSTANCE)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOff.INSTANCE)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)NoDataFromSavedResult.INSTANCE)) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final boolean shouldShowWarning(@NotNull ConfigurationCachingCompatibilityProjectResult $this$shouldShowWarning) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldShowWarning, (String)"<this>");
        return WarningsDataPageModelKt.warningsCount($this$shouldShowWarning) != 0;
    }

    public static final boolean shouldShowWarning(@NotNull JetifierUsageAnalyzerResult $this$shouldShowWarning) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$shouldShowWarning, (String)"<this>");
        JetifierUsageProjectStatus jetifierUsageProjectStatus = $this$shouldShowWarning.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)AnalyzerNotRun.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierNotUsed.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierCanBeRemoved.INSTANCE)) {
            bl = true;
        } else if (jetifierUsageProjectStatus instanceof JetifierRequiredForLibraries) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final String rightAlignedNodeDurationTextFromMs(long timeMs) {
        String string;
        if (timeMs >= 100L) {
            String string2 = "%.1fs";
            Object[] objectArray = new Object[]{(double)timeMs / (double)1000};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        } else {
            string = "<0.1s";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final int countTotalWarnings(@NotNull BuildAttributionReportUiData $this$countTotalWarnings) {
        int n;
        CriticalPathTaskCategoryUiData it;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$countTotalWarnings, (String)"<this>");
        Iterable iterable = $this$countTotalWarnings.getIssues();
        int n3 = 0;
        for (Object t : iterable) {
            TaskIssuesGroup taskIssuesGroup = (TaskIssuesGroup)t;
            n2 = n3;
            boolean bl = false;
            n = it.getWarningCount();
            n3 = n2 + n;
        }
        int n4 = n3 + $this$countTotalWarnings.getAnnotationProcessors().getIssueCount() + WarningsDataPageModelKt.warningsCount($this$countTotalWarnings.getConfCachingData());
        Object object = $this$countTotalWarnings.getCriticalPathTaskCategories();
        if (object == null || (object = object.getEntries()) == null) {
            object = CollectionsKt.emptyList();
        }
        iterable = (Iterable)object;
        n2 = n4;
        n3 = 0;
        for (Object t : iterable) {
            void category;
            it = (CriticalPathTaskCategoryUiData)t;
            n = n3;
            boolean bl = false;
            int n5 = category.getTaskCategoryIssues(TaskCategoryIssue.Severity.WARNING, true).size();
            n3 = n + n5;
        }
        n = n3;
        return n2 + n + (WarningsDataPageModelKt.shouldShowWarning($this$countTotalWarnings.getJetifierData()) ? 1 : 0);
    }

    public static final /* synthetic */ int access$warningsCount(ConfigurationCachingCompatibilityProjectResult $receiver) {
        return WarningsDataPageModelKt.warningsCount($receiver);
    }

    public static final /* synthetic */ String access$rightAlignedNodeDurationTextFromMs(long timeMs) {
        return WarningsDataPageModelKt.rightAlignedNodeDurationTextFromMs(timeMs);
    }
}

