/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/attribution/ui/model/TasksFilterToggleAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ui/popup/KeepingPopupOpenAction;", "uiName", "", "tasksModel", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "(Ljava/lang/String;Lcom/android/build/attribution/ui/model/TasksDataPageModel;Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "getActionHandlers", "()Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "getTasksModel", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "toggleableIcon", "Lcom/intellij/ui/LayeredIcon;", "toggleableSelectedIcon", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "filter", "Lcom/android/build/attribution/ui/model/TasksFilter;", "onAdd", "onRemove", "setSelected", "state", "update", "intellij.android.build-attribution"})
public abstract class TasksFilterToggleAction
extends AnAction
implements DumbAware,
KeepingPopupOpenAction {
    @NotNull
    private final TasksDataPageModel tasksModel;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final LayeredIcon toggleableIcon;
    @NotNull
    private final LayeredIcon toggleableSelectedIcon;

    public TasksFilterToggleAction(@NotNull String uiName, @NotNull TasksDataPageModel tasksModel, @NotNull ViewActionHandlers actionHandlers) {
        Intrinsics.checkNotNullParameter((Object)uiName, (String)"uiName");
        Intrinsics.checkNotNullParameter((Object)tasksModel, (String)"tasksModel");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        super(uiName);
        this.tasksModel = tasksModel;
        this.actionHandlers = actionHandlers;
        Icon[] iconArray = new Icon[]{EmptyIcon.ICON_16, LafIconLookup.getIcon$default((String)"checkmark", (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)62, null)};
        this.toggleableIcon = new LayeredIcon(iconArray);
        iconArray = new Icon[]{EmptyIcon.ICON_16, LafIconLookup.getSelectedIcon((String)"checkmark")};
        this.toggleableSelectedIcon = new LayeredIcon(iconArray);
        this.getTemplatePresentation().setIcon((Icon)this.toggleableIcon);
        this.getTemplatePresentation().setSelectedIcon((Icon)this.toggleableSelectedIcon);
    }

    @NotNull
    public final TasksDataPageModel getTasksModel() {
        return this.tasksModel;
    }

    @NotNull
    public final ViewActionHandlers getActionHandlers() {
        return this.actionHandlers;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        boolean selected = this.isSelected(this.tasksModel.getFilter());
        this.toggleableIcon.setLayerEnabled(1, selected);
        this.toggleableSelectedIcon.setLayerEnabled(1, selected);
    }

    private final void setSelected(boolean state2) {
        this.toggleableIcon.setLayerEnabled(1, state2);
        this.toggleableSelectedIcon.setLayerEnabled(1, state2);
        TasksFilter updatedFilter = state2 ? this.onAdd(this.tasksModel.getFilter()) : this.onRemove(this.tasksModel.getFilter());
        this.actionHandlers.applyTasksFilter(updatedFilter);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setSelected(!this.isSelected(this.tasksModel.getFilter()));
    }

    @NotNull
    public abstract TasksFilter onAdd(@NotNull TasksFilter var1);

    @NotNull
    public abstract TasksFilter onRemove(@NotNull TasksFilter var1);

    public abstract boolean isSelected(@NotNull TasksFilter var1);
}

