/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.TaskDetailsPageType;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TasksTreeStructure;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020 0\u001cH\u0016J\u0010\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u0006H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020+H\u0016J\b\u0010B\u001a\u00020 H\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020$H\u0016J\u0012\u0010E\u001a\u00020 2\b\u0010F\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020+H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u001a\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001e\u0010,\u001a\u00020+2\u0006\u0010\u0005\u001a\u00020+@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0014\u00101\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000fR\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/android/build/attribution/ui/model/TasksDataPageModelImpl;", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;)V", "value", "Lcom/android/build/attribution/ui/model/TasksFilter;", "filter", "getFilter", "()Lcom/android/build/attribution/ui/model/TasksFilter;", "setFilter", "(Lcom/android/build/attribution/ui/model/TasksFilter;)V", "filteredTimeString", "", "getFilteredTimeString", "()Ljava/lang/String;", "isEmpty", "", "()Z", "listenersCount", "", "getListenersCount$annotations", "()V", "getListenersCount", "()I", "modelChanged", "modelUpdatedListeners", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "treeStructureChanged", "", "getReportData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "selectedGrouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "getSelectedGrouping", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "selectedNode", "Lcom/android/build/attribution/ui/model/TasksTreeNode;", "getSelectedNode", "()Lcom/android/build/attribution/ui/model/TasksTreeNode;", "Lcom/android/build/attribution/ui/model/TasksPageId;", "selectedPageId", "setSelectedPageId", "(Lcom/android/build/attribution/ui/model/TasksPageId;)V", "totalTimeString", "getTotalTimeString", "treeHeaderText", "getTreeHeaderText", "treeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getTreeRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "treeStructure", "Lcom/android/build/attribution/ui/model/TasksTreeStructure;", "addModelUpdatedListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "applyFilter", "newFilter", "getNodeDescriptorById", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "pageId", "notifyModelChanges", "selectGrouping", "newSelectedGrouping", "selectNode", "tasksTreeNode", "selectPageById", "tasksPageId", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTasksDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksDataPageModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n1851#2,2:438\n*S KotlinDebug\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksDataPageModelImpl\n*L\n219#1:438,2\n*E\n"})
public final class TasksDataPageModelImpl
implements TasksDataPageModel {
    @NotNull
    private final BuildAttributionReportUiData reportData;
    @NotNull
    private final List<Function1<Boolean, Unit>> modelUpdatedListeners;
    @NotNull
    private TasksFilter filter;
    private boolean modelChanged;
    private boolean treeStructureChanged;
    @NotNull
    private TasksPageId selectedPageId;
    @NotNull
    private final TasksTreeStructure treeStructure;

    /*
     * WARNING - void declaration
     */
    public TasksDataPageModelImpl(@NotNull BuildAttributionReportUiData reportData) {
        void $this$treeStructure_u24lambda_u240;
        TasksTreeStructure tasksTreeStructure;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        this.reportData = reportData;
        this.modelUpdatedListeners = new CopyOnWriteArrayList();
        this.filter = TasksFilter.Companion.getDEFAULT();
        this.selectedPageId = TasksPageId.Companion.emptySelection(this.getDefaultGrouping());
        TasksTreeStructure tasksTreeStructure2 = tasksTreeStructure = new TasksTreeStructure(this.getReportData());
        TasksDataPageModelImpl tasksDataPageModelImpl = this;
        boolean bl = false;
        $this$treeStructure_u24lambda_u240.updateStructure(this.getSelectedGrouping(), this.getFilter());
        tasksDataPageModelImpl.treeStructure = tasksTreeStructure;
    }

    @Override
    @NotNull
    public BuildAttributionReportUiData getReportData() {
        return this.reportData;
    }

    public final int getListenersCount() {
        return this.modelUpdatedListeners.size();
    }

    @VisibleForTesting
    public static /* synthetic */ void getListenersCount$annotations() {
    }

    @Override
    @NotNull
    public TasksDataPageModel.Grouping getSelectedGrouping() {
        return this.selectedPageId.getGrouping();
    }

    @Override
    @NotNull
    public String getTreeHeaderText() {
        return this.treeStructure.getTreeStats().getFiltersAreApplied() ? "Tasks duration - Total: " + this.getTotalTimeString() + ", Filtered: " + this.getFilteredTimeString() : "Tasks duration: " + this.getTotalTimeString();
    }

    private final String getTotalTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getTotalTasksTimeMs());
    }

    private final String getFilteredTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getFilteredTasksTimeMs());
    }

    @Override
    @NotNull
    public DefaultMutableTreeNode getTreeRoot() {
        return this.treeStructure.getTreeRoot();
    }

    @Override
    @Nullable
    public TasksTreeNode getSelectedNode() {
        return this.treeStructure.getPageIdToNode().get(this.selectedPageId);
    }

    @Override
    @NotNull
    public TasksFilter getFilter() {
        return this.filter;
    }

    private void setFilter(TasksFilter value2) {
        this.filter = value2;
        this.treeStructure.updateStructure(this.getSelectedGrouping(), value2);
        this.treeStructureChanged = true;
        this.modelChanged = true;
    }

    @Override
    public boolean isEmpty() {
        return this.getReportData().getCriticalPathTasks().getSize() == 0;
    }

    private final void setSelectedPageId(TasksPageId value2) {
        TasksPageId newSelectedPageId;
        TasksDataPageModel.Grouping newSelectedGrouping = value2.getGrouping();
        if (newSelectedGrouping != this.selectedPageId.getGrouping()) {
            this.treeStructure.updateStructure(newSelectedGrouping, this.getFilter());
            this.treeStructureChanged = true;
            this.modelChanged = true;
        }
        TasksPageId tasksPageId = newSelectedPageId = this.treeStructure.getPageIdToNode().containsKey(value2) ? value2 : TasksPageId.Companion.emptySelection(newSelectedGrouping);
        if (!Intrinsics.areEqual((Object)newSelectedPageId, (Object)this.selectedPageId)) {
            this.selectedPageId = newSelectedPageId;
            this.modelChanged = true;
        }
    }

    @Override
    public void selectGrouping(@NotNull TasksDataPageModel.Grouping newSelectedGrouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSelectedGrouping), (String)"newSelectedGrouping");
        TasksPageId currentPageId = this.selectedPageId;
        TasksPageId newSelectedPageId = currentPageId.getPageType() == TaskDetailsPageType.PLUGIN_DETAILS && newSelectedGrouping == TasksDataPageModel.Grouping.BY_PLUGIN || currentPageId.getPageType() == TaskDetailsPageType.TASK_CATEGORY_DETAILS && newSelectedGrouping == TasksDataPageModel.Grouping.BY_TASK_CATEGORY ? TasksPageId.Companion.emptySelection(newSelectedGrouping) : TasksPageId.copy$default(currentPageId, newSelectedGrouping, null, null, 6, null);
        this.setSelectedPageId(newSelectedPageId);
        this.notifyModelChanges();
    }

    @Override
    public void selectNode(@Nullable TasksTreeNode tasksTreeNode) {
        TasksDataPageModel.Grouping currentGrouping = this.getSelectedGrouping();
        Object object = tasksTreeNode;
        if (object == null || (object = ((TasksTreeNode)object).getDescriptor()) == null || (object = ((TasksTreePresentableNodeDescriptor)object).getPageId()) == null) {
            object = TasksPageId.Companion.emptySelection(currentGrouping);
        }
        this.setSelectedPageId((TasksPageId)object);
        this.notifyModelChanges();
    }

    @Override
    public void selectPageById(@NotNull TasksPageId tasksPageId) {
        Intrinsics.checkNotNullParameter((Object)tasksPageId, (String)"tasksPageId");
        this.setSelectedPageId(tasksPageId);
        this.notifyModelChanges();
    }

    @Override
    public void applyFilter(@NotNull TasksFilter newFilter) {
        Intrinsics.checkNotNullParameter((Object)newFilter, (String)"newFilter");
        this.setFilter(newFilter);
        this.notifyModelChanges();
    }

    @Override
    public void addModelUpdatedListener(@NotNull Disposable disposable2, @NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.modelUpdatedListeners.add(listener2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, listener2){
            final /* synthetic */ TasksDataPageModelImpl this$0;
            final /* synthetic */ Function1<Boolean, Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public final void dispose() {
                TasksDataPageModelImpl.access$getModelUpdatedListeners$p(this.this$0).remove(this.$listener);
            }
        });
    }

    @Override
    @Nullable
    public TasksTreePresentableNodeDescriptor getNodeDescriptorById(@NotNull TasksPageId pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        TasksTreeNode tasksTreeNode = this.treeStructure.getPageIdToNode().get(pageId);
        return tasksTreeNode != null ? tasksTreeNode.getDescriptor() : null;
    }

    private final void notifyModelChanges() {
        if (this.modelChanged) {
            Iterable $this$forEach$iv = this.modelUpdatedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this.treeStructureChanged);
            }
            this.treeStructureChanged = false;
            this.modelChanged = false;
        }
    }

    public static final /* synthetic */ List access$getModelUpdatedListeners$p(TasksDataPageModelImpl $this) {
        return $this.modelUpdatedListeners;
    }
}

