/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.model.RequestsListTableModel;
import com.intellij.openapi.util.text.Formats;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0004\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "()V", "MyCellRenderer", "MyStatusColumnCellRenderer", "StatusColumnData", "intellij.android.build-attribution"})
public final class RequestsListTableModel
extends ListTableModel<DownloadsAnalyzer.DownloadResult> {
    public RequestsListTableModel() {
        super(new ColumnInfo[0]);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<DownloadsAnalyzer.DownloadResult, StatusColumnData>(){
            @NotNull
            private final MyStatusColumnCellRenderer cellRenderer = new MyStatusColumnCellRenderer();

            @NotNull
            public final MyStatusColumnCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public StatusColumnData valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                String string = item2.getFailureMessage();
                String formattedTooltip = string != null ? StringsKt.replace$default((String)string, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null) : null;
                return switch (WhenMappings.$EnumSwitchMapping$0[item2.getStatus().ordinal()]) {
                    case 1 -> new StatusColumnData("Ok", null, formattedTooltip);
                    case 2 -> new StatusColumnData("Not Found", BuildAttributionUIUtilKt.warningIcon(), formattedTooltip);
                    case 3 -> new StatusColumnData("Error", BuildAttributionUIUtilKt.warningIcon(), formattedTooltip);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "Not Found";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public int getAdditionalWidth() {
                return BuildAttributionUIUtilKt.warningIcon().getIconWidth();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.status }");
                return comparator2;
            }

            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[DownloadsAnalyzer.DownloadStatus.values().length];
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.SUCCESS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.MISSED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.FAILURE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return item2.getUrl();
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.url }");
                return comparator2;
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return BuildAttributionUIUtilKt.durationString(item2.getDuration());
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "###.#s";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.duration }");
                return comparator2;
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                String string = Formats.formatFileSize((long)item2.getBytes());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(item.bytes)");
                return string;
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "123.45MB";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.bytes }");
                return comparator2;
            }
        }};
        this.setColumnInfos(columnInfoArray);
        this.setSortable(true);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$MyCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "(Lcom/intellij/ui/SimpleTextAttributes;)V", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.android.build-attribution"})
    private static final class MyCellRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final SimpleTextAttributes textAttributes;

        public MyCellRenderer(@NotNull SimpleTextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            this.textAttributes = textAttributes;
        }

        @NotNull
        public final SimpleTextAttributes getTextAttributes() {
            return this.textAttributes;
        }

        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof String) {
                this.append((String)value2, this.textAttributes);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$MyStatusColumnCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "()V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.android.build-attribution"})
    private static final class MyStatusColumnCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row2, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof StatusColumnData) {
                this.setIcon(((StatusColumnData)value2).getIcon());
                this.setTransparentIconBackground(true);
                this.append(((StatusColumnData)value2).getText(), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
                this.setToolTipText(((StatusColumnData)value2).getTooltip());
            }
            this.setTextAlign(4);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$StatusColumnData;", "", "text", "", "icon", "Ljavax/swing/Icon;", "tooltip", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getText", "()Ljava/lang/String;", "getTooltip", "toString", "intellij.android.build-attribution"})
    private static final class StatusColumnData {
        @NotNull
        private final String text;
        @Nullable
        private final Icon icon;
        @Nullable
        private final String tooltip;

        public StatusColumnData(@NotNull String text2, @Nullable Icon icon2, @Nullable String tooltip2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.icon = icon2;
            this.tooltip = tooltip2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String toString() {
            return this.text;
        }
    }
}

