/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/attribution/ui/model/FilterCustomComponent;", "Ljavax/swing/JPanel;", "filterActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "subscribeToModelUpdates", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "", "getModelUIText", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/actionSystem/ActionGroup;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getFilterActions", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "getGetModelUIText", "()Lkotlin/jvm/functions/Function0;", "nameLabel", "Ljavax/swing/JLabel;", "popupState", "Lcom/intellij/ui/popup/util/PopupState;", "getSubscribeToModelUpdates", "()Lkotlin/jvm/functions/Function1;", "valueLabel", "installFocusIndication", "installShowPopupMenuFromKeyboard", "installShowPopupMenuOnClick", "showPopupMenu", "intellij.android.build-attribution"})
final class FilterCustomComponent
extends JPanel {
    @NotNull
    private final ActionGroup filterActions;
    @NotNull
    private final Function1<Runnable, Unit> subscribeToModelUpdates;
    @NotNull
    private final Function0<String> getModelUIText;
    @NotNull
    private final PopupState popupState;
    @NotNull
    private final JLabel nameLabel;
    @NotNull
    private final JLabel valueLabel;

    public FilterCustomComponent(@NotNull ActionGroup filterActions, @NotNull Function1<? super Runnable, Unit> subscribeToModelUpdates, @NotNull Function0<String> getModelUIText) {
        Intrinsics.checkNotNullParameter((Object)filterActions, (String)"filterActions");
        Intrinsics.checkNotNullParameter(subscribeToModelUpdates, (String)"subscribeToModelUpdates");
        Intrinsics.checkNotNullParameter(getModelUIText, (String)"getModelUIText");
        this.filterActions = filterActions;
        this.subscribeToModelUpdates = subscribeToModelUpdates;
        this.getModelUIText = getModelUIText;
        this.popupState = new PopupState();
        this.nameLabel = new JLabel("Filters: ");
        this.valueLabel = new JLabel((String)this.getModelUIText.invoke());
        this.setLayout(new BoxLayout(this, 0));
        this.setFocusable(true);
        this.add(this.nameLabel);
        this.add(this.valueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.subscribeToModelUpdates.invoke((Object)new Runnable(){

            @Override
            public final void run() {
                valueLabel.setText((String)this.getGetModelUIText().invoke());
            }
        });
        this.installShowPopupMenuOnClick();
        this.installShowPopupMenuFromKeyboard();
        this.installFocusIndication();
    }

    @NotNull
    public final ActionGroup getFilterActions() {
        return this.filterActions;
    }

    @NotNull
    public final Function1<Runnable, Unit> getSubscribeToModelUpdates() {
        return this.subscribeToModelUpdates;
    }

    @NotNull
    public final Function0<String> getGetModelUIText() {
        return this.getModelUIText;
    }

    private final void installFocusIndication() {
        FilterCustomComponent.installFocusIndication$setUnFocusedBorder(this);
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ FilterCustomComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterCustomComponent.access$installFocusIndication$setFocusedBorder(this.this$0);
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterCustomComponent.access$installFocusIndication$setUnFocusedBorder(this.this$0);
            }
        });
    }

    private final void installShowPopupMenuOnClick() {
        new ClickListener(this){
            final /* synthetic */ FilterCustomComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(@NotNull MouseEvent event2, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                FilterCustomComponent.access$showPopupMenu(this.this$0);
                return true;
            }
        }.installOn((Component)this);
    }

    private final void installShowPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FilterCustomComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40 || e.getKeyCode() == 32) {
                    FilterCustomComponent.access$showPopupMenu(this.this$0);
                }
            }
        });
    }

    private final void showPopupMenu() {
        if (this.popupState.isRecentlyHidden()) {
            return;
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.filterActions, DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance().createActi\u2026DSEARCH,\n      true\n    )");
        ListPopup popup2 = listPopup;
        popup2.addListener((JBPopupListener)this.popupState);
        AutoPopupSupportingListener.installOn((JBPopup)((JBPopup)popup2));
        popup2.showUnderneathOf((Component)this);
    }

    private static final void installFocusIndication$setFocusedBorder(FilterCustomComponent this$0) {
        this$0.setBorder(BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(UIUtil.getFocusedBorderColor(), 10, 2), JBUI.Borders.empty((int)2)));
    }

    private static final void installFocusIndication$setUnFocusedBorder(FilterCustomComponent this$0) {
        this$0.setBorder(JBUI.Borders.empty((int)4));
    }

    public static final /* synthetic */ void access$installFocusIndication$setFocusedBorder(FilterCustomComponent this$0) {
        FilterCustomComponent.installFocusIndication$setFocusedBorder(this$0);
    }

    public static final /* synthetic */ void access$installFocusIndication$setUnFocusedBorder(FilterCustomComponent this$0) {
        FilterCustomComponent.installFocusIndication$setUnFocusedBorder(this$0);
    }

    public static final /* synthetic */ void access$showPopupMenu(FilterCustomComponent $this) {
        $this.showPopupMenu();
    }
}

