/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.CriticalPathEntryUiData;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.CriticalPathTaskCategoryUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TimeDistributionBuilder;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0014\u001a\u00060\u0015R\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor;", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "entryData", "Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;", "filteredTaskNodes", "", "Lcom/android/build/attribution/ui/data/TaskUiData;", "timeDistributionBuilder", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;", "(Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;Ljava/util/List;Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;)V", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "chartItemColor", "Ljava/awt/Color;", "getChartItemColor", "()Ljava/awt/Color;", "getEntryData", "()Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;", "filteredEntryTime", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "getFilteredEntryTime", "()Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "getFilteredTaskNodes", "()Ljava/util/List;", "filteredWarningCount", "", "getFilteredWarningCount", "()I", "pageId", "Lcom/android/build/attribution/ui/model/TasksPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/TasksPageId;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "relativeWeight", "", "getRelativeWeight", "()D", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTasksDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,437:1\n1770#2,4:438\n171#3,5:442\n*S KotlinDebug\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor\n*L\n375#1:438,4\n376#1:442,5\n*E\n"})
public final class EntryDetailsNodeDescriptor
extends TasksTreePresentableNodeDescriptor {
    @NotNull
    private final CriticalPathEntryUiData entryData;
    @NotNull
    private final List<TaskUiData> filteredTaskNodes;
    private final int filteredWarningCount;
    @NotNull
    private final TimeDistributionBuilder.TimeEntry filteredEntryTime;
    @NotNull
    private final TasksPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;

    /*
     * WARNING - void declaration
     */
    public EntryDetailsNodeDescriptor(@NotNull CriticalPathEntryUiData entryData, @NotNull List<? extends TaskUiData> filteredTaskNodes, @NotNull TimeDistributionBuilder timeDistributionBuilder) {
        TasksPageId tasksPageId;
        long l;
        void $this$sumByLong$iv;
        int n;
        int n2;
        Iterable $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)entryData, (String)"entryData");
        Intrinsics.checkNotNullParameter(filteredTaskNodes, (String)"filteredTaskNodes");
        Intrinsics.checkNotNullParameter((Object)timeDistributionBuilder, (String)"timeDistributionBuilder");
        super(null);
        this.entryData = entryData;
        this.filteredTaskNodes = filteredTaskNodes;
        Object object = this.filteredTaskNodes;
        EntryDetailsNodeDescriptor entryDetailsNodeDescriptor = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                TaskUiData it = (TaskUiData)element$iv;
                boolean bl = false;
                if (!it.getHasWarning() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        entryDetailsNodeDescriptor.filteredWarningCount = n = n2;
        $this$count$iv = this.filteredTaskNodes;
        TimeDistributionBuilder timeDistributionBuilder2 = timeDistributionBuilder;
        entryDetailsNodeDescriptor = this;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            TaskUiData bl = (TaskUiData)element$iv;
            l = sum$iv;
            boolean bl2 = false;
            long l2 = it.getExecutionTime().getTimeMs();
            sum$iv = l + l2;
        }
        l = sum$iv;
        entryDetailsNodeDescriptor.filteredEntryTime = timeDistributionBuilder2.registerTimeEntry(l);
        object = this.entryData;
        if (object instanceof CriticalPathPluginUiData) {
            tasksPageId = TasksPageId.Companion.plugin((CriticalPathPluginUiData)this.entryData);
        } else if (object instanceof CriticalPathTaskCategoryUiData) {
            tasksPageId = TasksPageId.Companion.taskCategory(((CriticalPathTaskCategoryUiData)this.entryData).getTaskCategory());
        } else {
            throw new IllegalArgumentException("Unknown type " + this.entryData.getClass() + " of " + this.entryData.getName());
        }
        this.pageId = tasksPageId;
        this.analyticsPageType = this.entryData instanceof CriticalPathPluginUiData ? BuildAttributionUiEvent.Page.PageType.PLUGIN_PAGE : BuildAttributionUiEvent.Page.PageType.TASK_CATEGORY_PAGE;
    }

    @NotNull
    public final CriticalPathEntryUiData getEntryData() {
        return this.entryData;
    }

    @NotNull
    public final List<TaskUiData> getFilteredTaskNodes() {
        return this.filteredTaskNodes;
    }

    public final int getFilteredWarningCount() {
        return this.filteredWarningCount;
    }

    @NotNull
    public final TimeDistributionBuilder.TimeEntry getFilteredEntryTime() {
        return this.filteredEntryTime;
    }

    @Override
    @NotNull
    public TasksPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        return new BuildAnalyzerTreeNodePresentation(this.entryData.getName(), this.entryData instanceof CriticalPathTaskCategoryUiData ? BuildAttributionUIUtilKt.warningsCountString(this.filteredWarningCount + ((CriticalPathTaskCategoryUiData)this.entryData).getTaskCategoryIssues(TaskCategoryIssue.Severity.WARNING, false).size()) : BuildAttributionUIUtilKt.warningsCountString(this.filteredWarningCount), this.filteredEntryTime.toRightAlignedNodeDurationText(), null, 8, null);
    }

    @Override
    public double getRelativeWeight() {
        return this.filteredEntryTime.toTimeWithPercentage().getPercentage();
    }

    @Override
    @NotNull
    public Color getChartItemColor() {
        Color color = CriticalPathChartLegend.pluginColorPalette.getColor((String)this.entryData.getName()).baseColor;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"pluginColorPalette.getCo\u2026entryData.name).baseColor");
        return color;
    }
}

