/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.ui.BuildAttributionIssueReportingDialog;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporter;
import com.android.build.attribution.ui.controllers.TaskIssueReporterImpl;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.TaskIssueReportGenerator;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.actions.SendFeedbackAction;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/ui/controllers/TaskIssueReporterImpl;", "Lcom/android/build/attribution/ui/controllers/TaskIssueReporter;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "project", "Lcom/intellij/openapi/project/Project;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;)V", "generator", "Lcom/android/build/attribution/ui/data/TaskIssueReportGenerator;", "reportIssue", "", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "intellij.android.build-attribution"})
public final class TaskIssueReporterImpl
implements TaskIssueReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAttributionUiAnalytics analytics;
    @NotNull
    private final TaskIssueReportGenerator generator;

    public TaskIssueReporterImpl(@NotNull BuildAttributionReportUiData reportData, @NotNull Project project, @NotNull BuildAttributionUiAnalytics analytics) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        this.project = project;
        this.analytics = analytics;
        this.generator = new TaskIssueReportGenerator(reportData, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ TaskIssueReporterImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = SendFeedbackAction.getDescription(TaskIssueReporterImpl.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(project)");
                return string;
            }
        }), (Function0<? extends List<AgpVersion>>)((Function0)new Function0<List<? extends AgpVersion>>(this){
            final /* synthetic */ TaskIssueReporterImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<AgpVersion> invoke() {
                List<AgpVersion> list2 = ProjectStructure.getInstance(TaskIssueReporterImpl.access$getProject$p(this.this$0)).getAndroidPluginVersions().getAllVersions();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).and\u2026luginVersions.allVersions");
                return list2;
            }
        }));
    }

    @Override
    @UiThread
    public void reportIssue(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Project project = this.project;
        Task.Modal task2 = new Task.Modal(this, taskData, project){
            final /* synthetic */ TaskIssueReporterImpl this$0;
            final /* synthetic */ TaskUiData $taskData;
            {
                this.this$0 = $receiver;
                this.$taskData = $taskData;
                super($super_call_param$1, "Collecting Data", false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText("Collecting Feedback Information");
                indicator.setIndeterminate(true);
                String reportText = TaskIssueReporterImpl.access$getGenerator$p(this.this$0).generateReportText(this.$taskData);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, this.this$0, this.$taskData, reportText){
                    final /* synthetic */ reportIssue.task.1 this$0;
                    final /* synthetic */ TaskIssueReporterImpl this$1;
                    final /* synthetic */ TaskUiData $taskData;
                    final /* synthetic */ String $reportText;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$taskData = $taskData;
                        this.$reportText = $reportText;
                    }

                    public final void run() {
                        Project project = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        new BuildAttributionIssueReportingDialog(project, TaskIssueReporterImpl.access$getAnalytics$p(this.this$1), this.$taskData.getPluginName(), this.$reportText).show();
                    }
                });
            }
        };
        task2.queue();
    }

    public static final /* synthetic */ TaskIssueReportGenerator access$getGenerator$p(TaskIssueReporterImpl $this) {
        return $this.generator;
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getAnalytics$p(TaskIssueReporterImpl $this) {
        return $this.analytics;
    }

    public static final /* synthetic */ Project access$getProject$p(TaskIssueReporterImpl $this) {
        return $this.project;
    }
}

