/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.controllers;

import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.FindSelectedLibVersionDeclarationAction;
import com.android.build.attribution.ui.controllers.FindSelectedLibVersionDeclarationActionKt;
import com.android.build.attribution.ui.view.details.JetifierWarningDetailsView;
import com.google.common.base.Stopwatch;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import java.time.Duration;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/ui/controllers/FindSelectedLibVersionDeclarationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "selectionSupplier", "Ljava/util/function/Supplier;", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "(Ljava/util/function/Supplier;Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.build-attribution"})
public final class FindSelectedLibVersionDeclarationAction
extends AnAction {
    @NotNull
    private final Supplier<JetifierWarningDetailsView.DirectDependencyDescriptor> selectionSupplier;
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAttributionUiAnalytics analytics;

    public FindSelectedLibVersionDeclarationAction(@NotNull Supplier<JetifierWarningDetailsView.DirectDependencyDescriptor> selectionSupplier, @NotNull Project project, @NotNull BuildAttributionUiAnalytics analytics) {
        Intrinsics.checkNotNullParameter(selectionSupplier, (String)"selectionSupplier");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super("Find Version Declarations");
        this.selectionSupplier = selectionSupplier;
        this.project = project;
        this.analytics = analytics;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.selectionSupplier.get() == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JetifierWarningDetailsView.DirectDependencyDescriptor directDependencyDescriptor = this.selectionSupplier.get();
        if (directDependencyDescriptor == null) {
            return;
        }
        JetifierWarningDetailsView.DirectDependencyDescriptor selectedDependency = directDependencyDescriptor;
        Stopwatch watch = Stopwatch.createStarted();
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setTabName("Dependency Version Declaration");
        usageViewPresentation.setTabText("Dependency Version Declaration");
        usageViewPresentation.setTargetsNodeText("Dependency");
        String fullNameWithoutVersion = StringsKt.substringBeforeLast$default((String)selectedDependency.getFullName(), (String)":", null, (int)2, null);
        usageViewPresentation.setCodeUsagesString("Version declarations");
        String string = StringUtil.pluralize((String)"project", (int)selectedDependency.getProjects().size());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(\"project\", sel\u2026Dependency.projects.size)");
        String pluralizedProject = string;
        usageViewPresentation.setScopeText(CollectionsKt.joinToString$default((Iterable)selectedDependency.getProjects(), null, (CharSequence)(pluralizedProject + " "), null, (int)5, null, null, (int)53, null));
        usageViewPresentation.setSearchString(fullNameWithoutVersion);
        usageViewPresentation.setOpenInNewTab(false);
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(usageViewPresentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(false);
        Factory factory2 = new Factory(this, selectedDependency){
            final /* synthetic */ FindSelectedLibVersionDeclarationAction this$0;
            final /* synthetic */ JetifierWarningDetailsView.DirectDependencyDescriptor $selectedDependency;
            {
                this.this$0 = $receiver;
                this.$selectedDependency = $selectedDependency;
            }

            public final UsageSearcher create() {
                return (UsageSearcher)new UsageInfoSearcherAdapter(this.this$0, this.$selectedDependency){
                    final /* synthetic */ FindSelectedLibVersionDeclarationAction this$0;
                    final /* synthetic */ JetifierWarningDetailsView.DirectDependencyDescriptor $selectedDependency;
                    {
                        this.this$0 = $receiver;
                        this.$selectedDependency = $selectedDependency;
                    }

                    public void generate(@NotNull Processor<? super Usage> processor) {
                        Intrinsics.checkNotNullParameter(processor, (String)"processor");
                        this.processUsages(processor, FindSelectedLibVersionDeclarationAction.access$getProject$p(this.this$0));
                    }

                    @NotNull
                    protected UsageInfo[] findUsages() {
                        return FindSelectedLibVersionDeclarationActionKt.findVersionDeclarations(FindSelectedLibVersionDeclarationAction.access$getProject$p(this.this$0), this.$selectedDependency);
                    }
                };
            }
        };
        UsageViewManager.UsageViewStateListener listener2 = new UsageViewManager.UsageViewStateListener(this, watch){
            final /* synthetic */ FindSelectedLibVersionDeclarationAction this$0;
            final /* synthetic */ Stopwatch $watch;
            {
                this.this$0 = $receiver;
                this.$watch = $watch;
            }

            public void usageViewCreated(@NotNull UsageView usageView) {
                Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
            }

            public void findingUsagesFinished(@Nullable UsageView usageView) {
                BuildAttributionUiAnalytics buildAttributionUiAnalytics = FindSelectedLibVersionDeclarationAction.access$getAnalytics$p(this.this$0);
                Duration duration2 = this.$watch.elapsed();
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"watch.elapsed()");
                buildAttributionUiAnalytics.findLibraryVersionDeclarationActionUsed(duration2);
            }
        };
        UsageTarget target2 = new UsageTarget(fullNameWithoutVersion){
            final /* synthetic */ String $fullNameWithoutVersion;
            {
                this.$fullNameWithoutVersion = $fullNameWithoutVersion;
            }

            public void navigate(boolean requestFocus) {
            }

            public boolean canNavigate() {
                return false;
            }

            public boolean canNavigateToSource() {
                return false;
            }

            @NotNull
            public String getName() {
                return this.$fullNameWithoutVersion;
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return new ItemPresentation(this.$fullNameWithoutVersion){
                    final /* synthetic */ String $fullNameWithoutVersion;
                    {
                        this.$fullNameWithoutVersion = $fullNameWithoutVersion;
                    }

                    @NotNull
                    public String getPresentableText() {
                        return this.$fullNameWithoutVersion;
                    }

                    @NotNull
                    public Icon getIcon(boolean unused) {
                        Icon icon2 = PlatformIcons.LIBRARY_ICON;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"LIBRARY_ICON");
                        return icon2;
                    }
                };
            }

            public boolean isValid() {
                return true;
            }

            public void findUsages() {
            }
        };
        actionPerformed.target.1[] nullArray = new actionPerformed.target.1[]{target2};
        UsageViewManager.getInstance((Project)this.project).searchAndShowUsages((UsageTarget[])nullArray, factory2, processPresentation, usageViewPresentation, listener2);
    }

    public static final /* synthetic */ Project access$getProject$p(FindSelectedLibVersionDeclarationAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getAnalytics$p(FindSelectedLibVersionDeclarationAction $this) {
        return $this.analytics;
    }
}

