/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.BrowserUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/attribution/ui/HtmlLinksHandler;", "Ljavax/swing/event/HyperlinkListener;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "(Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "getActionHandlers", "()Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "registeredLinkActions", "", "", "Ljava/lang/Runnable;", "getRegisteredLinkActions", "()Ljava/util/Map;", "actionLink", "text", "actionId", "action", "externalLink", "link", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "hyperlinkUpdate", "", "hyperlinkEvent", "Ljavax/swing/event/HyperlinkEvent;", "intellij.android.build-attribution"})
public final class HtmlLinksHandler
implements HyperlinkListener {
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final Map<String, Runnable> registeredLinkActions;

    public HtmlLinksHandler(@NotNull ViewActionHandlers actionHandlers) {
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        this.actionHandlers = actionHandlers;
        this.registeredLinkActions = new LinkedHashMap();
    }

    @NotNull
    public final ViewActionHandlers getActionHandlers() {
        return this.actionHandlers;
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, Runnable> getRegisteredLinkActions() {
        return this.registeredLinkActions;
    }

    @NotNull
    public final String externalLink(@NotNull String text2, @NotNull BuildAnalyzerBrowserLinks link2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)link2), (String)"link");
        this.registeredLinkActions.put(link2.name(), new Runnable(link2, this){
            final /* synthetic */ BuildAnalyzerBrowserLinks $link;
            final /* synthetic */ HtmlLinksHandler this$0;
            {
                this.$link = $link;
                this.this$0 = $receiver;
            }

            public final void run() {
                BrowserUtil.browse((String)this.$link.getUrlTarget());
                this.this$0.getActionHandlers().helpLinkClicked(this.$link);
            }
        });
        return "<a href='" + link2.name() + "'>" + text2 + "</a><icon src='AllIcons.Ide.External_link_arrow'>";
    }

    @NotNull
    public final String actionLink(@NotNull String text2, @NotNull String actionId, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.registeredLinkActions.put(actionId, action2);
        return "<a href='" + actionId + "'>" + text2 + "</a>";
    }

    @Override
    public void hyperlinkUpdate(@Nullable HyperlinkEvent hyperlinkEvent) {
        block2: {
            if (hyperlinkEvent == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block2;
            Runnable runnable2 = this.registeredLinkActions.get(hyperlinkEvent.getDescription());
            if (runnable2 != null) {
                runnable2.run();
            }
        }
    }
}

