/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/attribution/ui/BuildAttributionIssueReportingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "pluginName", "", "reportText", "(Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;Ljava/lang/String;Ljava/lang/String;)V", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "CopyToClipboardAction", "intellij.android.build-attribution"})
public final class BuildAttributionIssueReportingDialog
extends DialogWrapper {
    @NotNull
    private final BuildAttributionUiAnalytics analytics;
    @NotNull
    private final String pluginName;
    @NotNull
    private final String reportText;

    public BuildAttributionIssueReportingDialog(@NotNull Project project, @NotNull BuildAttributionUiAnalytics analytics, @NotNull String pluginName, @NotNull String reportText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
        super(project);
        this.analytics = analytics;
        this.pluginName = pluginName;
        this.reportText = reportText;
        this.setTitle("Plugin Issue Report");
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JEditorPane jEditorPane;
        String warningText = "<html><body>If you are comfortable sharing the information below, copy the report and send it to the developer of plugin " + this.pluginName + ", so they may troubleshoot the detected issues. Also include a description of what you were doing at the time.</body></html>";
        JEditorPane $this$createCenterPanel_u24lambda_u240 = jEditorPane = new JEditorPane("text/plain", this.reportText);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder(JBUI.Borders.empty((int)3));
        $this$createCenterPanel_u24lambda_u240.setEditable(false);
        $this$createCenterPanel_u24lambda_u240.setBackground(UIUtil.getComboBoxDisabledBackground());
        JEditorPane messageArea = jEditorPane;
        JEditorPane $this$createCenterPanel_u24lambda_u241 = jEditorPane = JBUI.Panels.simplePanel((int)10, (int)10);
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u241.addToTop(new JLabel(warningText, BuildAttributionUIUtilKt.warningIcon(), 2));
        $this$createCenterPanel_u24lambda_u241.addToCenter(ScrollPaneFactory.createScrollPane((Component)messageArea, (int)20, (int)31));
        $this$createCenterPanel_u24lambda_u241.setPreferredSize((Dimension)new JBDimension(700, 600));
        return jEditorPane;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        actionArray[0] = new CopyToClipboardAction();
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction()");
        return actionArray;
    }

    public void doCancelAction() {
        this.analytics.reportingWindowClosed();
        super.doCancelAction();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/ui/BuildAttributionIssueReportingDialog$CopyToClipboardAction;", "Ljavax/swing/AbstractAction;", "(Lcom/android/build/attribution/ui/BuildAttributionIssueReportingDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.android.build-attribution"})
    private final class CopyToClipboardAction
    extends AbstractAction {
        public CopyToClipboardAction() {
            super(IdeBundle.message((String)"button.copy", (Object[])new Object[0]));
            this.putValue("ShortDescription", IdeBundle.message((String)"description.copy.text.to.clipboard", (Object[])new Object[0]));
            this.putValue("FocusedAction", true);
            this.putValue("DefaultAction", true);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BuildAttributionIssueReportingDialog.this.analytics.reportingWindowCopyButtonClicked();
            String string = StringUtil.convertLineSeparators((String)BuildAttributionIssueReportingDialog.this.reportText);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(reportText)");
            String s = string;
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
        }
    }
}

