/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016J\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\u0010J\b\u0010!\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/attribution/data/PluginData;", "", "pluginType", "Lcom/android/build/attribution/data/PluginData$PluginType;", "idName", "", "(Lcom/android/build/attribution/data/PluginData$PluginType;Ljava/lang/String;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "getIdName", "<set-?>", "getPluginType", "()Lcom/android/build/attribution/data/PluginData$PluginType;", "projectToDisplayName", "", "Lcom/android/build/attribution/data/PluginData$DisplayName;", "displayNameInProject", "project", "displayNames", "", "equals", "", "other", "hashCode", "", "isAndroidPlugin", "isGradlePlugin", "isJavaPlugin", "isKotlinPlugin", "markAsBuildSrcPlugin", "", "recordDisplayName", "toString", "DisplayName", "PluginType", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nPluginData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginData.kt\ncom/android/build/attribution/data/PluginData\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n197#2,6:102\n1620#3,3:108\n2329#3,14:111\n1743#3,3:126\n1#4:125\n*S KotlinDebug\n*F\n+ 1 PluginData.kt\ncom/android/build/attribution/data/PluginData\n*L\n69#1:102,6\n69#1:108,3\n76#1:111,14\n80#1:126,3\n*E\n"})
public final class PluginData {
    @NotNull
    private final String idName;
    @NotNull
    private PluginType pluginType;
    @NotNull
    private final Map<String, DisplayName> projectToDisplayName;

    public PluginData(@NotNull PluginType pluginType, @NotNull String idName) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginType), (String)"pluginType");
        Intrinsics.checkNotNullParameter((Object)idName, (String)"idName");
        this.idName = idName;
        this.pluginType = pluginType;
        this.projectToDisplayName = new LinkedHashMap();
    }

    @NotNull
    public final String getIdName() {
        return this.idName;
    }

    @NotNull
    public final PluginType getPluginType() {
        return this.pluginType;
    }

    @NotNull
    public String toString() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.pluginType.ordinal()]) {
            case 1 -> "unknown plugin";
            case 2 -> "binary plugin " + this.idName;
            case 3 -> "buildSrc plugin " + this.idName;
            case 4 -> "script " + this.idName;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PluginData && Intrinsics.areEqual((Object)this.idName, (Object)((PluginData)other).idName);
    }

    public int hashCode() {
        return this.idName.hashCode();
    }

    public final void markAsBuildSrcPlugin() {
        this.pluginType = PluginType.BUILDSRC_PLUGIN;
    }

    @Nullable
    public final DisplayName recordDisplayName(@NotNull DisplayName displayName2) {
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        return this.projectToDisplayName.put(displayName2.getProjectPath(), displayName2);
    }

    @NotNull
    public final String displayNameInProject(@NotNull String project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = this.projectToDisplayName.get(project);
        if (object == null || (object = ((DisplayName)object).getName()) == null) {
            object = this.getDisplayName();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> displayNames() {
        Set set;
        Collection<DisplayName> $this$mapSmartSet$iv = this.projectToDisplayName.values();
        boolean $i$f$mapSmartSet = false;
        int size$iv = $this$mapSmartSet$iv.size();
        switch (size$iv) {
            case 1: {
                DisplayName it = (DisplayName)CollectionsKt.first((Iterable)$this$mapSmartSet$iv);
                boolean bl = false;
                set = Collections.singleton(it.getName());
                break;
            }
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = $this$mapSmartSet$iv;
                Collection destination$iv$iv = new HashSet(size$iv);
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DisplayName displayName2 = (DisplayName)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getName());
                }
                set = (Set)destination$iv$iv;
            }
        }
        return set;
    }

    @NotNull
    public final String getDisplayName() {
        String string;
        Object v0;
        Iterable $this$minByOrNull$iv = this.displayNames();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                String it = (String)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.length();
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-minByOrNull-PluginData$displayName$1 = false;
                    int v$iv = it2.length();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((string = (String)v0) == null) {
            String string2;
            String it = string2 = this.idName;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
            if (string == null) {
                string = "Unknown plugin";
            }
        }
        return string;
    }

    public final boolean isJavaPlugin() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.displayNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = Intrinsics.areEqual((Object)it, (Object)"application") || Intrinsics.areEqual((Object)it, (Object)"java") || Intrinsics.areEqual((Object)it, (Object)"java-base") || Intrinsics.areEqual((Object)it, (Object)"java-gradle-plugin") || Intrinsics.areEqual((Object)it, (Object)"java-library") || Intrinsics.areEqual((Object)it, (Object)"java-platform");
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isAndroidPlugin() {
        return StringsKt.startsWith$default((String)this.idName, (String)"com.android.build.gradle.", (boolean)false, (int)2, null);
    }

    public final boolean isKotlinPlugin() {
        return StringsKt.startsWith$default((String)this.idName, (String)"org.jetbrains.kotlin.", (boolean)false, (int)2, null);
    }

    public final boolean isGradlePlugin() {
        return StringsKt.startsWith$default((String)this.idName, (String)"org.gradle.", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/build/attribution/data/PluginData$DisplayName;", "", "name", "", "projectPath", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getProjectPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class DisplayName {
        @NotNull
        private final String name;
        @NotNull
        private final String projectPath;

        public DisplayName(@NotNull String name2, @NotNull String projectPath) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.name = name2;
            this.projectPath = projectPath;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getProjectPath() {
            return this.projectPath;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.projectPath;
        }

        @NotNull
        public final DisplayName copy(@NotNull String name2, @NotNull String projectPath) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return new DisplayName(name2, projectPath);
        }

        public static /* synthetic */ DisplayName copy$default(DisplayName displayName2, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = displayName2.name;
            }
            if ((n & 2) != 0) {
                string2 = displayName2.projectPath;
            }
            return displayName2.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DisplayName(name=" + this.name + ", projectPath=" + this.projectPath + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.projectPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayName)) {
                return false;
            }
            DisplayName displayName2 = (DisplayName)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)displayName2.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.projectPath, (Object)displayName2.projectPath);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/data/PluginData$PluginType;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "BINARY_PLUGIN", "BUILDSRC_PLUGIN", "SCRIPT", "intellij.android.build-attribution"})
    public static final class PluginType
    extends Enum<PluginType> {
        public static final /* enum */ PluginType UNKNOWN = new PluginType();
        public static final /* enum */ PluginType BINARY_PLUGIN = new PluginType();
        public static final /* enum */ PluginType BUILDSRC_PLUGIN = new PluginType();
        public static final /* enum */ PluginType SCRIPT = new PluginType();
        private static final /* synthetic */ PluginType[] $VALUES;

        public static PluginType[] values() {
            return (PluginType[])$VALUES.clone();
        }

        public static PluginType valueOf(String value2) {
            return Enum.valueOf(PluginType.class, value2);
        }

        static {
            $VALUES = pluginTypeArray = new PluginType[]{PluginType.UNKNOWN, PluginType.BINARY_PLUGIN, PluginType.BUILDSRC_PLUGIN, PluginType.SCRIPT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PluginType.values().length];
            try {
                nArray[PluginType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginType.BINARY_PLUGIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginType.BUILDSRC_PLUGIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginType.SCRIPT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

