/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.data;

import com.android.build.attribution.data.PluginData;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.BinaryPluginIdentifier;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.ScriptPluginIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010\u0017\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/attribution/data/PluginContainer;", "", "()V", "allPlugins", "", "", "Lcom/android/build/attribution/data/PluginData;", "getAllPlugins", "()Ljava/util/Map;", "pluginCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "pluginDisplayNamesToPlugin", "Lcom/android/build/attribution/data/PluginData$DisplayName;", "clear", "", "findPluginByName", "pluginName", "projectPath", "getPlugin", "pluginIdentifier", "Lorg/gradle/tooling/events/PluginIdentifier;", "getPluginDisplayName", "getPluginIdName", "getPluginType", "Lcom/android/build/attribution/data/PluginData$PluginType;", "updatePluginsData", "agpAttributionData", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "cleanUpInternalPluginName", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nPluginContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginContainer.kt\ncom/android/build/attribution/data/PluginContainer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n359#2,7:87\n1851#3:94\n1743#3,3:95\n1852#3:98\n*S KotlinDebug\n*F\n+ 1 PluginContainer.kt\ncom/android/build/attribution/data/PluginContainer\n*L\n33#1:87,7\n49#1:94\n50#1:95,3\n49#1:98\n*E\n"})
public final class PluginContainer {
    @NotNull
    private final HashMap<String, PluginData> pluginCache = new HashMap();
    @NotNull
    private final HashMap<PluginData.DisplayName, PluginData> pluginDisplayNamesToPlugin = new HashMap();

    @NotNull
    public final Map<String, PluginData> getAllPlugins() {
        return this.pluginCache;
    }

    @NotNull
    public final PluginData getPlugin(@Nullable PluginIdentifier pluginIdentifier, @NotNull String projectPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String pluginIdName = this.getPluginIdName(pluginIdentifier, projectPath);
        Map $this$getOrPut$iv = this.pluginCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(pluginIdName);
        if (value$iv == null) {
            boolean bl = false;
            PluginData answer$iv = new PluginData(this.getPluginType(pluginIdentifier), pluginIdName);
            $this$getOrPut$iv.put(pluginIdName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        PluginData plugin = (PluginData)v;
        boolean bl = false;
        if (pluginIdentifier != null) {
            PluginData.DisplayName displayName2 = this.getPluginDisplayName(pluginIdentifier, projectPath);
            plugin.recordDisplayName(displayName2);
            ((Map)this.pluginDisplayNamesToPlugin).put(displayName2, plugin);
        }
        return (PluginData)v;
    }

    @Nullable
    public final PluginData findPluginByName(@NotNull String pluginName, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        PluginData pluginData = this.pluginDisplayNamesToPlugin.get(new PluginData.DisplayName(this.cleanUpInternalPluginName(pluginName), projectPath));
        if (pluginData == null) {
            pluginData = this.pluginCache.get(this.cleanUpInternalPluginName(pluginName));
        }
        return pluginData;
    }

    public final void updatePluginsData(@NotNull AndroidGradlePluginAttributionData agpAttributionData) {
        Intrinsics.checkNotNullParameter((Object)agpAttributionData, (String)"agpAttributionData");
        Collection<PluginData> collection2 = this.pluginCache.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"pluginCache.values");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            PluginData plugin;
            block4: {
                plugin = (PluginData)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = plugin.displayNames();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!agpAttributionData.getBuildSrcPlugins().contains(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            plugin.markAsBuildSrcPlugin();
        }
    }

    public final void clear() {
        this.pluginCache.clear();
        this.pluginDisplayNamesToPlugin.clear();
    }

    private final PluginData.PluginType getPluginType(PluginIdentifier pluginIdentifier) {
        PluginIdentifier pluginIdentifier2 = pluginIdentifier;
        return pluginIdentifier2 instanceof BinaryPluginIdentifier ? PluginData.PluginType.BINARY_PLUGIN : (pluginIdentifier2 instanceof ScriptPluginIdentifier ? PluginData.PluginType.SCRIPT : PluginData.PluginType.UNKNOWN);
    }

    private final String getPluginIdName(PluginIdentifier pluginIdentifier, String projectPath) {
        Object object;
        PluginIdentifier pluginIdentifier2 = pluginIdentifier;
        if (pluginIdentifier2 == null) {
            object = "";
        } else if (pluginIdentifier2 instanceof BinaryPluginIdentifier) {
            String string = ((BinaryPluginIdentifier)pluginIdentifier).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginIdentifier.className");
            object = this.cleanUpInternalPluginName(string);
        } else if (pluginIdentifier2 instanceof ScriptPluginIdentifier) {
            object = projectPath + ":" + ((ScriptPluginIdentifier)pluginIdentifier).getDisplayName();
        } else {
            String string = pluginIdentifier.getDisplayName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginIdentifier.displayName");
        }
        return object;
    }

    private final PluginData.DisplayName getPluginDisplayName(PluginIdentifier pluginIdentifier, String projectPath) {
        PluginData.DisplayName displayName2;
        if (pluginIdentifier instanceof ScriptPluginIdentifier) {
            displayName2 = new PluginData.DisplayName(projectPath + ":" + ((ScriptPluginIdentifier)pluginIdentifier).getDisplayName(), projectPath);
        } else {
            String string = pluginIdentifier.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginIdentifier.displayName");
            displayName2 = new PluginData.DisplayName(this.cleanUpInternalPluginName(string), projectPath);
        }
        return displayName2;
    }

    private final String cleanUpInternalPluginName(String $this$cleanUpInternalPluginName) {
        return StringsKt.startsWith$default((String)$this$cleanUpInternalPluginName, (String)"com.android.internal.", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$cleanUpInternalPluginName, (String)"com.android.internal.", (String)"com.android.", (boolean)false, (int)4, null) : $this$cleanUpInternalPluginName;
    }
}

