/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.ProjectConfigurationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SuccessResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0002H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/data/PluginContainer;)V", "allAppliedPlugins", "", "", "", "Lcom/android/build/attribution/data/PluginData;", "applyPluginEventPrefix", "pluginsConfigurationDataMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "projectConfigurationBuilder", "Lcom/android/build/attribution/data/ProjectConfigurationData$Builder;", "projectPluginsConfigurationData", "projectsConfigurationData", "Ljava/util/ArrayList;", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "Lkotlin/collections/ArrayList;", "calculateResult", "cleanupTempState", "", "getFirstConfigurationStepInParentEvents", "Lorg/gradle/tooling/events/OperationDescriptor;", "descriptor", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "updatePluginConfigurationTime", "plugin", "configurationTimeMs", "Result", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationAnalyzer.kt\ncom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,172:1\n1549#2:173\n1620#2,3:174\n12708#3,2:177\n12708#3,2:179\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationAnalyzer.kt\ncom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer\n*L\n82#1:173\n82#1:174,3\n114#1:177,2\n135#1:179,2\n*E\n"})
public final class ProjectConfigurationAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer {
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final String applyPluginEventPrefix;
    @NotNull
    private final HashMap<PluginData, Long> pluginsConfigurationDataMap;
    @NotNull
    private final ArrayList<ProjectConfigurationData> projectsConfigurationData;
    @NotNull
    private final Map<String, List<PluginData>> allAppliedPlugins;
    @Nullable
    private ProjectConfigurationData.Builder projectConfigurationBuilder;
    @NotNull
    private final HashMap<String, Long> projectPluginsConfigurationData;

    public ProjectConfigurationAnalyzer(@NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.pluginContainer = pluginContainer;
        this.applyPluginEventPrefix = "Apply plugin";
        this.pluginsConfigurationDataMap = new HashMap();
        this.projectsConfigurationData = new ArrayList();
        this.allAppliedPlugins = new LinkedHashMap();
        this.projectPluginsConfigurationData = new HashMap();
    }

    private final void updatePluginConfigurationTime(PluginData plugin, long configurationTimeMs) {
        Long l = this.pluginsConfigurationDataMap.getOrDefault(plugin, 0L);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"pluginsConfigurationData\u2026.getOrDefault(plugin, 0L)");
        long currentConfigurationTime = ((Number)l).longValue();
        ((Map)this.pluginsConfigurationDataMap).put(plugin, currentConfigurationTime + configurationTimeMs);
        ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
        Intrinsics.checkNotNull((Object)builder2);
        builder2.addPluginConfigurationData(plugin, configurationTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveEvent(@NotNull ProgressEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2 instanceof ProjectConfigurationStartEvent) {
            String string = ((ProjectConfigurationStartEvent)event2).getDescriptor().getProject().getProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.project.projectPath");
            this.projectConfigurationBuilder = new ProjectConfigurationData.Builder(string);
            this.projectPluginsConfigurationData.clear();
        } else if (this.projectConfigurationBuilder != null) {
            if (event2 instanceof ProjectConfigurationFinishEvent && ((ProjectConfigurationFinishEvent)event2).getResult() instanceof ProjectConfigurationSuccessResult) {
                void $this$mapTo$iv$iv;
                String projectPath = ((ProjectConfigurationFinishEvent)event2).getDescriptor().getProject().getProjectPath();
                Map<String, List<PluginData>> map2 = this.allAppliedPlugins;
                Intrinsics.checkNotNullExpressionValue((Object)projectPath, (String)"projectPath");
                String string = projectPath;
                ProjectConfigurationOperationResult projectConfigurationOperationResult = ((ProjectConfigurationFinishEvent)event2).getResult();
                Intrinsics.checkNotNull((Object)projectConfigurationOperationResult, (String)"null cannot be cast to non-null type org.gradle.tooling.events.configuration.ProjectConfigurationSuccessResult");
                List list2 = ((ProjectConfigurationSuccessResult)projectConfigurationOperationResult).getPluginApplicationResults();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"event.result as ProjectC\u2026.pluginApplicationResults");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProjectConfigurationOperationResult.PluginApplicationResult pluginApplicationResult = (ProjectConfigurationOperationResult.PluginApplicationResult)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(this.pluginContainer.getPlugin(it.getPlugin(), projectPath));
                }
                $this$map$iv = (List)destination$iv$iv;
                map2.put(string, (List<PluginData>)$this$map$iv);
                this.projectPluginsConfigurationData.forEach(new BiConsumer(this, projectPath){
                    final /* synthetic */ ProjectConfigurationAnalyzer this$0;
                    final /* synthetic */ String $projectPath;
                    {
                        this.this$0 = $receiver;
                        this.$projectPath = $projectPath;
                    }

                    public final void accept(@NotNull String pluginName, @NotNull Long pluginConfigurationTime) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
                            Intrinsics.checkNotNullParameter((Object)pluginConfigurationTime, (String)"pluginConfigurationTime");
                            PluginContainer pluginContainer = ProjectConfigurationAnalyzer.access$getPluginContainer$p(this.this$0);
                            String string = this.$projectPath;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectPath");
                            PluginData pluginData = pluginContainer.findPluginByName(pluginName, string);
                            if (pluginData == null) break block0;
                            PluginData pluginData2 = pluginData;
                            ProjectConfigurationAnalyzer projectConfigurationAnalyzer = this.this$0;
                            PluginData pluginData3 = pluginData2;
                            boolean bl = false;
                            ProjectConfigurationAnalyzer.access$updatePluginConfigurationTime(projectConfigurationAnalyzer, pluginData3, pluginConfigurationTime);
                        }
                    }
                });
                ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
                Intrinsics.checkNotNull((Object)builder2);
                this.projectsConfigurationData.add(builder2.build(((ProjectConfigurationFinishEvent)event2).getResult().getEndTime() - ((ProjectConfigurationFinishEvent)event2).getResult().getStartTime()));
                this.projectPluginsConfigurationData.clear();
                this.projectConfigurationBuilder = null;
            } else if (event2 instanceof FinishEvent && ((FinishEvent)event2).getResult() instanceof SuccessResult) {
                String string = ((FinishEvent)event2).getDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
                if (StringsKt.startsWith$default((String)string, (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null)) {
                    Object object = ((FinishEvent)event2).getDescriptor().getParent();
                    if (!(object != null && (object = object.getName()) != null ? StringsKt.startsWith$default((String)object, (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null) : false)) {
                        String string2 = ((FinishEvent)event2).getDescriptor().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.descriptor.name");
                        String string3 = string2;
                        int n = this.applyPluginEventPrefix.length() + 1;
                        String string4 = string3.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                        String pluginName = string4;
                        long pluginConfigurationTime = ((FinishEvent)event2).getResult().getEndTime() - ((FinishEvent)event2).getResult().getStartTime();
                        Long $i$f$map = pluginConfigurationTime;
                        ((Map)this.projectPluginsConfigurationData).put(pluginName, $i$f$map);
                        OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(((FinishEvent)event2).getDescriptor());
                        if (configurationStepDescriptor != null) {
                            ProjectConfigurationData.Builder builder3 = this.projectConfigurationBuilder;
                            Intrinsics.checkNotNull((Object)builder3);
                            builder3.subtractConfigurationStepTime(configurationStepDescriptor, pluginConfigurationTime);
                        }
                    }
                } else {
                    boolean bl;
                    block13: {
                        ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
                        boolean $i$f$any = false;
                        int n = $this$any$iv.length;
                        for (int i = 0; i < n; ++i) {
                            ProjectConfigurationData.ConfigurationStep.Type element$iv;
                            ProjectConfigurationData.ConfigurationStep.Type it = element$iv = $this$any$iv[i];
                            boolean bl2 = false;
                            OperationDescriptor operationDescriptor = ((FinishEvent)event2).getDescriptor();
                            Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor, (String)"event.descriptor");
                            if (!it.isDescriptorOfType(operationDescriptor)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                    if (bl && this.getFirstConfigurationStepInParentEvents(((FinishEvent)event2).getDescriptor().getParent()) == null) {
                        ProjectConfigurationData.Builder builder4 = this.projectConfigurationBuilder;
                        Intrinsics.checkNotNull((Object)builder4);
                        OperationDescriptor operationDescriptor = ((FinishEvent)event2).getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)operationDescriptor, (String)"event.descriptor");
                        builder4.addConfigurationStepTime(operationDescriptor, ((FinishEvent)event2).getResult().getEndTime() - ((FinishEvent)event2).getResult().getStartTime());
                    }
                }
            }
        }
    }

    private final OperationDescriptor getFirstConfigurationStepInParentEvents(OperationDescriptor descriptor2) {
        boolean bl;
        block4: {
            if (descriptor2 == null) {
                return null;
            }
            OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(descriptor2.getParent());
            if (configurationStepDescriptor != null) {
                return configurationStepDescriptor;
            }
            ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ProjectConfigurationData.ConfigurationStep.Type element$iv;
                ProjectConfigurationData.ConfigurationStep.Type it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!it.isDescriptorOfType(descriptor2)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return descriptor2;
        }
        return null;
    }

    @Override
    public void cleanupTempState() {
        this.projectsConfigurationData.clear();
        this.pluginsConfigurationDataMap.clear();
        this.allAppliedPlugins.clear();
        this.projectConfigurationBuilder = null;
    }

    @Override
    @NotNull
    protected Result calculateResult() {
        return new Result(MapsKt.toMap((Map)this.pluginsConfigurationDataMap), CollectionsKt.toList((Iterable)this.projectsConfigurationData), MapsKt.toMap(this.allAppliedPlugins));
    }

    public static final /* synthetic */ PluginContainer access$getPluginContainer$p(ProjectConfigurationAnalyzer $this) {
        return $this.pluginContainer;
    }

    public static final /* synthetic */ void access$updatePluginConfigurationTime(ProjectConfigurationAnalyzer $this, PluginData plugin, long configurationTimeMs) {
        $this.updatePluginConfigurationTime(plugin, configurationTimeMs);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u001b\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0003JK\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "pluginsConfigurationDataMap", "", "Lcom/android/build/attribution/data/PluginData;", "", "projectsConfigurationData", "", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "allAppliedPlugins", "", "(Ljava/util/Map;Ljava/util/List;Ljava/util/Map;)V", "getAllAppliedPlugins", "()Ljava/util/Map;", "getPluginsConfigurationDataMap", "getProjectsConfigurationData", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class Result
    implements AnalyzerResult {
        @NotNull
        private final Map<PluginData, Long> pluginsConfigurationDataMap;
        @NotNull
        private final List<ProjectConfigurationData> projectsConfigurationData;
        @NotNull
        private final Map<String, List<PluginData>> allAppliedPlugins;

        public Result(@NotNull Map<PluginData, Long> pluginsConfigurationDataMap, @NotNull List<ProjectConfigurationData> projectsConfigurationData, @NotNull Map<String, ? extends List<PluginData>> allAppliedPlugins) {
            Intrinsics.checkNotNullParameter(pluginsConfigurationDataMap, (String)"pluginsConfigurationDataMap");
            Intrinsics.checkNotNullParameter(projectsConfigurationData, (String)"projectsConfigurationData");
            Intrinsics.checkNotNullParameter(allAppliedPlugins, (String)"allAppliedPlugins");
            this.pluginsConfigurationDataMap = pluginsConfigurationDataMap;
            this.projectsConfigurationData = projectsConfigurationData;
            this.allAppliedPlugins = allAppliedPlugins;
        }

        @NotNull
        public final Map<PluginData, Long> getPluginsConfigurationDataMap() {
            return this.pluginsConfigurationDataMap;
        }

        @NotNull
        public final List<ProjectConfigurationData> getProjectsConfigurationData() {
            return this.projectsConfigurationData;
        }

        @NotNull
        public final Map<String, List<PluginData>> getAllAppliedPlugins() {
            return this.allAppliedPlugins;
        }

        @NotNull
        public final Map<PluginData, Long> component1() {
            return this.pluginsConfigurationDataMap;
        }

        @NotNull
        public final List<ProjectConfigurationData> component2() {
            return this.projectsConfigurationData;
        }

        @NotNull
        public final Map<String, List<PluginData>> component3() {
            return this.allAppliedPlugins;
        }

        @NotNull
        public final Result copy(@NotNull Map<PluginData, Long> pluginsConfigurationDataMap, @NotNull List<ProjectConfigurationData> projectsConfigurationData, @NotNull Map<String, ? extends List<PluginData>> allAppliedPlugins) {
            Intrinsics.checkNotNullParameter(pluginsConfigurationDataMap, (String)"pluginsConfigurationDataMap");
            Intrinsics.checkNotNullParameter(projectsConfigurationData, (String)"projectsConfigurationData");
            Intrinsics.checkNotNullParameter(allAppliedPlugins, (String)"allAppliedPlugins");
            return new Result(pluginsConfigurationDataMap, projectsConfigurationData, allAppliedPlugins);
        }

        public static /* synthetic */ Result copy$default(Result result2, Map map2, List list2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = result2.pluginsConfigurationDataMap;
            }
            if ((n & 2) != 0) {
                list2 = result2.projectsConfigurationData;
            }
            if ((n & 4) != 0) {
                map3 = result2.allAppliedPlugins;
            }
            return result2.copy(map2, list2, map3);
        }

        @NotNull
        public String toString() {
            return "Result(pluginsConfigurationDataMap=" + this.pluginsConfigurationDataMap + ", projectsConfigurationData=" + this.projectsConfigurationData + ", allAppliedPlugins=" + this.allAppliedPlugins + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.pluginsConfigurationDataMap).hashCode();
            result2 = result2 * 31 + ((Object)this.projectsConfigurationData).hashCode();
            result2 = result2 * 31 + ((Object)this.allAppliedPlugins).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.pluginsConfigurationDataMap, result2.pluginsConfigurationDataMap)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.projectsConfigurationData, result2.projectsConfigurationData)) {
                return false;
            }
            return Intrinsics.areEqual(this.allAppliedPlugins, result2.allAppliedPlugins);
        }
    }
}

