/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"CHECK_JETIFIER_TASK_NAME", "", "minAGPVersion", "Lcom/android/ide/common/repository/AgpVersion;", "checkJetifierResultFile", "Ljava/io/File;", "buildRequestData", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request$RequestData;", "shouldAnalyzerRun", "", "currentAgpVersion", "intellij.android.build-attribution"})
public final class JetifierUsageAnalyzerKt {
    @NotNull
    public static final String CHECK_JETIFIER_TASK_NAME = "checkJetifier";
    @NotNull
    private static final AgpVersion minAGPVersion = AgpVersion.Companion.parse("7.1.0-beta01");

    @NotNull
    public static final File checkJetifierResultFile(@NotNull GradleBuildInvoker.Request.RequestData buildRequestData) {
        Intrinsics.checkNotNullParameter((Object)buildRequestData, (String)"buildRequestData");
        String[] stringArray = new String[]{"build-attribution", "checkJetifierResult.json"};
        File file2 = FileUtils.join((File)BuildAttributionUtil.getAgpAttributionFileDir(buildRequestData), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"join(\n  getAgpAttributio\u2026eckJetifierResult.json\"\n)");
        return file2;
    }

    private static final boolean shouldAnalyzerRun(AgpVersion currentAgpVersion) {
        Object t = StudioFlags.BUILD_ANALYZER_JETIFIER_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"BUILD_ANALYZER_JETIFIER_ENABLED.get()");
        return (Boolean)t != false && currentAgpVersion != null && currentAgpVersion.compareTo(minAGPVersion) >= 0;
    }

    public static final /* synthetic */ boolean access$shouldAnalyzerRun(AgpVersion currentAgpVersion) {
        return JetifierUsageAnalyzerKt.shouldAnalyzerRun(currentAgpVersion);
    }
}

