/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.annotations.concurrency.Slow;
import com.android.build.attribution.AbstractBuildAnalysisResult;
import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerSettings;
import com.android.build.attribution.BuildAnalyzerStorageDescriptor;
import com.android.build.attribution.BuildAnalyzerStorageFileManager;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.BuildDescriptor;
import com.android.build.attribution.BuildDescriptorImpl;
import com.android.build.attribution.BuildDescriptorStorageService;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.analyzers.AlwaysRunTasksAnalyzer;
import com.android.build.attribution.analyzers.AnnotationProcessorsAnalyzer;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.analyzers.GarbageCollectionAnalyzer;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.NoncacheableTasksAnalyzer;
import com.android.build.attribution.analyzers.ProjectConfigurationAnalyzer;
import com.android.build.attribution.analyzers.TaskCategoryWarningsAnalyzer;
import com.android.build.attribution.analyzers.TasksConfigurationIssuesAnalyzer;
import com.android.build.attribution.data.BuildRequestHolder;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.containers.ConcurrentList;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0014H\u0007J\f\u0010+\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\b\u0010,\u001a\u00020-H\u0017J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010*\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u0006H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020\u0019H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020)H\u0003J\f\u00108\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u0018\u00109\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0017J&\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010=\u001a\u00020)H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/build/attribution/BuildAnalyzerStorageManagerImpl;", "Lcom/android/build/attribution/BuildAnalyzerStorageManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildResults", "Lcom/android/build/attribution/AbstractBuildAnalysisResult;", "descriptors", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/android/build/attribution/BuildDescriptorImpl;", "getDescriptors$annotations", "()V", "getDescriptors", "()Lcom/intellij/util/containers/ConcurrentList;", "fileManager", "Lcom/android/build/attribution/BuildAnalyzerStorageFileManager;", "getFileManager", "()Lcom/android/build/attribution/BuildAnalyzerStorageFileManager;", "inMemoryResults", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/build/attribution/BuildAnalysisResults;", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageDescriptor", "Lcom/android/build/attribution/BuildAnalyzerStorageDescriptor;", "workingWithDiskLock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearBuildResultsStored", "Ljava/util/concurrent/Future;", "createBuildResultsObject", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "buildSessionID", "requestHolder", "Lcom/android/build/attribution/data/BuildRequestHolder;", "deleteFirstNRecords", "lazy", "Lkotlin/Function0;", "", "deleteHistoricBuildResultByID", "", "buildID", "deleteOldRecords", "getCurrentBuildHistoryDataSize", "", "getHistoricBuildResultByID", "getLatestBuildAnalysisResults", "getListOfHistoricBuildDescriptors", "", "Lcom/android/build/attribution/BuildDescriptor;", "getNumberOfBuildResultsStored", "getStorageDescriptor", "hasData", "", "notifyDataListeners", "onSettingsChange", "recordNewFailure", "failureType", "Lcom/android/build/attribution/FailureResult$Type;", "storeNewBuildResults", "updateDescriptor", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerStorageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerStorageManagerImpl.kt\ncom/android/build/attribution/BuildAnalyzerStorageManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n288#2,2:246\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerStorageManagerImpl.kt\ncom/android/build/attribution/BuildAnalyzerStorageManagerImpl\n*L\n193#1:246,2\n*E\n"})
public final class BuildAnalyzerStorageManagerImpl
implements BuildAnalyzerStorageManager {
    @NotNull
    private final Project project;
    @Nullable
    private volatile AbstractBuildAnalysisResult buildResults;
    @NotNull
    private final BuildAnalyzerStorageFileManager fileManager;
    @NotNull
    private final ConcurrentList<BuildDescriptorImpl> descriptors;
    @NotNull
    private final ConcurrentHashMap<String, BuildAnalysisResults> inMemoryResults;
    @NotNull
    private final ReentrantLock workingWithDiskLock;
    @NotNull
    private final BuildAnalyzerStorageDescriptor storageDescriptor;

    public BuildAnalyzerStorageManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        File file2 = ProjectUtil.getProjectDataPath((Project)this.project, (String)"build-analyzer-history-data").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.getProjectDataPa\u2026r-history-data\").toFile()");
        this.fileManager = new BuildAnalyzerStorageFileManager(file2);
        this.descriptors = BuildDescriptorStorageService.Companion.getInstance(this.project).getState().getDescriptors();
        this.inMemoryResults = new ConcurrentHashMap();
        this.workingWithDiskLock = new ReentrantLock();
        this.storageDescriptor = new BuildAnalyzerStorageDescriptor(this.fileManager.getTotalFilesSize(), (AtomicProperty<Integer>)new AtomicProperty((Object)this.getNumberOfBuildResultsStored()));
        this.onSettingsChange();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BuildAnalyzerStorageFileManager getFileManager() {
        return this.fileManager;
    }

    @NotNull
    public final ConcurrentList<BuildDescriptorImpl> getDescriptors() {
        return this.descriptors;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDescriptors$annotations() {
    }

    @Slow
    private final synchronized void notifyDataListeners() {
        ((BuildAnalyzerStorageManager.Listener)this.project.getMessageBus().syncPublisher(BuildAnalyzerStorageManager.Companion.getDATA_IS_READY_TOPIC())).newDataAvailable();
    }

    private final BuildAnalysisResults createBuildResultsObject(BuildEventsAnalyzersProxy analyzersProxy, String buildSessionID, BuildRequestHolder requestHolder) {
        GradleBuildInvoker.Request.RequestData requestData = requestHolder.getBuildRequest().getData();
        AnnotationProcessorsAnalyzer.Result result2 = (AnnotationProcessorsAnalyzer.Result)analyzersProxy.getAnnotationProcessorsAnalyzer().getResult();
        AlwaysRunTasksAnalyzer.Result result3 = (AlwaysRunTasksAnalyzer.Result)analyzersProxy.getAlwaysRunTasksAnalyzer().getResult();
        CriticalPathAnalyzer.Result result4 = (CriticalPathAnalyzer.Result)analyzersProxy.getCriticalPathAnalyzer().getResult();
        NoncacheableTasksAnalyzer.Result result5 = (NoncacheableTasksAnalyzer.Result)analyzersProxy.getNoncacheableTasksAnalyzer().getResult();
        GarbageCollectionAnalyzer.Result result6 = (GarbageCollectionAnalyzer.Result)analyzersProxy.getGarbageCollectionAnalyzer().getResult();
        ProjectConfigurationAnalyzer.Result result7 = (ProjectConfigurationAnalyzer.Result)analyzersProxy.getProjectConfigurationAnalyzer().getResult();
        TasksConfigurationIssuesAnalyzer.Result result8 = (TasksConfigurationIssuesAnalyzer.Result)analyzersProxy.getTasksConfigurationIssuesAnalyzer().getResult();
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = (ConfigurationCachingCompatibilityProjectResult)analyzersProxy.getConfigurationCachingCompatibilityAnalyzer().getResult();
        JetifierUsageAnalyzerResult jetifierUsageAnalyzerResult = (JetifierUsageAnalyzerResult)analyzersProxy.getJetifierUsageAnalyzer().getResult();
        Object object = analyzersProxy.getDownloadsAnalyzer();
        if (object == null || (object = (DownloadsAnalyzer.Result)((BaseAnalyzer)object).getResult()) == null) {
            object = DownloadsAnalyzer.AnalyzerIsDisabled.INSTANCE;
        }
        return new BuildAnalysisResults(requestData, result2, result3, result4, result5, result6, result7, result8, configurationCachingCompatibilityProjectResult, jetifierUsageAnalyzerResult, (DownloadsAnalyzer.Result)object, (TaskCategoryWarningsAnalyzer.Result)analyzersProxy.getTaskCategoryWarningsAnalyzer().getResult(), buildSessionID, analyzersProxy.getTaskContainer().getAllTasks(), analyzersProxy.getPluginContainer().getAllPlugins());
    }

    @Override
    @NotNull
    public AbstractBuildAnalysisResult getLatestBuildAnalysisResults() {
        if (this.hasData()) {
            AbstractBuildAnalysisResult abstractBuildAnalysisResult = this.buildResults;
            Intrinsics.checkNotNull((Object)abstractBuildAnalysisResult);
            return abstractBuildAnalysisResult;
        }
        throw new IllegalStateException("Storage Manager does not have data to return.");
    }

    @Override
    @NotNull
    public Future<?> clearBuildResultsStored() {
        return this.deleteFirstNRecords((Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ BuildAnalyzerStorageManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getDescriptors().size();
            }
        }));
    }

    @Override
    @NotNull
    public Future<BuildAnalysisResults> storeNewBuildResults(@NotNull BuildEventsAnalyzersProxy analyzersProxy, @NotNull String buildID, @NotNull BuildRequestHolder requestHolder) {
        Intrinsics.checkNotNullParameter((Object)analyzersProxy, (String)"analyzersProxy");
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        Intrinsics.checkNotNullParameter((Object)requestHolder, (String)"requestHolder");
        BuildAnalysisResults buildResults = this.createBuildResultsObject(analyzersProxy, buildID, requestHolder);
        this.buildResults = buildResults;
        this.notifyDataListeners();
        Object t = StudioFlags.BUILD_ANALYZER_HISTORY.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"BUILD_ANALYZER_HISTORY.get()");
        if (((Boolean)t).booleanValue()) {
            this.descriptors.add((Object)new BuildDescriptorImpl(buildResults.getBuildSessionID(), buildResults.getBuildFinishedTimestamp(), buildResults.getTotalBuildTimeMs()));
            this.updateDescriptor();
            ((Map)this.inMemoryResults).put(buildResults.getBuildSessionID(), buildResults);
            Function0 onBackground2 = (Function0)new Function0<BuildAnalysisResults>(this, buildResults){
                final /* synthetic */ BuildAnalyzerStorageManagerImpl this$0;
                final /* synthetic */ BuildAnalysisResults $buildResults;
                {
                    this.this$0 = $receiver;
                    this.$buildResults = $buildResults;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final BuildAnalysisResults invoke() {
                    Lock lock = BuildAnalyzerStorageManagerImpl.access$getWorkingWithDiskLock$p(this.this$0);
                    BuildAnalyzerStorageManagerImpl buildAnalyzerStorageManagerImpl = this.this$0;
                    BuildAnalysisResults buildAnalysisResults = this.$buildResults;
                    lock.lock();
                    try {
                        boolean bl = false;
                        buildAnalyzerStorageManagerImpl.getFileManager().storeBuildResultsInFile(buildAnalysisResults);
                        BuildAnalysisResults buildAnalysisResults2 = (BuildAnalysisResults)BuildAnalyzerStorageManagerImpl.access$getInMemoryResults$p(buildAnalyzerStorageManagerImpl).remove(buildAnalysisResults.getBuildSessionID());
                    }
                    finally {
                        lock.unlock();
                    }
                    BuildAnalyzerStorageManagerImpl.access$deleteOldRecords(this.this$0).get();
                    return this.$buildResults;
                }
            };
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Callable(onBackground2){
                private final /* synthetic */ Function0 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object call() {
                    return this.function.invoke();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"getApplication().execute\u2026ooledThread(onBackground)");
            return future2;
        }
        CompletableFuture<BuildAnalysisResults> completableFuture = CompletableFuture.completedFuture(buildResults);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(buildResults)");
        return completableFuture;
    }

    @Override
    @Slow
    public void recordNewFailure(@NotNull String buildID, @NotNull FailureResult.Type failureType) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        Intrinsics.checkNotNullParameter((Object)((Object)failureType), (String)"failureType");
        this.buildResults = new FailureResult(buildID, failureType);
        this.notifyDataListeners();
    }

    @Override
    @NotNull
    public Future<BuildAnalysisResults> getHistoricBuildResultByID(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        BuildAnalysisResults buildAnalysisResults = this.inMemoryResults.get(buildID);
        if (buildAnalysisResults != null) {
            BuildAnalysisResults it = buildAnalysisResults;
            boolean bl = false;
            CompletableFuture<BuildAnalysisResults> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(it)");
            return completableFuture;
        }
        Function0 onBackground2 = (Function0)new Function0<BuildAnalysisResults>(this, buildID){
            final /* synthetic */ BuildAnalyzerStorageManagerImpl this$0;
            final /* synthetic */ String $buildID;
            {
                this.this$0 = $receiver;
                this.$buildID = $buildID;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final BuildAnalysisResults invoke() {
                BuildAnalysisResults result2 = null;
                Lock lock = BuildAnalyzerStorageManagerImpl.access$getWorkingWithDiskLock$p(this.this$0);
                BuildAnalyzerStorageManagerImpl buildAnalyzerStorageManagerImpl = this.this$0;
                String string = this.$buildID;
                lock.lock();
                try {
                    boolean bl = false;
                    result2 = buildAnalyzerStorageManagerImpl.getFileManager().getHistoricBuildResultByID(string);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                return result2;
            }
        };
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"getApplication().execute\u2026ooledThread(onBackground)");
        return future2;
    }

    @Override
    @Slow
    public long getCurrentBuildHistoryDataSize() {
        return this.fileManager.getCurrentBuildHistoryDataSize();
    }

    @Override
    public int getNumberOfBuildResultsStored() {
        return this.descriptors.size();
    }

    @Override
    @NotNull
    public BuildAnalyzerStorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    @Override
    @NotNull
    public Future<?> onSettingsChange() {
        return this.deleteOldRecords();
    }

    @VisibleForTesting
    public final void deleteHistoricBuildResultByID(@NotNull String buildID) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
                Iterable $this$firstOrNull$iv = this.getListOfHistoricBuildDescriptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BuildDescriptor it = (BuildDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBuildSessionID(), (Object)buildID)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            BuildDescriptor buildDescriptor = v0;
            if (buildDescriptor == null) break block2;
            BuildDescriptor result2 = buildDescriptor;
            boolean bl = false;
            TypeIntrinsics.asMutableCollection((Object)((Collection)this.descriptors)).remove(result2);
            this.updateDescriptor();
            this.inMemoryResults.remove(buildID);
            this.fileManager.deleteHistoricBuildResultByID(buildID);
        }
    }

    @Override
    @NotNull
    public Set<BuildDescriptor> getListOfHistoricBuildDescriptors() {
        Set result2 = new LinkedHashSet();
        Iterator it = this.descriptors.iterator();
        while (true) {
            BuildDescriptor x = null;
            try {
                Object e = it.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
                x = (BuildDescriptor)e;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            result2.add(x);
        }
        return result2;
    }

    @Override
    public boolean hasData() {
        return this.buildResults != null;
    }

    private final void updateDescriptor() {
        this.storageDescriptor.getNumberOfBuildResultsStored().set((Object)this.getNumberOfBuildResultsStored());
    }

    private final Future<?> deleteOldRecords() {
        return this.deleteFirstNRecords((Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ BuildAnalyzerStorageManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getDescriptors().size() - BuildAnalyzerSettings.Companion.getInstance(this.this$0.getProject()).getState().getMaxNumberOfBuildsStored();
            }
        }));
    }

    private final Future<?> deleteFirstNRecords(Function0<Integer> lazy) {
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, lazy){
            final /* synthetic */ BuildAnalyzerStorageManagerImpl this$0;
            final /* synthetic */ Function0<Integer> $lazy;
            {
                this.this$0 = $receiver;
                this.$lazy = $lazy;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Lock lock = BuildAnalyzerStorageManagerImpl.access$getWorkingWithDiskLock$p(this.this$0);
                Function0<Integer> function0 = this.$lazy;
                BuildAnalyzerStorageManagerImpl buildAnalyzerStorageManagerImpl = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    int n = ((Number)function0.invoke()).intValue();
                    for (int i = 0; i < n; ++i) {
                        BuildDescriptor descriptor2;
                        Object v0;
                        int it = i;
                        boolean bl2 = false;
                        Iterable $this$minByOrNull$iv = buildAnalyzerStorageManagerImpl.getListOfHistoricBuildDescriptors();
                        boolean $i$f$minByOrNull = false;
                        Iterator<T> iterator$iv = $this$minByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v0 = null;
                        } else {
                            T minElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v0 = minElem$iv;
                            } else {
                                BuildDescriptor it2 = (BuildDescriptor)minElem$iv;
                                boolean bl3 = false;
                                long minValue$iv = it2.getBuildFinishedTimestamp();
                                do {
                                    T e$iv = iterator$iv.next();
                                    BuildDescriptor it3 = (BuildDescriptor)e$iv;
                                    $i$a$-minByOrNull-BuildAnalyzerStorageManagerImpl$deleteFirstNRecords$1$1$1$1 = false;
                                    long v$iv = it3.getBuildFinishedTimestamp();
                                    if (minValue$iv <= v$iv) continue;
                                    minElem$iv = e$iv;
                                    minValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v0 = minElem$iv;
                            }
                        }
                        if ((BuildDescriptor)v0 == null) continue;
                        boolean bl4 = false;
                        buildAnalyzerStorageManagerImpl.deleteHistoricBuildResultByID(descriptor2.getBuildSessionID());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"private fun deleteFirstN\u2026}\n        }\n      }\n    }");
        return future2;
    }

    public static final /* synthetic */ ReentrantLock access$getWorkingWithDiskLock$p(BuildAnalyzerStorageManagerImpl $this) {
        return $this.workingWithDiskLock;
    }

    public static final /* synthetic */ Future access$deleteOldRecords(BuildAnalyzerStorageManagerImpl $this) {
        return $this.deleteOldRecords();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getInMemoryResults$p(BuildAnalyzerStorageManagerImpl $this) {
        return $this.inMemoryResults;
    }
}

