/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.AtomicFileSize;
import com.android.build.attribution.BuildAnalyzerSettings;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.ui.view.ClearBuildResultsAction;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/BuildAnalyzerConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildAnalyzerSettings", "Lcom/android/build/attribution/BuildAnalyzerSettings;", "fileSizeFormatted", "Lcom/android/build/attribution/AtomicFileSize;", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.android.build-attribution"})
final class BuildAnalyzerConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAnalyzerSettings buildAnalyzerSettings;
    @NotNull
    private final AtomicFileSize fileSizeFormatted;

    public BuildAnalyzerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super("Build Analyzer", "build.analyzer", null, 4, null);
        this.project = project;
        this.buildAnalyzerSettings = BuildAnalyzerSettings.Companion.getInstance(this.project);
        this.fileSizeFormatted = new AtomicFileSize(BuildAnalyzerStorageManager.Companion.getInstance(this.project).getStorageDescriptor().getCurrentBuildHistoryDataSize());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void apply() {
        super.apply();
        BuildAnalyzerStorageManager.Companion.getInstance(this.project).onSettingsChange();
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ BuildAnalyzerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                T t = StudioFlags.BUILD_ANALYZER_HISTORY.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"BUILD_ANALYZER_HISTORY.get()");
                if (((Boolean)t).booleanValue()) {
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ BuildAnalyzerConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Cell.label$default((Cell)TextFieldKt.bindIntText((Cell)Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null), (ObservableMutableProperty)((ObservableMutableProperty)BuildAnalyzerStorageManager.Companion.getInstance(this.this$0.getProject()).getStorageDescriptor().getNumberOfBuildResultsStored())), (String)"Number of build results stored: ", null, (int)2, null);
                            Cell.label$default((Cell)TextFieldKt.bindText((Cell)Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null), (ObservableMutableProperty)((ObservableMutableProperty)BuildAnalyzerConfigurable.access$getFileSizeFormatted$p(this.this$0))), (String)"File size taken up by stored build results: ", null, (int)2, null);
                        }
                    }), (int)1, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ BuildAnalyzerConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.text$default((Row)$this$row, (String)"Maximum number of build results stored", (int)0, null, (int)6, null);
                            TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(0, 100), null, (int)2, null), (Function0)((Function0)new Function0<Integer>(this.this$0){
                                final /* synthetic */ BuildAnalyzerConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                @NotNull
                                public final Integer invoke() {
                                    return BuildAnalyzerConfigurable.access$getBuildAnalyzerSettings$p(this.this$0).getSettingsState().getMaxNumberOfBuildsStored();
                                }
                            }), (Function1)((Function1)new Function1<Integer, Unit>(this.this$0){
                                final /* synthetic */ BuildAnalyzerConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(int it) {
                                    BuildAnalyzerConfigurable.access$getBuildAnalyzerSettings$p(this.this$0).getSettingsState().setMaxNumberOfBuildsStored(it);
                                }
                            }));
                        }
                    }), (int)1, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ BuildAnalyzerConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.text$default((Row)$this$row, (String)"Maximum storage capacity in kilobytes", (int)0, null, (int)6, null);
                            TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(0, 100000), null, (int)2, null), (Function0)((Function0)new Function0<Integer>(this.this$0){
                                final /* synthetic */ BuildAnalyzerConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                @NotNull
                                public final Integer invoke() {
                                    return BuildAnalyzerConfigurable.access$getBuildAnalyzerSettings$p(this.this$0).getSettingsState().getMaxStorageSpaceKilobytes();
                                }
                            }), (Function1)((Function1)new Function1<Integer, Unit>(this.this$0){
                                final /* synthetic */ BuildAnalyzerConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(int it) {
                                    BuildAnalyzerConfigurable.access$getBuildAnalyzerSettings$p(this.this$0).getSettingsState().setMaxStorageSpaceKilobytes(it);
                                }
                            }));
                        }
                    }), (int)1, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ BuildAnalyzerConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.button$default((Row)$this$row, (String)"Clear Build Results Data", (AnAction)new ClearBuildResultsAction((Function0<Unit>)((Function0)new Function0<Unit>((Object)((Object)this.this$0)){

                                public final void invoke() {
                                    ((BuildAnalyzerConfigurable)((Object)this.receiver)).reset();
                                }
                            })), null, (int)4, null);
                        }
                    }), (int)1, null);
                }
            }
        }));
    }

    public static final /* synthetic */ AtomicFileSize access$getFileSizeFormatted$p(BuildAnalyzerConfigurable $this) {
        return $this.fileSizeFormatted;
    }

    public static final /* synthetic */ BuildAnalyzerSettings access$getBuildAnalyzerSettings$p(BuildAnalyzerConfigurable $this) {
        return $this.buildAnalyzerSettings;
    }
}

