/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.JpsFileObject;

public final class ZipFileObject
extends JpsFileObject {
    private final ZipFile myZip;
    private final ZipEntry myEntry;
    private final String myEncoding;

    ZipFileObject(File root, ZipFile zip, ZipEntry entry, String encoding, JavaFileManager.Location location) {
        super(ZipFileObject.createUri(root, entry.getName()), ZipFileObject.findKind(entry.getName()), location);
        this.myZip = zip;
        this.myEntry = entry;
        this.myEncoding = encoding;
    }

    @NotNull
    private static URI createUri(File zipFile, String relPath) {
        String p = FileUtilRt.toSystemIndependentName((String)zipFile.getPath());
        StringBuilder buf = new StringBuilder(p.length() + relPath.length() + 5);
        if (!p.startsWith("/")) {
            buf.append("///");
        } else if (!p.startsWith("//")) {
            buf.append("//");
        }
        buf.append(p).append(relPath.startsWith("/") ? "!" : "!/").append(relPath);
        try {
            return new URI("jar", null, buf.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new Error("Cannot create URI " + buf, e);
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(this.myZip.getInputStream(this.myEntry));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.myEntry.getTime();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        String name = this.myEntry.getName();
        int idx = name.lastIndexOf(".");
        return (idx < 0 ? name : name.substring(0, idx)).replace('/', '.');
    }

    @Override
    public boolean isNameCompatible(@NotNull String cn, JavaFileObject.Kind kind) {
        if (kind == JavaFileObject.Kind.OTHER) {
            return this.getKind() == kind;
        }
        if (this.getKind() != kind) {
            return false;
        }
        String name = this.myEntry.getName();
        return name.length() == cn.length() + kind.extension.length() && name.startsWith(cn) && name.endsWith(kind.extension);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ZipFileObject && super.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        try (InputStream in = this.openInputStream();){
            CharBuffer charBuffer;
            InputStreamReader reader = this.myEncoding != null ? new InputStreamReader(in, this.myEncoding) : new InputStreamReader(in);
            try {
                charBuffer = CharBuffer.wrap(FileUtilRt.loadText((Reader)reader, (int)((int)this.myEntry.getSize())));
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return charBuffer;
        }
    }
}

