/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.javac.CompilationCanceledException;
import org.jetbrains.jps.javac.DefaultFileOperations;
import org.jetbrains.jps.javac.FileObjectKindFilter;
import org.jetbrains.jps.javac.FileOperations;
import org.jetbrains.jps.javac.InputFileObject;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JpsFileObject;
import org.jetbrains.jps.javac.LazyClassLoader;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.TransformableJavaFileObject;

public final class JpsJavacFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements StandardJavaFileManager {
    private static final String _OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final boolean isWindows = _OS_NAME.startsWith("windows");
    private static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    private static final boolean isMac = _OS_NAME.startsWith("mac");
    private static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    private static final Set<JavaFileObject.Kind> ourSourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private static final Set<StandardLocation> ourFSLocations = EnumSet.of(StandardLocation.PLATFORM_CLASS_PATH, new StandardLocation[]{StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.SOURCE_OUTPUT, StandardLocation.SOURCE_PATH, StandardLocation.ANNOTATION_PROCESSOR_PATH});
    private static final FileObjectKindFilter<File> ourKindFilter = new FileObjectKindFilter<File>(new Function<File, String>(){

        public String fun(File file) {
            return file.getName();
        }
    });
    private final Context myContext;
    private final boolean myJavacBefore9;
    private final Collection<? extends JavaSourceTransformer> mySourceTransformers;
    private final FileOperations myFileOperations = new DefaultFileOperations();
    private final Map<String, Collection<String>> myGeneratedToOriginatingMap = new HashMap<String, Collection<String>>();
    private final Function<File, JavaFileObject> myFileToInputFileObjectConverter = new Function<File, JavaFileObject>(){

        public JavaFileObject fun(File file) {
            return new InputFileObject(file, JpsJavacFileManager.this.myEncodingName, false);
        }
    };
    private final Function<File, JavaFileObject> myFileToCachingInputFileObjectConverter = new Function<File, JavaFileObject>(){

        public JavaFileObject fun(File file) {
            return new InputFileObject(file, JpsJavacFileManager.this.myEncodingName, true);
        }
    };
    private static final Function<String, File> ourPathToFileConverter = new Function<String, File>(){

        public File fun(String s) {
            return new File(s);
        }
    };
    private Map<File, Set<File>> myOutputsMap = Collections.emptyMap();
    @Nullable
    private String myEncodingName;
    private int myChecksCounter = 0;
    private Iterable<? extends JavaFileObject> myInputSources = Collections.emptyList();
    private final Map<String, JavaFileObject> myInputSourcesIndex = new HashMap<String, JavaFileObject>();
    private final List<Closeable> myCloseables = new ArrayList<Closeable>();
    private final DelegateCallHandler<JavaFileManager, Boolean> myContainsCall = new DelegateCallHandler(JavaFileManager.class, "contains", JavaFileManager.Location.class, FileObject.class);
    private final DelegateCallHandler<JavaFileManager, JavaFileManager.Location> myGetLocationForModuleCall = new DelegateCallHandler(JavaFileManager.class, "getLocationForModule", JavaFileManager.Location.class, JavaFileObject.class);
    private final DelegateCallHandler<JavaFileManager, Iterable<Set<JavaFileManager.Location>>> myListLocationForModulesCall = new DelegateCallHandler(JavaFileManager.class, "listLocationsForModules", JavaFileManager.Location.class);
    private final DelegateCallHandler<StandardJavaFileManager, Void> mySetLocationForModuleCall = new DelegateCallHandler(StandardJavaFileManager.class, "setLocationForModule", JavaFileManager.Location.class, String.class, Collection.class);
    private final DelegateCallHandler<File, Object> myToPathCall = new DelegateCallHandler(File.class, "toPath", new Class[0]);

    public JpsJavacFileManager(final Context context, boolean javacBefore9, Collection<? extends JavaSourceTransformer> transformers) {
        super(context.getStandardFileManager());
        this.myJavacBefore9 = javacBefore9;
        this.mySourceTransformers = transformers;
        this.myContext = new Context(){

            @Override
            @Nullable
            public String getExplodedAutomaticModuleName(File pathElement) {
                return context.getExplodedAutomaticModuleName(pathElement);
            }

            @Override
            public boolean isCanceled() {
                return context.isCanceled();
            }

            @Override
            @NotNull
            public StandardJavaFileManager getStandardFileManager() {
                return context.getStandardFileManager();
            }

            @Override
            public void consumeOutputFile(@NotNull OutputFileObject obj) {
                try {
                    context.consumeOutputFile(obj);
                }
                finally {
                    JpsJavacFileManager.this.onOutputFileGenerated(obj.getFile());
                }
            }

            @Override
            public void reportMessage(Diagnostic.Kind kind, @Nls String message) {
                context.reportMessage(kind, message);
            }
        };
    }

    private Iterable<? extends JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> originalObjects) {
        return this.mySourceTransformers.isEmpty() ? originalObjects : Iterators.map(originalObjects, new Function<JavaFileObject, JavaFileObject>(){

            public JavaFileObject fun(JavaFileObject fo) {
                return JavaFileObject.Kind.SOURCE.equals((Object)fo.getKind()) ? new TransformableJavaFileObject(fo, JpsJavacFileManager.this.mySourceTransformers) : fo;
            }
        });
    }

    public Iterable<? extends JavaFileObject> setInputSources(Iterable<? extends File> sources) {
        ArrayList<? extends JavaFileObject> allSources = new ArrayList<JavaFileObject>();
        for (JavaFileObject javaFileObject : this.getJavaFileObjectsFromFiles(sources)) {
            allSources.add(javaFileObject);
        }
        this.myInputSources = allSources;
        return this.myInputSources;
    }

    public Iterable<? extends JavaFileObject> getInputSources() {
        return this.myInputSources;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        this.checkCanceled();
        if (!ourSourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        JavaFileObject fo = super.getJavaFileForInput(location, className, kind);
        if (fo == null && !"module-info".equals(className)) {
            throw new FileNotFoundException("Java resource does not exist : " + location + '/' + (Object)((Object)kind) + '/' + className);
        }
        return this.mySourceTransformers.isEmpty() ? fo : (fo == null ? null : new TransformableJavaFileObject(fo, this.mySourceTransformers));
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind != JavaFileObject.Kind.SOURCE && kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, kind, JpsJavacFileManager.externalizeFileName(className, kind.extension), className, sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        String fileName = packageName.isEmpty() ? relativeName : JpsJavacFileManager.externalizeFileName(packageName, "/", relativeName);
        return this.getFileForOutput(location, JpsFileObject.findKind(fileName), fileName, null, sibling);
    }

    private OutputFileObject getFileForOutput(JavaFileManager.Location location, JavaFileObject.Kind kind, String fileName, @Nullable String className, FileObject sibling) throws IOException {
        Collection<String> originating;
        JavaFileObject javaFileObject;
        this.checkCanceled();
        Iterable<URI> originatingSources = null;
        if (sibling instanceof JavaFileObject && (javaFileObject = (JavaFileObject)sibling).getKind() == JavaFileObject.Kind.SOURCE) {
            originatingSources = Iterators.asIterable(javaFileObject.toUri());
        }
        if (originatingSources == null && (originating = this.lookupOriginatingNames(className, fileName)) != null) {
            for (String origQName : originating) {
                JavaFileObject found = this.lookupInputSource(origQName);
                if (found == null) continue;
                originatingSources = Iterators.flat(originatingSources, Iterators.asIterable(found.toUri()));
            }
        }
        File dir = this.findOutputDir(location, originatingSources);
        if (location == StandardLocation.CLASS_OUTPUT) {
            if (dir == null) {
                throw new IOException("Output directory is not specified");
            }
        } else if (location == StandardLocation.SOURCE_OUTPUT && dir == null) {
            if (originatingSources != null) {
                dir = this.findOutputDir(StandardLocation.CLASS_OUTPUT, originatingSources);
            }
            if (dir == null) {
                throw new IOException("Neither class output directory nor source output are specified");
            }
        }
        File file = dir == null ? new File(fileName).getAbsoluteFile() : new File(dir, fileName);
        boolean isGenerated = sibling instanceof OutputFileObject && ((OutputFileObject)sibling).getKind() == JavaFileObject.Kind.SOURCE || this.hasOriginatingNames(className, fileName);
        return new OutputFileObject(this.myContext, dir, fileName, file, kind, className, originatingSources == null ? Collections.emptyList() : originatingSources, this.myEncodingName, null, location, isGenerated);
    }

    private Collection<String> lookupOriginatingNames(@Nullable String className, String fileName) {
        if (className != null) {
            Collection<String> dotsResult = this.myGeneratedToOriginatingMap.get(className.replace('/', '.'));
            return dotsResult != null ? dotsResult : this.myGeneratedToOriginatingMap.get(className.replace('.', '/'));
        }
        return this.myGeneratedToOriginatingMap.get(fileName);
    }

    private boolean hasOriginatingNames(@Nullable String className, String fileName) {
        if (className != null) {
            return this.myGeneratedToOriginatingMap.containsKey(className.replace('/', '.')) || this.myGeneratedToOriginatingMap.containsKey(className.replace('.', '/'));
        }
        return this.myGeneratedToOriginatingMap.containsKey(fileName);
    }

    @Nullable
    private File findOutputDir(JavaFileManager.Location location, @Nullable Iterable<URI> sources) {
        File dir = null;
        if (sources != null && location == StandardLocation.CLASS_OUTPUT) {
            URI uri;
            Iterator<URI> iterator = sources.iterator();
            while (iterator.hasNext() && (dir = this.getSingleOutputDirectory(location, uri = iterator.next())) == null) {
            }
        }
        if (dir == null) {
            dir = this.getSingleOutputDirectory(location, null);
        }
        return dir;
    }

    @Nullable
    private JavaFileObject lookupInputSource(String qName) {
        JavaFileObject result = this.myInputSourcesIndex.get(qName);
        if (result != null) {
            return result;
        }
        if (!Iterators.isEmpty(this.myInputSources)) {
            String uriSuffix = "/" + qName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
            for (JavaFileObject javaFileObject : this.myInputSources) {
                String path;
                URI uri = javaFileObject.toUri();
                if (uri == null || (path = uri.getPath()) == null || !path.endsWith(uriSuffix)) continue;
                this.myInputSourcesIndex.put(qName, javaFileObject);
                return javaFileObject;
            }
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        LazyClassLoader loader = LazyClassLoader.createFrom(this.getLocation(location), this.myContext.getStandardFileManager().getClass().getClassLoader());
        if (loader instanceof Closeable) {
            this.myCloseables.add(loader);
        }
        return loader;
    }

    private File getSingleOutputDirectory(JavaFileManager.Location loc, URI sourceUri) {
        Iterator<? extends File> it;
        File outputDir;
        if (loc == StandardLocation.CLASS_OUTPUT && this.myOutputsMap.size() > 1 && sourceUri != null && (outputDir = this.findOutputDir(new File(sourceUri))) != null) {
            return outputDir;
        }
        Iterable<? extends File> location = this.getStdManager().getLocation(loc);
        if (location != null && (it = location.iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    private File findOutputDir(File src) {
        File file = FileUtilRt.getParentFile((File)src);
        while (file != null) {
            for (Map.Entry<File, Set<File>> entry : this.myOutputsMap.entrySet()) {
                if (!entry.getValue().contains(file)) continue;
                return entry.getKey();
            }
            file = FileUtilRt.getParentFile((File)file);
        }
        return null;
    }

    private void checkCanceled() {
        int counter;
        this.myChecksCounter = counter = (this.myChecksCounter + 1) % 10;
        if (counter == 0 && this.myContext.isCanceled()) {
            throw new CompilationCanceledException();
        }
    }

    private static String externalizeFileName(CharSequence classOrPackageName, CharSequence ... suffix) {
        StringBuilder buf = new StringBuilder();
        int len = classOrPackageName.length();
        for (int i = 0; i < len; ++i) {
            char ch = classOrPackageName.charAt(i);
            buf.append(ch == '.' ? (char)'/' : (char)ch);
        }
        for (CharSequence s : suffix) {
            buf.append(s);
        }
        return buf.toString();
    }

    public Context getContext() {
        return this.myContext;
    }

    @NotNull
    StandardJavaFileManager getStdManager() {
        return (StandardJavaFileManager)this.fileManager;
    }

    @Override
    public boolean handleOption(String current, final Iterator<String> remaining) {
        if ("-encoding".equalsIgnoreCase(current) && remaining.hasNext()) {
            String encoding;
            this.myEncodingName = encoding = remaining.next();
            return super.handleOption(current, new Iterator<String>(){
                private boolean encodingConsumed = false;

                @Override
                public boolean hasNext() {
                    return !this.encodingConsumed || remaining.hasNext();
                }

                @Override
                public String next() {
                    if (!this.encodingConsumed) {
                        this.encodingConsumed = true;
                        return encoding;
                    }
                    return (String)remaining.next();
                }

                @Override
                public void remove() {
                    if (this.encodingConsumed) {
                        remaining.remove();
                    }
                }
            });
        }
        return super.handleOption(current, remaining);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        String inferred;
        JavaFileObject _fo = JpsJavacFileManager.unwrapFileObject(file);
        if (_fo instanceof JpsFileObject && (inferred = ((JpsFileObject)_fo).inferBinaryName(this.getLocation(location), isFileSystemCaseSensitive)) != null) {
            return inferred;
        }
        return super.inferBinaryName(location, _fo);
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        this.getStdManager().setLocation(location, path);
        if ("MODULE_PATH".equals(location.getName())) {
            this.initExplodedModuleNames(location, path);
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.wrapJavaFileObjects(Iterators.map(files, this.myFileToCachingInputFileObjectConverter));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.getJavaFileObjectsFromFiles(Iterators.map(names, ourPathToFileConverter));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(names));
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return this.getStdManager().getLocation(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        FileObject _a = JpsJavacFileManager.unwrapFileObject(a);
        FileObject _b = JpsJavacFileManager.unwrapFileObject(b);
        if (_a instanceof JpsFileObject || _b instanceof JpsFileObject) {
            return _a.equals(_b);
        }
        return super.isSameFile(_a, _b);
    }

    private static FileObject unwrapFileObject(FileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    private static JavaFileObject unwrapFileObject(JavaFileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.checkCanceled();
        FileObject fo = super.getFileForInput(location, packageName, relativeName);
        if (fo == null) {
            throw new FileNotFoundException("Resource does not exist : " + location + '/' + packageName + '/' + relativeName);
        }
        return fo;
    }

    private boolean isFileSystemLocation(JavaFileManager.Location location) {
        try {
            if (!(location instanceof StandardLocation)) {
                return false;
            }
            StandardLocation loc = StandardLocation.valueOf(location.getName());
            if (loc == StandardLocation.PLATFORM_CLASS_PATH) {
                return this.myJavacBefore9;
            }
            return ourFSLocations.contains(loc);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Override
    public Iterable<JavaFileObject> list(final JavaFileManager.Location location, final String packageName, final Set<JavaFileObject.Kind> kinds, final boolean recurse) throws IOException {
        Iterable<JavaFileObject> result;
        try {
            if (this.isFileSystemLocation(location)) {
                Iterable<? extends File> locationRoots = this.getLocation(location);
                if (Iterators.isEmpty(locationRoots)) {
                    return Collections.emptyList();
                }
                result = Iterators.flat(Iterators.map(locationRoots, new Function<File, Iterable<JavaFileObject>>(){

                    /*
                     * Exception decompiling
                     */
                    public Iterable<JavaFileObject> fun(File root) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }));
            } else {
                result = super.list(location, packageName, kinds, recurse);
            }
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                result = super.list(location, packageName, kinds, recurse);
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            result = super.list(location, packageName, kinds, recurse);
        }
        return kinds.contains((Object)JavaFileObject.Kind.SOURCE) ? this.wrapJavaFileObjects(result) : result;
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        if (fo instanceof JpsFileObject) {
            return location.equals(((JpsFileObject)fo).getLocation()) || this.getLocationForModule(location, (JpsFileObject)fo) != null;
        }
        return this.myContainsCall.callDefaultImpl((JavaFileManager)this.getStdManager(), "file object " + fo.getClass().getName(), location, fo);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        if (fo instanceof JpsFileObject) {
            File path;
            File file = fo instanceof InputFileObject ? ((InputFileObject)fo).getFile() : (path = fo instanceof OutputFileObject ? ((OutputFileObject)fo).getFile() : null);
            if (path != null) {
                for (JavaFileManager.Location loc : Iterators.flat(this.listLocationsForModules(location))) {
                    for (File file2 : this.getLocation(loc)) {
                        if (!JpsJavacFileManager.isAncestor(file2, path)) continue;
                        return loc;
                    }
                }
            }
            return null;
        }
        return this.myGetLocationForModuleCall.callDefaultImpl((JavaFileManager)this.getStdManager(), location, fo);
    }

    private static boolean isAncestor(File dir, File file) {
        String dirPath = FileUtilRt.toCanonicalPath((String)dir.getAbsolutePath(), (char)File.separatorChar, (boolean)false);
        String filePath = FileUtilRt.toCanonicalPath((String)file.getAbsolutePath(), (char)File.separatorChar, (boolean)false);
        boolean trailingSlash = dirPath.endsWith("/");
        if (filePath.length() < (trailingSlash ? dirPath.length() : dirPath.length() + 1)) {
            return false;
        }
        if (!filePath.regionMatches(!isFileSystemCaseSensitive, 0, dirPath, 0, dirPath.length())) {
            return false;
        }
        return trailingSlash || filePath.charAt(dirPath.length()) == '/';
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.myListLocationForModulesCall.callDefaultImpl((JavaFileManager)this.getStdManager(), location);
    }

    public void onOutputFileGenerated(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.myFileOperations.clearCaches(parent);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myOutputsMap = Collections.emptyMap();
            this.myInputSources = Collections.emptyList();
            this.myInputSourcesIndex.clear();
            this.myFileOperations.clearCaches(null);
            for (Closeable closeable : this.myCloseables) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
            this.myCloseables.clear();
        }
    }

    public void setOutputDirectories(Map<File, Set<File>> outputDirToSrcRoots) throws IOException {
        for (File outputDir : outputDirToSrcRoots.keySet()) {
            this.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputDir));
        }
        this.myOutputsMap = outputDirToSrcRoots;
    }

    public void addAnnotationProcessingClassMapping(String classOrResourceName, Iterable<String> originatingClassnames) {
        if (classOrResourceName != null) {
            Collection<String> names = null;
            for (String cn : originatingClassnames) {
                if (names == null && (names = this.myGeneratedToOriginatingMap.get(classOrResourceName)) == null) {
                    names = new HashSet<String>();
                    this.myGeneratedToOriginatingMap.put(classOrResourceName, names);
                }
                names.add(cn);
            }
        }
    }

    private void initExplodedModuleNames(JavaFileManager.Location modulePathLocation, Iterable<? extends File> path) throws IOException {
        if (this.mySetLocationForModuleCall.isAvailable() && this.myToPathCall.isAvailable()) {
            for (File file : path) {
                String explodedModuleName = this.myContext.getExplodedAutomaticModuleName(file);
                if (explodedModuleName == null) continue;
                this.mySetLocationForModuleCall.callDefaultImpl(this.getStdManager(), modulePathLocation, explodedModuleName, Collections.singleton(this.myToPathCall.callDefaultImpl(file, new Object[0])));
            }
        }
    }

    static /* synthetic */ Iterable access$301(JpsJavacFileManager x0, JavaFileManager.Location x1, String x2, Set x3, boolean x4) throws IOException {
        return super.list(x1, x2, x3, x4);
    }

    static /* synthetic */ FileObjectKindFilter access$400() {
        return ourKindFilter;
    }

    static /* synthetic */ Function access$500(JpsJavacFileManager x0) {
        return x0.myFileToInputFileObjectConverter;
    }

    static /* synthetic */ Function access$600(JpsJavacFileManager x0) {
        return x0.myFileToCachingInputFileObjectConverter;
    }

    public static interface Context {
        @Nullable
        public String getExplodedAutomaticModuleName(File var1);

        public boolean isCanceled();

        @NotNull
        public StandardJavaFileManager getStandardFileManager();

        public void consumeOutputFile(@NotNull OutputFileObject var1);

        public void reportMessage(Diagnostic.Kind var1, @Nls String var2);
    }

    private static final class DelegateCallHandler<T, R> {
        private final Method myMethod;
        private final String myUnsupportedMessage;

        DelegateCallHandler(Class<? extends T> apiInterface, String methodName, Class<?> ... argTypes) {
            this.myUnsupportedMessage = "Operation " + methodName + " is not supported";
            Method m = null;
            try {
                m = apiInterface.getDeclaredMethod(methodName, argTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.myMethod = m;
        }

        boolean isAvailable() {
            return this.myMethod != null;
        }

        R callDefaultImpl(T callTarget, Object ... args) throws IOException {
            return this.callDefaultImpl(callTarget, "", args);
        }

        R callDefaultImpl(T callTarget, String errorDetails, Object ... args) throws IOException {
            if (!this.isAvailable()) {
                throw new UnsupportedOperationException(this.getErrorMessage(errorDetails));
            }
            try {
                return (R)this.myMethod.invoke(callTarget, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new UnsupportedOperationException(this.getErrorMessage(errorDetails), cause != null ? cause : e);
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException(this.getErrorMessage(errorDetails), e);
            }
        }

        private String getErrorMessage(String errorDetails) {
            return errorDetails.isEmpty() ? this.myUnsupportedMessage : this.myUnsupportedMessage + ": " + errorDetails;
        }
    }
}

