/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JpsJavacFileManager;

public class APIWrappers {
    @Nullable
    public static <T> T unwrap(Class<? extends T> iface, T wrapper) {
        Object delegate;
        if (wrapper instanceof WrapperDelegateAccessor && iface.isInstance(delegate = ((WrapperDelegateAccessor)wrapper).getWrapperDelegate())) {
            return iface.cast(delegate);
        }
        return null;
    }

    public static <T extends FileObject> DiagnosticOutputConsumer newDiagnosticListenerWrapper(ProcessingContext procContext, DiagnosticOutputConsumer delegate) {
        return APIWrappers.wrap(DiagnosticOutputConsumer.class, new DiagnosticListenerWrapper(procContext, delegate));
    }

    @NotNull
    private static <T, W extends DynamicWrapper<? extends T>> T wrap(@NotNull Class<T> ifaceClass, @NotNull W wrapper) {
        return APIWrappers.wrap(ifaceClass, wrapper, DynamicWrapper.class, wrapper.getWrapperDelegate());
    }

    @NotNull
    public static <T> T wrap(@NotNull Class<T> ifaceClass, final @NotNull Object wrapper, final @NotNull Class<?> parentToStopSearchAt, final @NotNull T delegateTo) {
        return ifaceClass.cast(Proxy.newProxyInstance(APIWrappers.class.getClassLoader(), new Class[]{ifaceClass, WrapperDelegateAccessor.class}, new InvocationHandler(){
            private final Map<Method, Pair<Method, Object>> myCallHandlers = Collections.synchronizedMap(new HashMap());

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Pair<Method, Object> call = this.getCallHandlerMethod(method);
                    return ((Method)call.getFirst()).invoke(call.getSecond(), args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    throw cause != null ? cause : e;
                }
            }

            @NotNull
            private Pair<Method, Object> getCallHandlerMethod(Method method) {
                Pair pair = this.myCallHandlers.get(method);
                if (pair == null) {
                    if (WrapperDelegateAccessor.class.equals(method.getDeclaringClass())) {
                        pair = wrapper instanceof WrapperDelegateAccessor ? Pair.create((Object)method, (Object)wrapper) : Pair.create((Object)method, (Object)new WrapperDelegateAccessor<T>(){

                            @Override
                            public T getWrapperDelegate() {
                                return delegateTo;
                            }
                        });
                    } else {
                        Class<?> aClass = wrapper.getClass();
                        while (!parentToStopSearchAt.equals(aClass) && !Object.class.equals(aClass)) {
                            try {
                                pair = Pair.create((Object)aClass.getDeclaredMethod(method.getName(), method.getParameterTypes()), (Object)wrapper);
                                break;
                            }
                            catch (NoSuchMethodException e) {
                                aClass = aClass.getSuperclass();
                            }
                        }
                        if (pair == null) {
                            pair = Pair.create((Object)method, (Object)delegateTo);
                        }
                    }
                    this.myCallHandlers.put(method, (Pair<Method, Object>)pair);
                }
                return pair;
            }
        }));
    }

    public static String getUnwrapCodeSuggestion(Class<?> ifaceClass, String objVarName) {
        return ifaceClass.getSimpleName() + " unwrapped" + objVarName + " = jbUnwrap(" + ifaceClass.getSimpleName() + ".class, " + objVarName + ");\n\n\t\twhere\n\nprivate static <T> T jbUnwrap(Class<? extends T> iface, T wrapper) {\n  T unwrapped = null;\n  try {\n    final Class<?> apiWrappers = wrapper.getClass().getClassLoader().loadClass(\"org.jetbrains.jps.javac.APIWrappers\");\n    final Method unwrapMethod = apiWrappers.getDeclaredMethod(\"unwrap\", Class.class, Object.class);\n    unwrapped = iface.cast(unwrapMethod.invoke(null, iface, wrapper));\n  }\n  catch (Throwable ignored) {}\n  return unwrapped != null? unwrapped : wrapper;\n}";
    }

    static abstract class DynamicWrapper<T>
    implements WrapperDelegateAccessor<T> {
        private final T myDelegate;

        DynamicWrapper(T delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public final T getWrapperDelegate() {
            return this.myDelegate;
        }
    }

    public static interface WrapperDelegateAccessor<T> {
        public T getWrapperDelegate();
    }

    static class DiagnosticListenerWrapper<T extends FileObject>
    extends DynamicWrapper<DiagnosticOutputConsumer>
    implements DiagnosticListener<T> {
        private final ProcessingContext myProcContext;

        DiagnosticListenerWrapper(ProcessingContext procContext, DiagnosticOutputConsumer delegate) {
            super(delegate);
            this.myProcContext = procContext;
        }

        public void outputLineAvailable(String line) {
            ((DiagnosticOutputConsumer)this.getWrapperDelegate()).outputLineAvailable(this.myProcContext.adjustMessage(line));
        }

        @Override
        public void report(Diagnostic<? extends T> diagnostic) {
            ((DiagnosticOutputConsumer)this.getWrapperDelegate()).report((Diagnostic)APIWrappers.wrap(Diagnostic.class, new DiagnosticWrapper<T>(this.myProcContext, diagnostic)));
        }
    }

    public static class ProcessingContext {
        private final JpsJavacFileManager myFileManager;
        private Iterable<Processor> myAllProcessors = Collections.emptyList();
        private final Map<ProcessingEnvironment, ProcessingEnvironment> myWrappers = new HashMap<ProcessingEnvironment, ProcessingEnvironment>();
        private String myLastProcName;
        private final Map<String, String> myProcNamesMap = new HashMap<String, String>();

        public ProcessingContext(@NotNull JpsJavacFileManager fileManager) {
            this.myFileManager = fileManager;
        }

        @NotNull
        public JpsJavacFileManager getFileManager() {
            return this.myFileManager;
        }

        @NotNull
        public ProcessingEnvironment getWrappedProcessingEnvironment(ProcessingEnvironment processingEnv) {
            ProcessingEnvironment wrapped = this.myWrappers.get(processingEnv);
            if (wrapped == null) {
                wrapped = (ProcessingEnvironment)APIWrappers.wrap(ProcessingEnvironment.class, new ProcessingEnvironmentWrapper(processingEnv, this.myFileManager));
                this.myWrappers.put(processingEnv, wrapped);
            }
            return wrapped;
        }

        public String getProcessorName(Processor proc) {
            return (proc instanceof WrapperDelegateAccessor ? ((WrapperDelegateAccessor)((Object)proc)).getWrapperDelegate() : proc).getClass().getName();
        }

        void setLastExecutedProcessorName(Processor proc) {
            this.myLastProcName = this.getProcessorName(proc);
        }

        public Iterable<Processor> wrapProcessors(Iterable<? extends Processor> processors) {
            this.myAllProcessors = Iterators.map(processors, new Function<Processor, Processor>(){

                public Processor fun(Processor processor) {
                    return (Processor)APIWrappers.wrap(Processor.class, new ProcessorWrapper(processor, ProcessingContext.this));
                }
            });
            return this.myAllProcessors;
        }

        @Nullable
        public String adjustMessage(String message) {
            if (message != null) {
                try {
                    String wrappedName;
                    String realProcName = this.myLastProcName;
                    if (realProcName != null && !realProcName.isEmpty() && (wrappedName = this.lookupWrappedProcName(realProcName)) != null) {
                        return message.replace(wrappedName, realProcName);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return message;
        }

        private String lookupWrappedProcName(String procName) {
            String wrappedName = this.myProcNamesMap.get(procName);
            if (wrappedName == null) {
                for (Processor proc : this.myAllProcessors) {
                    if (!(proc instanceof WrapperDelegateAccessor)) continue;
                    this.myProcNamesMap.put(this.getProcessorName(proc), proc.getClass().getName());
                }
                wrappedName = this.myProcNamesMap.get(procName);
            }
            return wrappedName;
        }
    }

    private static class ClassNameFinder
    implements Function<Element, String> {
        private static final Method ourGetQualifiedNameMethod;
        private final Name myEmptyName;

        ClassNameFinder(Elements elementUtils) {
            this.myEmptyName = elementUtils.getName("");
        }

        public String fun(Element element) {
            Name qName = null;
            while (element != null) {
                if (element instanceof TypeElement) {
                    qName = ((TypeElement)element).getQualifiedName();
                } else if (element instanceof PackageElement) {
                    qName = ((PackageElement)element).getQualifiedName();
                } else if (ourGetQualifiedNameMethod != null && ourGetQualifiedNameMethod.getDeclaringClass().isAssignableFrom(element.getClass())) {
                    try {
                        qName = (Name)ourGetQualifiedNameMethod.invoke((Object)element, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (qName != null) {
                    if (!qName.equals(this.myEmptyName)) {
                        return qName.toString();
                    }
                    qName = null;
                }
                element = element.getEnclosingElement();
            }
            return null;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("javax.lang.model.element.QualifiedNameable").getMethod("getQualifiedName", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ourGetQualifiedNameMethod = method;
        }
    }

    static class FilerWrapper
    extends DynamicWrapper<Filer>
    implements Filer {
        private final JpsJavacFileManager myFileManager;
        private final Function<Element, String> convertToClassName;

        FilerWrapper(Filer delegate, JpsJavacFileManager fileManager, Elements elementUtils) {
            super(delegate);
            this.myFileManager = fileManager;
            this.convertToClassName = new ClassNameFinder(elementUtils);
        }

        @Override
        public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
            this.addMapping(name, originatingElements != null ? Arrays.asList(originatingElements) : Collections.emptyList());
            return ((Filer)this.getWrapperDelegate()).createSourceFile(name, originatingElements);
        }

        @Override
        public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
            this.addMapping(name, originatingElements != null ? Arrays.asList(originatingElements) : Collections.emptyList());
            return ((Filer)this.getWrapperDelegate()).createClassFile(name, originatingElements);
        }

        @Override
        public FileObject createResource(JavaFileManager.Location location, CharSequence moduleAndPkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
            if (originatingElements != null && originatingElements.length > 0) {
                String resourceName;
                if (moduleAndPkg == null) {
                    resourceName = relativeName.toString();
                } else {
                    StringBuilder buf = new StringBuilder();
                    int len = moduleAndPkg.length();
                    for (int i = 0; i < len; ++i) {
                        char ch = moduleAndPkg.charAt(i);
                        if (ch == '/') {
                            buf.setLength(0);
                            continue;
                        }
                        if (ch == '.') {
                            buf.append('/');
                            continue;
                        }
                        buf.append(ch);
                    }
                    if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
                        buf.append('/');
                    }
                    resourceName = buf.append(relativeName).toString();
                }
                this.addMapping(resourceName, Arrays.asList(originatingElements));
            }
            return ((Filer)this.getWrapperDelegate()).createResource(location, moduleAndPkg, relativeName, originatingElements != null ? originatingElements : new Element[]{});
        }

        @Override
        public FileObject getResource(JavaFileManager.Location location, CharSequence moduleAndPkg, CharSequence relativeName) throws IOException {
            return ((Filer)this.getWrapperDelegate()).getResource(location, moduleAndPkg, relativeName);
        }

        private void addMapping(CharSequence resourceName, Collection<? extends Element> elements) {
            if (resourceName != null && resourceName.length() > 0 && !elements.isEmpty()) {
                this.myFileManager.addAnnotationProcessingClassMapping(resourceName.toString(), Iterators.filter(Iterators.map(elements, this.convertToClassName), Iterators.notNullFilter()));
            }
        }
    }

    static class ProcessingEnvironmentWrapper
    extends DynamicWrapper<ProcessingEnvironment> {
        private final JpsJavacFileManager myFileManager;
        private Filer myFilerImpl;

        ProcessingEnvironmentWrapper(ProcessingEnvironment delegate, JpsJavacFileManager fileManager) {
            super(delegate);
            this.myFileManager = fileManager;
        }

        public Filer getFiler() {
            Filer impl = this.myFilerImpl;
            if (impl == null) {
                Filer delegateFiler = ((ProcessingEnvironment)this.getWrapperDelegate()).getFiler();
                this.myFilerImpl = impl = (Filer)APIWrappers.wrap(Filer.class, new FilerWrapper(delegateFiler, this.myFileManager, ((ProcessingEnvironment)this.getWrapperDelegate()).getElementUtils()));
            }
            return impl;
        }
    }

    static class ProcessorWrapper
    extends DynamicWrapper<Processor> {
        private final ProcessingContext myProcessingContext;
        private boolean myCodeShown = false;
        private ProcessingEnvironment myProcessingEnv;

        ProcessorWrapper(Processor delegate, ProcessingContext context) {
            super(delegate);
            this.myProcessingContext = context;
        }

        public void init(ProcessingEnvironment processingEnv) {
            this.myProcessingEnv = processingEnv;
            Ref<ClassLoader> oldCtxLoader = this.setupContextClassLoader();
            try {
                ((Processor)this.getWrapperDelegate()).init(this.myProcessingContext.getWrappedProcessingEnvironment(processingEnv));
            }
            catch (IllegalArgumentException e) {
                this.sendDiagnosticWarning(processingEnv, e);
                throw e;
            }
            finally {
                this.restoreContextClassLoader(oldCtxLoader);
            }
        }

        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            Ref<ClassLoader> oldCtxLoader = this.setupContextClassLoader();
            try {
                Processor delegate = (Processor)this.getWrapperDelegate();
                this.myProcessingContext.setLastExecutedProcessorName(delegate);
                boolean bl = delegate.process(annotations, roundEnv);
                return bl;
            }
            catch (IllegalArgumentException e) {
                this.sendDiagnosticWarning(this.myProcessingEnv, e);
                throw e;
            }
            finally {
                this.restoreContextClassLoader(oldCtxLoader);
            }
        }

        @Nullable
        private Ref<ClassLoader> setupContextClassLoader() {
            Processor delegate = (Processor)this.getWrapperDelegate();
            if (delegate != null) {
                ClassLoader currentCtxLoader;
                Thread currentThread = Thread.currentThread();
                ClassLoader processorLoader = delegate.getClass().getClassLoader();
                if (processorLoader != (currentCtxLoader = currentThread.getContextClassLoader())) {
                    currentThread.setContextClassLoader(processorLoader);
                    return Ref.create((Object)currentCtxLoader);
                }
            }
            return null;
        }

        private void restoreContextClassLoader(@Nullable Ref<ClassLoader> loaderRef) {
            if (loaderRef != null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)loaderRef.get());
            }
        }

        private void sendDiagnosticWarning(ProcessingEnvironment processingEnv, Throwable e) {
            if (processingEnv != null && !this.myCodeShown) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "The " + e.getClass() + " may be caused by the wrapped ProcessingEnvironment object.\nPlease pass the wrapped ProcessingEnvironment further to super.init().\nIf you need to access the original ProcessingEnvironment object (e.g. for creating com.sun.source.util.Trees.instance(ProcessingEnvironment)), you may use following code in the processor implementation:\n\n" + APIWrappers.getUnwrapCodeSuggestion(ProcessingEnvironment.class, "processingEnv"));
                processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Workaround: to make project compile with the current annotation processor implementation, start JPS with VM option: -Djps.track.ap.dependencies=false\nWhen run from IDE, the option can be set in \"Compiler Settings | build process VM options\"");
                this.myCodeShown = true;
            }
        }
    }

    static class DiagnosticWrapper<T>
    extends DynamicWrapper<Diagnostic<T>> {
        private final ProcessingContext myProcContext;

        DiagnosticWrapper(ProcessingContext procContext, Diagnostic<T> delegate) {
            super(delegate);
            this.myProcContext = procContext;
        }

        public String getMessage(Locale locale) {
            return this.myProcContext.adjustMessage(((Diagnostic)this.getWrapperDelegate()).getMessage(locale));
        }
    }
}

