/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.google.gson.Gson;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tJ2\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tH\u0002J\u001a\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J&\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\"\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder;", "", "()V", "buildLogMessage", "", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "eventDataToString", "eventData", "formatValue", "rawValue", "validatedValue", "prepareValue", "key", "value", "shortenAnonymizedId", "anonymizedId", "valueToString", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogMessageBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final Set<String> systemFields;
    @NotNull
    private static final Set<String> fieldsToShorten;
    private static final int anonymizedIdPrefixSize = 8;
    private static final int anonymizedIdSuffixSize = 2;
    private static final int maxProjectIdSize = 10;

    @NotNull
    public final String buildLogMessage(@NotNull LogEvent logEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildLogMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildLogMessage_u24lambda_u240.append(DateFormatUtil.formatTimeWithSeconds((long)logEvent.getTime()));
        LogEventAction event = logEvent.getEvent();
        String groupId = logEvent.getGroup().getId();
        String eventId = this.formatValue(rawEventId, logEvent.getEvent().getId());
        $this$buildLogMessage_u24lambda_u240.append(" - [\"" + groupId + "\", v" + logEvent.getGroup().getVersion() + "]: \"" + eventId + "\" ");
        int count = event.getCount();
        if (!event.getState() && count > 1) {
            $this$buildLogMessage_u24lambda_u240.append("(count=" + count + ") ");
        }
        $this$buildLogMessage_u24lambda_u240.append("{");
        $this$buildLogMessage_u24lambda_u240.append(this.eventDataToString(event.getData(), rawData));
        $this$buildLogMessage_u24lambda_u240.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String formatValue(String rawValue, String validatedValue) {
        Object object;
        if (rawValue != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValidationResultType it = (ValidationResultType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)validatedValue)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                object = validatedValue + "[" + rawValue + "]";
                return object;
            }
        }
        object = validatedValue;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String eventDataToString(Map<String, ? extends Object> eventData, Map<String, ? extends Object> rawData) {
        void $this$mapTo$iv$iv;
        String key;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Map<String, ? extends Object> $this$filter$iv = eventData;
        boolean $i$f$filter = false;
        Map<String, ? extends Object> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            key = (String)entry.getKey();
            if (!(!systemFields.contains(key))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            key = (String)entry.getKey();
            Object value = entry.getValue();
            Map<String, ? extends Object> map2 = rawData;
            object.add("\"" + key + "\":" + this.valueToString(key, value, map2 != null ? map2.get(key) : null));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String valueToString(String key, Object value, Object rawValue) {
        return gson.toJson(this.prepareValue(key, value, rawValue));
    }

    /*
     * WARNING - void declaration
     */
    private final Object prepareValue(String key, Object value, Object rawValue) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Map rawValuesMap = rawValue instanceof Map ? (Map)rawValue : null;
                Object k = it.getKey();
                Object k2 = it.getKey();
                Intrinsics.checkNotNull(k2, (String)"null cannot be cast to non-null type kotlin.String");
                Map map2 = rawValuesMap;
                it = TuplesKt.to(k, (Object)this.prepareValue((String)k2, it.getValue(), map2 != null ? map2.get(it.getKey()) : null));
                map.put(it.getFirst(), it.getSecond());
            }
            object = destination$iv$iv;
        } else if (object2 instanceof List) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable capacity$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void element;
                List rawValuesList;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object it = item$iv$iv;
                int bl = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                List list = rawValuesList = rawValue instanceof List ? (List)rawValue : null;
                collection.add(this.prepareValue(key, element, list != null ? list.get((int)index) : null));
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof String) {
            Object object3 = rawValue;
            object = this.formatValue(object3 != null ? object3.toString() : null, fieldsToShorten.contains(key) ? this.shortenAnonymizedId(((String)value).toString()) : (String)value);
        } else {
            object = value;
        }
        return object;
    }

    private final String shortenAnonymizedId(String anonymizedId) {
        boolean isRejected;
        int length;
        block4: {
            length = anonymizedId.length();
            Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValidationResultType it = (ValidationResultType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)anonymizedId)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = isRejected = false;
            }
        }
        if (!isRejected && !StringsKt.isBlank((CharSequence)anonymizedId) && length > 10) {
            String string = anonymizedId.substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = anonymizedId.substring(length - 2, length);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string + "..." + string2;
        }
        return anonymizedId;
    }

    static {
        Object[] objectArray = new String[]{"last", "created", "system_event_id", "system_headless"};
        systemFields = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"project", "file_path", "login_hash", "anonymous_id"};
        fieldsToShorten = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder$Companion;", "", "()V", "anonymizedIdPrefixSize", "", "anonymizedIdSuffixSize", "fieldsToShorten", "", "", "getFieldsToShorten$intellij_platform_statistics_devkit", "()Ljava/util/Set;", "gson", "Lcom/google/gson/Gson;", "maxProjectIdSize", "systemFields", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getFieldsToShorten$intellij_platform_statistics_devkit() {
            return fieldsToShorten;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

