/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.devkit.actions.FusStatesRecorder;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/RecordStateStatisticsEventLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "myShowNotification", "", "(Ljava/lang/String;Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "update", "Companion", "intellij.platform.statistics.devkit"})
public final class RecordStateStatisticsEventLogAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    private final boolean myShowNotification;

    public RecordStateStatisticsEventLogAction(@NotNull String recorderId, boolean myShowNotification) {
        super(ActionsBundle.message((String)"action.RecordStateCollectors.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.RecordStateCollectors.description", (Object[])new Object[0]), AllIcons.Ide.IncomingChangesOn);
        this.recorderId = recorderId;
        this.myShowNotification = myShowNotification;
    }

    public /* synthetic */ RecordStateStatisticsEventLogAction(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!Companion.checkLogRecordingEnabled(project2, this.recorderId)) {
            return;
        }
        String message = StatisticsBundle.message((String)"stats.collecting.feature.usages.in.event.log", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, message, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ RecordStateStatisticsEventLogAction this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super($project, $message, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                FeatureUsageLogger.INSTANCE.rollOver();
                List<LogEvent> state = FusStatesRecorder.INSTANCE.recordStateAndWait(this.$project, RecordStateStatisticsEventLogAction.access$getRecorderId$p(this.this$0));
                if (state == null) {
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project, NotificationType.ERROR, StatisticsBundle.message((String)"stats.failed.recording.state", (Object[])new Object[0]));
                } else if (RecordStateStatisticsEventLogAction.access$getMyShowNotification$p(this.this$0)) {
                    RecordStateStatisticsEventLogAction.access$showNotification(this.this$0, this.$project);
                }
            }
        });
    }

    private final void showNotification(Project project) {
        EventLogFile logFile = FeatureUsageLogger.INSTANCE.getConfig().getActiveLogFile();
        VirtualFile virtualFile = logFile != null ? LocalFileSystem.getInstance().findFileByIoFile(logFile.getFile()) : null;
        ApplicationManager.getApplication().invokeLater(() -> RecordStateStatisticsEventLogAction.showNotification$lambda$1(virtualFile, project));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getProject() != null && StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId) && !FusStatesRecorder.INSTANCE.isRecordingInProgress());
    }

    private static final void showNotification$lambda$1$lambda$0(Project $project, VirtualFile $virtualFile) {
        FileEditorManager.getInstance((Project)$project).openFile($virtualFile, true);
    }

    private static final void showNotification$lambda$1(VirtualFile $virtualFile, Project $project) {
        Notification notification = new Notification("FeatureUsageStatistics", "Finished collecting and recording events", NotificationType.INFORMATION);
        if ($virtualFile != null) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)StatisticsBundle.message((String)"stats.open.log.notification.action", (Object[])new Object[0]), () -> RecordStateStatisticsEventLogAction.showNotification$lambda$1$lambda$0($project, $virtualFile)));
        }
        notification.notify($project);
    }

    public RecordStateStatisticsEventLogAction() {
        this(null, false, 3, null);
    }

    public static final /* synthetic */ String access$getRecorderId$p(RecordStateStatisticsEventLogAction $this) {
        return $this.recorderId;
    }

    public static final /* synthetic */ boolean access$getMyShowNotification$p(RecordStateStatisticsEventLogAction $this) {
        return $this.myShowNotification;
    }

    public static final /* synthetic */ void access$showNotification(RecordStateStatisticsEventLogAction $this, Project project) {
        $this.showNotification(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/RecordStateStatisticsEventLogAction$Companion;", "", "()V", "checkLogRecordingEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkLogRecordingEnabled(@Nullable Project project, @Nullable String recorderId) {
            String string = recorderId;
            Intrinsics.checkNotNull((Object)string);
            if (StatisticsEventLogProviderUtil.getEventLogProvider((String)string).isRecordEnabled()) {
                return true;
            }
            new Notification("FeatureUsageStatistics", StatisticsBundle.message((String)"stats.logging.is.disabled", (Object[])new Object[0]), NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimple((String)StatisticsBundle.message((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> Companion.checkLogRecordingEnabled$lambda$0(project))).notify(project);
            return false;
        }

        private static final void checkLogRecordingEnabled$lambda$0(Project $project) {
            new SingleConfigurableEditor($project, (Configurable)new ConsentConfigurable()).show();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

