/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/OpenEventsSchemeFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "event", "Companion", "intellij.platform.statistics.devkit"})
public final class OpenEventsSchemeFileAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;

    public OpenEventsSchemeFileAction(@NotNull String recorderId) {
        Object[] objectArray = new Object[]{recorderId};
        super(StatisticsBundle.message((String)"stats.open.0.scheme.file", (Object[])objectArray), ActionsBundle.message((String)"group.OpenEventsSchemeFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Config);
        this.recorderId = recorderId;
    }

    public /* synthetic */ OpenEventsSchemeFileAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        event.getPresentation().setEnabled(event.getProject() != null && StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Companion.openFileInEditor(Companion.getEventsSchemeFile(this.recorderId), project2);
    }

    public OpenEventsSchemeFileAction() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/OpenEventsSchemeFileAction$Companion;", "", "()V", "getEventsSchemeFile", "Ljava/nio/file/Path;", "recorderId", "", "openFileInEditor", "", "file", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public final void openFileInEditor(@NotNull Path file, @NotNull Project project) {
            VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
            if (virtualFile == null) {
                Object[] objectArray = new Object[]{((Object)file).toString()};
                StatisticsDevKitUtil.INSTANCE.showNotification(project, NotificationType.WARNING, StatisticsBundle.message((String)"stats.file.0.does.not.exist", (Object[])objectArray));
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }

        @NotNull
        public final Path getEventsSchemeFile(@NotNull String recorderId) {
            EventsSchemePathSettings settings2 = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(recorderId);
            return settings2 != null && settings2.isUseCustomPath() ? Path.of(settings2.getCustomPath(), new String[0]) : BaseEventLogMetadataPersistence.getDefaultMetadataFile((String)recorderId, (String)"events-scheme.json", null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

