/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.google.gson.GsonBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/GenerateEventsScheme;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.statistics.devkit"})
public final class GenerateEventsScheme
extends DumbAwareAction {
    @NotNull
    private final String recorderId;

    public GenerateEventsScheme(@NotNull String recorderId) {
        super(ActionsBundle.message((String)"action.GenerateEventsScheme.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.GenerateEventsScheme.description", (Object[])new Object[0]), AllIcons.FileTypes.Json);
        this.recorderId = recorderId;
    }

    public /* synthetic */ GenerateEventsScheme(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null && StatisticsRecorderUtil.isTestModeEnabled((String)"FUS"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List eventsScheme = EventsSchemeBuilder.buildEventsScheme$default((String)this.recorderId, null, null, (int)6, null);
        String text = new GsonBuilder().setPrettyPrinting().create().toJson((Object)eventsScheme);
        VirtualFile scratchFile = ScratchRootType.getInstance().createScratchFile(project2, "statistics_events_scheme.json", (Language)JsonLanguage.INSTANCE, text);
        if (scratchFile == null) {
            StatisticsDevKitUtil.INSTANCE.showNotification(project2, NotificationType.ERROR, "Scratch file creation failed for unknown reasons");
            return;
        }
        FileEditorManager.getInstance((Project)project2).openFile(scratchFile, true);
    }

    public GenerateEventsScheme() {
        this(null, 1, null);
    }
}

