/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.google.common.collect.HashMultiset;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.intellij.BundleBase;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItem;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.devkit.actions.CollectFUStatisticsAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/CollectFUStatisticsAction;", "Lcom/intellij/ide/actions/GotoActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "gotoActionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showCollectorUsages", "project", "Lcom/intellij/openapi/project/Project;", "item", "Lcom/intellij/internal/statistic/devkit/actions/CollectFUStatisticsAction$Item;", "useExtendedPresentation", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "update", "Item", "MyChooseByNameModel", "intellij.platform.statistics.devkit"})
public final class CollectFUStatisticsAction
extends GotoActionBase
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)"FUS"));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List projectCollectors = ExtensionPointName.create((String)"com.intellij.statistics.projectUsagesCollector").getExtensionList();
        List applicationCollectors = ExtensionPointName.create((String)"com.intellij.statistics.applicationUsagesCollector").getExtensionList();
        List collectors = CollectionsKt.filterIsInstance((Iterable)CollectionsKt.plus((Collection)projectCollectors, (Iterable)applicationCollectors), FeatureUsagesCollector.class);
        Iterable iterable = collectors;
        Iterable destination$iv = (Collection)HashMultiset.create();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FeatureUsagesCollector featureUsagesCollector = (FeatureUsagesCollector)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it.getGroupId());
        }
        HashMultiset ids = (HashMultiset)destination$iv;
        destination$iv = collectors;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void collector;
            FeatureUsagesCollector featureUsagesCollector = (FeatureUsagesCollector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String groupId = collector.getGroupId();
            String className = StringUtil.nullize((String)collector.getClass().getSimpleName(), (boolean)true);
            collection.add(new Item((FeatureUsagesCollector)collector, groupId, className, ids.count((Object)groupId) > 1));
        }
        List items = (List)destination$iv$iv;
        ContainerUtil.sort((List)items, Comparator.comparing(arg_0 -> CollectFUStatisticsAction.gotoActionPerformed$lambda$2(gotoActionPerformed.1.INSTANCE, arg_0)));
        MyChooseByNameModel model = new MyChooseByNameModel(project2, items);
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup((Project)project2, (ChooseByNameModel)((ChooseByNameModel)model), (PsiElement)GotoActionBase.getPsiContext((AnActionEvent)e));
        popup.setShowListForEmptyPattern(true);
        popup.invoke(new ChooseByNamePopupComponent.Callback(this, project2, model){
            final /* synthetic */ CollectFUStatisticsAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MyChooseByNameModel $model;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$model = $model;
            }

            public void onClose() {
                if (Intrinsics.areEqual(((Object)((Object)this.this$0)).getClass(), (Object)CollectFUStatisticsAction.access$getMyInAction$p$s2488330())) {
                    CollectFUStatisticsAction.access$setMyInAction$p$s2488330(null);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void elementChosen(@NotNull Object element) {
                void cancellable$iv;
                void title$iv;
                void project$iv;
                String string = "Collecting statistics";
                Project project = this.$project;
                boolean bl = true;
                CollectFUStatisticsAction collectFUStatisticsAction = this.this$0;
                Project project2 = this.$project;
                MyChooseByNameModel myChooseByNameModel = this.$model;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, (boolean)cancellable$iv, element, collectFUStatisticsAction, project2, myChooseByNameModel){
                    final /* synthetic */ Object $element$inlined;
                    final /* synthetic */ CollectFUStatisticsAction this$0;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ MyChooseByNameModel $model$inlined;
                    {
                        this.$element$inlined = object;
                        this.this$0 = collectFUStatisticsAction;
                        this.$project$inlined = project;
                        this.$model$inlined = myChooseByNameModel;
                        super($project, $title, $cancellable);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator indicator2 = indicator;
                        boolean bl = false;
                        indicator2.setIndeterminate(true);
                        Intrinsics.checkNotNull((Object)this.$element$inlined, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.devkit.actions.CollectFUStatisticsAction.Item");
                        indicator2.setText2(((Item)this.$element$inlined).getUsagesCollector().getClass().getSimpleName());
                        CollectFUStatisticsAction.access$showCollectorUsages(this.this$0, this.$project$inlined, (Item)this.$element$inlined, this.$model$inlined.getUseExtendedPresentation(), indicator2);
                    }
                });
            }
        }, ModalityState.current(), false);
    }

    private final void showCollectorUsages(Project project, Item item, boolean useExtendedPresentation, ProgressIndicator indicator) {
        Promise promise;
        if (project.isDisposed()) {
            return;
        }
        FeatureUsagesCollector collector = item.getUsagesCollector();
        FeatureUsagesCollector featureUsagesCollector = collector;
        if (featureUsagesCollector instanceof ApplicationUsagesCollector) {
            promise = Promises.resolvedPromise((Object)((ApplicationUsagesCollector)collector).getMetrics());
        } else if (featureUsagesCollector instanceof ProjectUsagesCollector) {
            promise = (Promise)((ProjectUsagesCollector)collector).getMetrics(project, indicator);
        } else {
            throw new IllegalArgumentException("Unsupported collector: " + collector);
        }
        Promise metricsPromise = promise;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        StringBuilder result = new StringBuilder();
        metricsPromise.onSuccess(arg_0 -> CollectFUStatisticsAction.showCollectorUsages$lambda$3((Function1)new Function1<Set<? extends MetricEvent>, Unit>(useExtendedPresentation, result, collector, gson, item, project){
            final /* synthetic */ boolean $useExtendedPresentation;
            final /* synthetic */ StringBuilder $result;
            final /* synthetic */ FeatureUsagesCollector $collector;
            final /* synthetic */ Gson $gson;
            final /* synthetic */ Item $item;
            final /* synthetic */ Project $project;
            {
                this.$useExtendedPresentation = $useExtendedPresentation;
                this.$result = $result;
                this.$collector = $collector;
                this.$gson = $gson;
                this.$item = $item;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Set<MetricEvent> metrics) {
                if (this.$useExtendedPresentation) {
                    this.$result.append("[\n");
                    for (MetricEvent metric : metrics) {
                        FeatureUsageData featureUsageData = FUStateUsagesLogger.Companion.mergeWithEventData(null, metric.getData());
                        Intrinsics.checkNotNull((Object)featureUsageData);
                        Map metricData = featureUsageData.build();
                        LogEvent event = StatisticsEventEscaperKt.newLogEvent$default((String)"test.session", (String)"build", (String)"bucket", (long)System.currentTimeMillis(), (String)this.$collector.getGroupId(), (String)String.valueOf(this.$collector.getVersion()), (String)"recorder.version", (String)"event.id", (boolean)true, (Map)metricData, (int)0, (int)1024, null);
                        String presentation = LogEventSerializer.INSTANCE.toString(event);
                        this.$result.append(presentation);
                        this.$result.append(",\n");
                    }
                    this.$result.append("]");
                } else {
                    this.$result.append("{");
                    for (MetricEvent metric : metrics) {
                        this.$result.append("\"");
                        this.$result.append(metric.getEventId());
                        this.$result.append("\" : ");
                        JsonElement presentation = this.$gson.toJsonTree((Object)metric.getData().build());
                        this.$result.append(presentation);
                        this.$result.append(",\n");
                    }
                    this.$result.append("}");
                }
                FileType fileType = FileTypeManager.getInstance().getStdFileType("JSON");
                LightVirtualFile file = new LightVirtualFile(this.$item.getGroupId(), fileType, (CharSequence)this.$result.toString());
                ApplicationManager.getApplication().invokeLater(() -> showCollectorUsages.1.invoke$lambda$0(this.$project, file));
            }

            private static final void invoke$lambda$0(Project $project, LightVirtualFile $file) {
                FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)$file, true);
            }
        }, arg_0));
    }

    private static final String gotoActionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void showCollectorUsages$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Class access$getMyInAction$p$s2488330() {
        return GotoActionBase.myInAction;
    }

    public static final /* synthetic */ void access$setMyInAction$p$s2488330(Class clazz) {
        GotoActionBase.myInAction = clazz;
    }

    public static final /* synthetic */ void access$showCollectorUsages(CollectFUStatisticsAction $this, Project project, Item item, boolean useExtendedPresentation, ProgressIndicator indicator) {
        $this.showCollectorUsages(project, item, useExtendedPresentation, indicator);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/CollectFUStatisticsAction$Item;", "Lcom/intellij/ide/util/gotoByName/ChooseByNameItem;", "usagesCollector", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "groupId", "", "className", "nonUniqueId", "", "(Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;Ljava/lang/String;Ljava/lang/String;Z)V", "getClassName", "()Ljava/lang/String;", "getGroupId", "getNonUniqueId", "()Z", "getUsagesCollector", "()Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "getDescription", "getName", "intellij.platform.statistics.devkit"})
    private static final class Item
    implements ChooseByNameItem {
        @NotNull
        private final FeatureUsagesCollector usagesCollector;
        @NotNull
        private final String groupId;
        @Nullable
        private final String className;
        private final boolean nonUniqueId;

        public Item(@NotNull FeatureUsagesCollector usagesCollector, @NotNull String groupId, @Nullable String className, boolean nonUniqueId) {
            this.usagesCollector = usagesCollector;
            this.groupId = groupId;
            this.className = className;
            this.nonUniqueId = nonUniqueId;
        }

        @NotNull
        public final FeatureUsagesCollector getUsagesCollector() {
            return this.usagesCollector;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public final String getClassName() {
            return this.className;
        }

        public final boolean getNonUniqueId() {
            return this.nonUniqueId;
        }

        @NotNull
        public String getName() {
            return this.groupId + (String)(this.nonUniqueId ? " (" + this.className + ")" : "");
        }

        @Nullable
        public String getDescription() {
            return this.className;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/CollectFUStatisticsAction$MyChooseByNameModel;", "Lcom/intellij/ide/util/gotoByName/ListChooseByNameModel;", "Lcom/intellij/internal/statistic/devkit/actions/CollectFUStatisticsAction$Item;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "items", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "useExtendedPresentation", "", "getUseExtendedPresentation", "()Z", "setUseExtendedPresentation", "(Z)V", "getCheckBoxName", "", "loadInitialCheckBoxState", "saveInitialCheckBoxState", "", "state", "useMiddleMatching", "intellij.platform.statistics.devkit"})
    private static final class MyChooseByNameModel
    extends ListChooseByNameModel<Item>
    implements DumbAware {
        private boolean useExtendedPresentation;

        public MyChooseByNameModel(@NotNull Project project, @NotNull List<Item> items) {
            super(project, "Enter usage collector group id", "No collectors found", items);
        }

        public final boolean getUseExtendedPresentation() {
            return this.useExtendedPresentation;
        }

        public final void setUseExtendedPresentation(boolean bl) {
            this.useExtendedPresentation = bl;
        }

        @Nullable
        public String getCheckBoxName() {
            return BundleBase.replaceMnemonicAmpersand((String)"&Extended presentation");
        }

        public boolean loadInitialCheckBoxState() {
            return false;
        }

        public void saveInitialCheckBoxState(boolean state) {
            this.useExtendedPresentation = state;
        }

        public boolean useMiddleMatching() {
            return true;
        }
    }
}

