/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.DigitColorDocument;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorValueField;", "Ljavax/swing/JTextField;", "hex", "", "(Z)V", "colorValue", "", "getColorValue", "()I", "increaseValue", "", "diff", "isFocusable", "intellij.android.adt.ui"})
public final class ColorValueField
extends JTextField {
    private final boolean hex;

    public ColorValueField(boolean hex) {
        super(hex ? 8 : 3);
        this.hex = hex;
        this.setHorizontalAlignment(0);
        this.setEnabled(true);
        this.setEditable(true);
        Font labelFont = StartupUiUtil.getLabelFont();
        this.setFont(labelFont.deriveFont((float)labelFont.getSize() * 0.9f));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                this.selectAll();
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                Document document = this.getDocument();
                if (document == null) {
                    return;
                }
                int size = document.getLength();
                this.setSelectionStart(size);
                this.setSelectionEnd(size);
            }
        });
        if (!this.hex) {
            InputMap $this$_init__u24lambda_u240 = this.getInputMap(0);
            boolean bl = false;
            $this$_init__u24lambda_u240.put(KeyStroke.getKeyStroke(38, 0), "up");
            $this$_init__u24lambda_u240.put(KeyStroke.getKeyStroke(40, 0), "down");
            ActionMap $this$_init__u24lambda_u241 = this.getActionMap();
            boolean bl2 = false;
            $this$_init__u24lambda_u241.put("up", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, 1);
                }
            });
            $this$_init__u24lambda_u241.put("down", new AbstractAction(this){
                final /* synthetic */ ColorValueField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ColorValueField.access$increaseValue(this.this$0, -1);
                }
            });
        }
    }

    public /* synthetic */ ColorValueField(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    private final void increaseValue(int diff) {
        boolean bl;
        boolean bl2 = bl = !this.hex;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.android.tools.idea.ui.resourcechooser.colorpicker2.DigitColorDocument");
        DigitColorDocument doc = (DigitColorDocument)document;
        String string = doc.getText(0, doc.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.getText(0, doc.length)");
        int newValue = Integer.parseInt(string) + diff;
        int valueInRange = Math.max(doc.getValueRange().getStart(), Math.min(newValue, doc.getValueRange().getEndInclusive()));
        this.setText(String.valueOf(valueInRange));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public final int getColorValue() {
        String rawText = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)rawText, (String)"rawText");
        return StringsKt.isBlank((CharSequence)rawText) ? 0 : Integer.parseInt(rawText, this.hex ? 16 : 10);
    }

    public ColorValueField() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$increaseValue(ColorValueField $this, int diff) {
        $this.increaseValue(diff);
    }
}

