/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SideModel<T> {
    private final List<AttachedToolWindow<T>> myAllTools = new ArrayList<AttachedToolWindow<T>>(8);
    private final VisiblePair<T> myLeftVisibleTools = new VisiblePair();
    private final VisiblePair<T> myRightVisibleTools = new VisiblePair();
    private final List<Listener<T>> myListeners = new ArrayList<Listener<T>>(2);
    private final Project myProject;
    private T myContext;
    private AttachedToolWindow<T> myVisibleAutoHideTool;

    SideModel(@NotNull Project project) {
        this.myProject = project;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setContext(T context) {
        this.myContext = context;
        this.myAllTools.forEach(tool -> tool.setContext(context));
    }

    public T getContext() {
        return this.myContext;
    }

    public void addListener(@NotNull Listener<T> listener2) {
        this.myListeners.add(listener2);
    }

    @NotNull
    public List<AttachedToolWindow<T>> getAllTools() {
        return this.myAllTools;
    }

    @NotNull
    public List<AttachedToolWindow> getVisibleTools(@NotNull Side side) {
        return this.getVisibleTools(side.isLeft()).asList();
    }

    @NotNull
    public List<AttachedToolWindow> getHiddenTools(@NotNull Side side) {
        return this.myAllTools.stream().filter(tool -> tool.isMinimized() && !tool.isDetached() && !tool.isAutoHide() && tool.isLeft() == side.isLeft()).collect(Collectors.toList());
    }

    @NotNull
    public List<AttachedToolWindow> getTopTools(@NotNull Side side) {
        return this.myAllTools.stream().filter(tool -> !tool.isDetached() && tool.isLeft() == side.isLeft() && (!tool.isSplit() || tool.isAutoHide())).collect(Collectors.toList());
    }

    @NotNull
    public List<AttachedToolWindow> getBottomTools(@NotNull Side side) {
        return this.myAllTools.stream().filter(tool -> !tool.isDetached() && tool.isLeft() == side.isLeft() && tool.isSplit() && !tool.isAutoHide()).collect(Collectors.toList());
    }

    @Nullable
    public AttachedToolWindow<T> getVisibleAutoHideTool() {
        return this.myVisibleAutoHideTool;
    }

    @NotNull
    public List<AttachedToolWindow<T>> getHiddenSliders() {
        return this.myAllTools.stream().filter(tool -> tool.isAutoHide() && !tool.isDetached() && tool.isMinimized()).collect(Collectors.toList());
    }

    @NotNull
    public List<AttachedToolWindow<T>> getDetachedTools() {
        return this.myAllTools.stream().filter(AttachedToolWindow::isDetached).collect(Collectors.toList());
    }

    public void setTools(@NotNull List<AttachedToolWindow<T>> tools) {
        tools.forEach(this::add);
        this.updateLocally();
    }

    private void add(@NotNull AttachedToolWindow<T> tool) {
        VisiblePair<T> visible;
        this.myAllTools.add(tool);
        if (!(tool.isMinimized() || tool.isDetached() || (visible = this.getVisibleTools(tool.isLeft())).setIfEmpty(tool))) {
            tool.setMinimized(true);
        }
    }

    public void changeToolSettingsAfterDragAndDrop(@NotNull AttachedToolWindow<T> tool, @NotNull Side side, @NotNull Split split, int wantedSideToolIndex) {
        tool.setLeft(side.isLeft());
        tool.setSplit(split.isBottom());
        List<AttachedToolWindow> list = split.isBottom() ? this.getBottomTools(side) : this.getTopTools(side);
        int index = list.indexOf(tool);
        if (index != wantedSideToolIndex && wantedSideToolIndex >= 0 && wantedSideToolIndex < list.size()) {
            int insertAfter = index < wantedSideToolIndex ? 1 : 0;
            this.myAllTools.remove(tool);
            this.myAllTools.add(this.myAllTools.indexOf(list.get(wantedSideToolIndex)) + insertAfter, tool);
        }
        this.update(Collections.singletonList(tool), EventType.UPDATE_TOOL_ORDER);
    }

    public void update(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.PropertyType typeOfChange) {
        this.update(Collections.singletonList(tool), typeOfChange == AttachedToolWindow.PropertyType.DETACHED ? EventType.UPDATE_DETACHED_WINDOW : EventType.UPDATE);
    }

    public void updateLocally() {
        this.myLeftVisibleTools.removeBoth();
        this.myRightVisibleTools.removeBoth();
        this.update(this.myAllTools, EventType.LOCAL_UPDATE);
    }

    private void update(@NotNull List<AttachedToolWindow<T>> tools, @NotNull EventType eventType) {
        for (AttachedToolWindow<T> tool : tools) {
            this.getVisibleTools(true).remove(tool);
            this.getVisibleTools(false).remove(tool);
            if (this.myVisibleAutoHideTool == tool) {
                this.myVisibleAutoHideTool = null;
            }
            if (tool.isMinimized() || tool.isDetached()) continue;
            if (tool.isAutoHide()) {
                if (this.myVisibleAutoHideTool != null) {
                    this.myVisibleAutoHideTool.setMinimized(true);
                }
                this.myVisibleAutoHideTool = tool;
                continue;
            }
            AttachedToolWindow<T> old = this.getVisibleTools(tool.isLeft()).set(tool.isSplit(), tool);
            if (old == null || old == tool) continue;
            old.setMinimized(true);
        }
        this.notifyListeners(eventType);
    }

    public void swap() {
        this.myAllTools.forEach(tool -> tool.setLeft(!tool.isLeft()));
        this.myLeftVisibleTools.swap(this.myRightVisibleTools);
        this.notifyListeners(EventType.SWAP);
    }

    private void notifyListeners(@NotNull EventType type) {
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this, type));
    }

    @NotNull
    private VisiblePair<T> getVisibleTools(boolean isLeft) {
        return isLeft ? this.myLeftVisibleTools : this.myRightVisibleTools;
    }

    public static class VisiblePair<T> {
        @Nullable
        public AttachedToolWindow<T> myTop;
        @Nullable
        public AttachedToolWindow<T> myBottom;

        @Nullable
        public AttachedToolWindow<T> get(boolean isSplit) {
            return isSplit ? this.myBottom : this.myTop;
        }

        @Nullable
        public AttachedToolWindow<T> set(boolean isSplit, @Nullable AttachedToolWindow<T> tool) {
            AttachedToolWindow<T> old = this.get(isSplit);
            if (isSplit) {
                this.myBottom = tool;
            } else {
                this.myTop = tool;
            }
            return old;
        }

        public boolean setIfEmpty(@NotNull AttachedToolWindow<T> tool) {
            if (this.get(tool.isSplit()) != null) {
                return false;
            }
            this.set(tool.isSplit(), tool);
            return true;
        }

        public void remove(@NotNull AttachedToolWindow<T> tool) {
            if (this.myTop == tool) {
                this.myTop = null;
            }
            if (this.myBottom == tool) {
                this.myBottom = null;
            }
        }

        public void removeBoth() {
            this.myTop = null;
            this.myBottom = null;
        }

        public void swap(@NotNull VisiblePair<T> other) {
            this.myTop = other.set(false, this.myTop);
            this.myBottom = other.set(true, this.myBottom);
        }

        @NotNull
        public List<AttachedToolWindow> asList() {
            if (this.myTop == null && this.myBottom == null) {
                return ImmutableList.of();
            }
            if (this.myTop == null || this.myBottom == null) {
                return ImmutableList.of(this.myTop == null ? this.myBottom : this.myTop);
            }
            return ImmutableList.of(this.myTop, this.myBottom);
        }
    }

    public static enum EventType {
        UPDATE,
        UPDATE_DETACHED_WINDOW,
        LOCAL_UPDATE,
        SWAP,
        UPDATE_TOOL_ORDER;

    }

    public static interface Listener<T> {
        public void modelChanged(@NotNull SideModel<T> var1, @NotNull EventType var2);
    }
}

