/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.ErrorDetailDialog;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.SwingHelper;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK_HTML = "<html></html>";
    private final ListenerManager myListeners;
    private final List<Validator.Result> myResults;
    private final ObjectProperty<Validator.Result> myValidationResult;
    private final BooleanExpression myHasErrorsExpression;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel mySeverityIcon;
    private JEditorPane myValidationText;
    private ErrorDetailDialog myErrorDetailDialog;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel, @NotNull String errorDetailDialogTitle, @NotNull String errorDetailHeader) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myResults = new ArrayList<Validator.Result>();
        this.myValidationResult = new ObjectValueProperty((Object)Validator.Result.OK);
        this.myHasErrorsExpression = new BooleanExpression(new ObservableValue[]{this.myValidationResult}){

            @NotNull
            public Boolean get() {
                return ((Validator.Result)ValidatorPanel.this.myValidationResult.get()).getSeverity() == Validator.Severity.ERROR;
            }
        };
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationText.setName("ValidationText");
        this.myValidationText.setText(BLANK_HTML);
        this.myValidationText.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String detailedMessage = ((Validator.Result)this.myValidationResult.get()).getDetailedMessage();
                if (this.myErrorDetailDialog == null) {
                    this.myErrorDetailDialog = new ErrorDetailDialog(errorDetailDialogTitle, errorDetailHeader, detailedMessage);
                    Disposer.register((Disposable)this.myErrorDetailDialog.getDisposable(), () -> {
                        this.myErrorDetailDialog = null;
                    });
                    Disposer.register((Disposable)this, () -> {
                        if (this.myErrorDetailDialog != null) {
                            this.myErrorDetailDialog.close(1);
                        }
                    });
                    this.myErrorDetailDialog.show();
                } else {
                    this.myErrorDetailDialog.setText(detailedMessage);
                }
            }
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        this(parentDisposable, innerPanel, "Errors", "Error Details:");
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<? super T> validator, ObservableValue<?> ... dependencies) {
        ArrayList triggerObjects = Lists.newArrayList((Object[])new ObservableValue[]{value});
        if (dependencies.length > 0) {
            triggerObjects.addAll(Arrays.asList(dependencies));
        }
        int index = this.myResults.size();
        this.myResults.add(Validator.Result.OK);
        this.myListeners.listenAll((Collection)triggerObjects).withAndFire(() -> {
            Validator.Result oldValue = this.myResults.get(index);
            Validator.Result newValue = validator.validate(value.get());
            if (!newValue.equals(oldValue)) {
                this.myResults.set(index, newValue);
                this.updateActiveValidationResult();
            }
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        this.registerValidator(value, new TrueValidator(severity, message), new ObservableValue[0]);
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        this.registerValidator(message, value -> {
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        }, new ObservableValue[0]);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myHasErrorsExpression;
    }

    @NotNull
    public ObservableValue<Validator.Result> getValidationResult() {
        return this.myValidationResult;
    }

    private void updateActiveValidationResult() {
        Validator.Result activeResult = Validator.Result.OK;
        for (Validator.Result result : this.myResults) {
            if (result.getSeverity().compareTo(activeResult.getSeverity()) > 0 && (activeResult = result).getSeverity() == Validator.Severity.ERROR) break;
        }
        if (activeResult.getSeverity() == Validator.Severity.OK) {
            this.mySeverityIcon.setIcon(null);
            this.myValidationText.setText(BLANK_HTML);
        } else {
            this.mySeverityIcon.setIcon(activeResult.getSeverity().getIcon());
            String message = activeResult.getMessage().trim();
            if (!XmlStringUtil.isWrappedInHtml((String)message)) {
                message = !StringUtil.isEmpty((String)activeResult.getDetailedMessage()) ? XmlStringUtil.wrapInHtml((CharSequence)("<a href=\"details\">" + ValidatorPanel.convertToHtml(message) + "</a>")) : XmlStringUtil.wrapInHtml((CharSequence)ValidatorPanel.convertToHtml(message));
            }
            this.myValidationText.setText(message);
        }
        this.myValidationResult.set((Object)activeResult);
    }

    @NotNull
    private static String convertToHtml(String message) {
        return StringUtil.replace((String)XmlStringUtil.escapeString((String)message), (String)"\n", (String)"<br>");
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    @TestOnly
    @NotNull
    public JEditorPane getValidationText() {
        return this.myValidationText;
    }

    private void createUIComponents() {
        this.myValidationText = SwingHelper.createHtmlViewer((boolean)true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
        this.myValidationText.setOpaque(false);
        this.myValidationText.setFocusable(false);
        this.myValidationText.addHyperlinkListener(event -> {});
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(154, 32));
        jPanel.setPreferredSize(new Dimension(154, 32));
        jPanel2.add((Component)jPanel, "South");
        this.mySeverityIcon = jBLabel = new JBLabel();
        jBLabel.setFocusable(false);
        jBLabel.setIconTextGap(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 1, 0, 1, 0, null, null, null));
        JEditorPane jEditorPane = this.myValidationText;
        ((Component)jEditorPane).setBackground(new Color(-855310));
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setMargin(new Insets(0, 0, 0, 0));
        jEditorPane.setText("");
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

