/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.android.tools.adtui.treegrid.TreeGrid;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ui.SpeedSearchBase;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGridSpeedSearch<T>
extends SpeedSearchBase<TreeGrid<T>> {
    private final Function<T, String> myConverter;
    private boolean myWasPopupRecentlyActive;

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid) {
        this(grid, null);
    }

    public TreeGridSpeedSearch(@NotNull TreeGrid<T> grid, @Nullable Function<T, String> converter) {
        super(grid);
        this.myConverter = converter;
        this.addChangeListener(event -> this.popupChange());
    }

    protected int getSelectedIndex() {
        int offset = 0;
        List lists = ((TreeGrid)this.myComponent).getLists();
        for (JList list : lists) {
            if (list.getSelectedIndex() > -1) {
                return offset + list.getSelectedIndex();
            }
            offset += list.getModel().getSize();
        }
        return -1;
    }

    @NotNull
    protected ListIterator<Object> getElementIterator(int startingViewIndex) {
        AbstractTreeStructure model2 = ((TreeGrid)this.myComponent).getModel();
        List list = model2 == null ? Collections.emptyList() : Arrays.stream(model2.getChildElements(model2.getRootElement())).flatMap(section -> Arrays.stream(model2.getChildElements(section))).collect(Collectors.toUnmodifiableList());
        return list.listIterator(startingViewIndex);
    }

    protected int getElementCount() {
        AbstractTreeStructure model2 = ((TreeGrid)this.myComponent).getModel();
        return model2 == null ? 0 : (int)Arrays.stream(model2.getChildElements(model2.getRootElement())).flatMap(section -> Arrays.stream(model2.getChildElements(section))).count();
    }

    @Nullable
    protected String getElementText(@NotNull Object element) {
        if (this.myConverter != null) {
            return this.myConverter.apply(element);
        }
        return element.toString();
    }

    protected void selectElement(@NotNull Object element, String selectedText) {
        ((TreeGrid)this.myComponent).setSelectedElement(element);
    }

    private void popupChange() {
        boolean isPopupCurrentlyActive = this.isPopupActive();
        if (!isPopupCurrentlyActive && this.myWasPopupRecentlyActive && this.focusInTreeGrid()) {
            ((TreeGrid)this.myComponent).requestFocus();
        }
        this.myWasPopupRecentlyActive = isPopupCurrentlyActive;
    }

    private boolean focusInTreeGrid() {
        Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focus != null && SwingUtilities.isDescendingFrom(focus, this.myComponent);
    }
}

