/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.trackgroup;

import com.android.tools.adtui.BoxSelectionComponent;
import com.android.tools.adtui.DragAndDropList;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.model.trackgroup.TrackGroupModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.android.tools.adtui.trackgroup.Track;
import com.android.tools.adtui.trackgroup.TrackGroupMover;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.adtui.util.SwingUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackGroup
extends AspectObserver {
    private static final Icon EXPAND_ICON = AllIcons.Actions.FindAndShowNextMatches;
    private static final Icon COLLAPSE_ICON = AllIcons.Actions.FindAndShowPrevMatches;
    private static final Font TITLE_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(5.0f);
    private static final String TOGGLE_EXPAND_COLLAPSE_TRACK_KEY = "TOGGLE_EXPAND_COLLAPSE_KEY";
    private static final String COL_SIZES = Track.REORDER_ICON.getIconWidth() + "px," + (150 - Track.REORDER_ICON.getIconWidth()) + "px,*";
    private final TrackGroupModel myModel;
    private final JPanel myComponent;
    private final JLabel myTitleLabel;
    private final JLabel myTitleInfoIcon;
    private final JPanel myOverlay = new JPanel();
    private final JPanel myTrackTitleOverlay = new JPanel();
    private final JPanel myTagCheckBoxPanel = new JPanel();
    private final DragAndDropList<TrackModel<?, ?>> myTrackList;
    private final CommonDropDownButton myActionsDropdown;
    private final FlatSeparator mySeparator = new FlatSeparator();
    private final CommonButton myCollapseButton;
    private final Map<Integer, Track> myTrackMap;
    private final AspectObserver myObserver = new AspectObserver();
    @Nullable
    private final BoxSelectionComponent myBoxSelectionComponent;
    private boolean myIsEnabled = true;

    public TrackGroup(final @NotNull TrackGroupModel groupModel, final @NotNull TrackRendererFactory rendererFactory) {
        this.myModel = groupModel;
        this.myTrackMap = new HashMap<Integer, Track>();
        this.myTrackList = new DragAndDropList(groupModel);
        this.myTrackList.setCellRenderer(new ListCellRenderer<TrackModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends TrackModel> list, TrackModel value, int index, boolean isSelected, boolean cellHasFocus) {
                return TrackGroup.this.myTrackMap.computeIfAbsent(value.getId(), id -> {
                    TrackRenderer<?> renderer = rendererFactory.createRenderer(value.getRendererType());
                    value.getAspectModel().addDependency(TrackGroup.this.myObserver).onChange(TrackModel.Aspect.COLLAPSE_CHANGE, () -> TrackGroup.this.myTrackMap.put((Integer)id, Track.create(value, renderer)));
                    return Track.create(value, renderer);
                }).updateUiStates(groupModel.isTrackSelectable() && isSelected).getComponent();
            }
        });
        this.myActionsDropdown = new CommonDropDownButton(new CommonAction("", AllIcons.Actions.More));
        this.myActionsDropdown.setToolTipText("More actions");
        this.initShowMoreDropdown();
        this.myCollapseButton = new CommonButton(COLLAPSE_ICON);
        this.myCollapseButton.setHorizontalTextPosition(2);
        this.myCollapseButton.addActionListener(actionEvent -> this.setCollapsed(this.myTrackList.isVisible()));
        this.setCollapsed(groupModel.isCollapsedInitially());
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
        this.myTagCheckBoxPanel.setLayout(new BoxLayout(this.myTagCheckBoxPanel, 0));
        toolbarPanel.add(this.myTagCheckBoxPanel);
        groupModel.getAllDisplayToggles().forEach(tag -> this.myTagCheckBoxPanel.add(this.tagCheckBox((String)tag)));
        toolbarPanel.add(this.myActionsDropdown);
        toolbarPanel.add(this.mySeparator);
        toolbarPanel.add(this.myCollapseButton);
        this.myTitleLabel = new JLabel(groupModel.getTitle());
        this.myTitleLabel.setFont(TITLE_FONT);
        this.myTitleLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myTitleInfoIcon = new JLabel(StudioIcons.Common.HELP);
        this.myTitleInfoIcon.setVisible(groupModel.getTitleHelpText() != null);
        if (groupModel.getTitleHelpText() != null) {
            HelpTooltip helpTooltip = new HelpTooltip().setDescription(groupModel.getTitleHelpText());
            if (groupModel.getTitleHelpLinkUrl() != null) {
                helpTooltip.setLink(groupModel.getTitleHelpLinkText(), () -> BrowserUtil.browse((String)groupModel.getTitleHelpLinkUrl()));
            }
            helpTooltip.installOn((JComponent)this.myTitleInfoIcon);
        }
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)1, (int)0, (int)1, (int)0));
        if (!groupModel.getHideHeader()) {
            JPanel westTitlePanel = new JPanel();
            westTitlePanel.add(this.myTitleLabel);
            westTitlePanel.add(this.myTitleInfoIcon);
            titlePanel.add((Component)westTitlePanel, "West");
        }
        titlePanel.add((Component)toolbarPanel, "East");
        this.myOverlay.setOpaque(false);
        TrackContentMouseEventHandler trackContentMouseEventHandler = new TrackContentMouseEventHandler();
        this.myOverlay.addMouseListener((MouseListener)((Object)trackContentMouseEventHandler));
        this.myOverlay.addMouseMotionListener((MouseMotionListener)((Object)trackContentMouseEventHandler));
        this.myTrackTitleOverlay.setOpaque(false);
        TrackTitleMouseEventHandler trackTitleMouseEventHandler = new TrackTitleMouseEventHandler();
        this.myTrackTitleOverlay.addMouseListener((MouseListener)((Object)trackTitleMouseEventHandler));
        this.myComponent = new JPanel(new TabularLayout(COL_SIZES));
        if (groupModel.getBoxSelectionModel() != null) {
            this.myBoxSelectionComponent = new BoxSelectionComponent(groupModel.getBoxSelectionModel(), this.myTrackList);
            DelegateMouseEventHandler.delegateTo(this.myOverlay).installListenerOn(this.myBoxSelectionComponent).installMotionListenerOn(this.myBoxSelectionComponent);
            this.myComponent.add((Component)this.myBoxSelectionComponent, new TabularLayout.Constraint(1, 2));
        } else {
            this.myBoxSelectionComponent = null;
        }
        this.myComponent.add((Component)this.myTrackTitleOverlay, new TabularLayout.Constraint(1, 1));
        this.myComponent.add((Component)this.myOverlay, new TabularLayout.Constraint(1, 2));
        this.myComponent.add((Component)titlePanel, new TabularLayout.Constraint(0, 0, 1, 3));
        this.myComponent.add(this.myTrackList, new TabularLayout.Constraint(1, 0, 1, 3));
        this.initKeyBindings(this.myTrackList);
    }

    private JCheckBox tagCheckBox(String tag) {
        JBCheckBox tagCheckbox = new JBCheckBox(tag, this.getModel().getActiveDisplayToggles().contains(tag));
        tagCheckbox.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        tagCheckbox.addItemListener(e -> this.getModel().setDisplayTag(tag, tagCheckbox.isSelected()));
        return tagCheckbox;
    }

    @NotNull
    public TrackGroupModel getModel() {
        return this.myModel;
    }

    public void setCollapsed(boolean collapsed) {
        if (collapsed) {
            this.myTrackList.setVisible(false);
            this.myOverlay.setVisible(false);
            this.myTrackTitleOverlay.setVisible(false);
            this.mySeparator.setVisible(false);
            this.myActionsDropdown.setVisible(false);
            this.myTagCheckBoxPanel.setVisible(false);
            this.myCollapseButton.setText("Expand Section");
            this.myCollapseButton.setIcon(EXPAND_ICON);
            this.getModel().getActionListeners().forEach(listener2 -> listener2.onGroupCollapsed(this.getModel().getTitle()));
        } else {
            this.myTrackList.setVisible(true);
            this.myOverlay.setVisible(true);
            this.myTrackTitleOverlay.setVisible(true);
            this.mySeparator.setVisible(true);
            this.myActionsDropdown.setVisible(true);
            this.myTagCheckBoxPanel.setVisible(true);
            this.myCollapseButton.setText(null);
            this.myCollapseButton.setIcon(COLLAPSE_ICON);
            this.getModel().getActionListeners().forEach(listener2 -> listener2.onGroupExpanded(this.getModel().getTitle()));
        }
    }

    public TrackGroup setMover(@Nullable TrackGroupMover mover) {
        this.initShowMoreDropdown();
        if (mover != null) {
            this.myActionsDropdown.getAction().addChildrenActions(new CommonAction("Move Up", null, () -> {
                mover.moveTrackGroupUp(this);
                this.getModel().getActionListeners().forEach(listener2 -> listener2.onGroupMovedUp(this.getModel().getTitle()));
            }));
            this.myActionsDropdown.getAction().addChildrenActions(new CommonAction("Move Down", null, () -> {
                mover.moveTrackGroupDown(this);
                this.getModel().getActionListeners().forEach(listener2 -> listener2.onGroupMovedDown(this.getModel().getTitle()));
            }));
        }
        return this;
    }

    @NotNull
    public DragAndDropList<TrackModel<?, ?>> getTrackList() {
        return this.myTrackList;
    }

    public boolean isEmpty() {
        return this.myTrackList.getModel().getSize() == 0;
    }

    public TrackModel getTrackModelAt(int index) {
        return (TrackModel)this.myTrackList.getModel().getElementAt(index);
    }

    @NotNull
    public Map<Integer, Track> getTrackMap() {
        return this.myTrackMap;
    }

    public void setEventHandlersEnabled(boolean enabled) {
        this.myIsEnabled = enabled;
        this.myTrackList.setEnabled(enabled);
        this.myTrackList.setDragEnabled(enabled);
        if (this.myBoxSelectionComponent != null) {
            this.myBoxSelectionComponent.setEventHandlersEnabled(enabled);
        }
    }

    private void initShowMoreDropdown() {
        this.myActionsDropdown.getAction().clear();
    }

    private void initKeyBindings(final @NotNull JList list) {
        list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), TOGGLE_EXPAND_COLLAPSE_TRACK_KEY);
        list.getActionMap().put(TOGGLE_EXPAND_COLLAPSE_TRACK_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int selectedIndex : list.getSelectedIndices()) {
                    TrackModel model2 = (TrackModel)TrackGroup.this.myModel.get(selectedIndex);
                    if (!model2.isCollapsible()) continue;
                    model2.setCollapsed(!model2.isCollapsed());
                }
            }
        });
    }

    @VisibleForTesting
    JLabel getTitleLabel() {
        return this.myTitleLabel;
    }

    @VisibleForTesting
    JLabel getTitleInfoIcon() {
        return this.myTitleInfoIcon;
    }

    @VisibleForTesting
    CommonDropDownButton getActionsDropdown() {
        return this.myActionsDropdown;
    }

    @VisibleForTesting
    FlatSeparator getSeparator() {
        return this.mySeparator;
    }

    @VisibleForTesting
    CommonButton getCollapseButton() {
        return this.myCollapseButton;
    }

    @VisibleForTesting
    JComponent getTrackTitleOverlay() {
        return this.myTrackTitleOverlay;
    }

    @VisibleForTesting
    JPanel getTagCheckBoxPanel() {
        return this.myTagCheckBoxPanel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JPanel getOverlay() {
        return this.myOverlay;
    }

    private MouseEvent convertTrackListEvent(MouseEvent oldEvent, int trackIndex) {
        Point trackOrigin = this.myTrackList.indexToLocation(trackIndex);
        Point newPoint = oldEvent.getPoint();
        newPoint.translate(0, -trackOrigin.y);
        return SwingUtil.convertMouseEventPoint(oldEvent, newPoint);
    }

    private class TrackContentMouseEventHandler
    extends MouseEventHandler {
        private int myTrackIndex = -1;

        private TrackContentMouseEventHandler() {
        }

        protected void handle(MouseEvent event) {
            if (!TrackGroup.this.myIsEnabled) {
                TrackGroup.this.myComponent.dispatchEvent(event);
                return;
            }
            int oldTrackIndex = this.myTrackIndex;
            this.myTrackIndex = TrackGroup.this.myTrackList.locationToIndex(event.getPoint());
            MouseEvent newEvent = TrackGroup.this.convertTrackListEvent(event, this.myTrackIndex);
            JComponent trackContent = TrackGroup.this.getTrackMap().get(TrackGroup.this.getTrackModelAt(this.myTrackIndex).getId()).getTrackContent();
            trackContent.dispatchEvent(newEvent);
            if (event.getID() == 503) {
                if (this.myTrackIndex != oldTrackIndex && oldTrackIndex >= 0) {
                    TrackGroup.this.myTrackList.repaint(TrackGroup.this.myTrackList.getCellBounds(oldTrackIndex, oldTrackIndex));
                    JComponent oldTrackContent = TrackGroup.this.getTrackMap().get(TrackGroup.this.getTrackModelAt(oldTrackIndex).getId()).getTrackContent();
                    oldTrackContent.dispatchEvent(SwingUtil.convertMouseEventID(newEvent, 505));
                }
            } else if (event.getID() == 505) {
                this.myTrackIndex = -1;
            }
        }
    }

    private class TrackTitleMouseEventHandler
    extends MouseEventHandler {
        private TrackTitleMouseEventHandler() {
        }

        protected void handle(MouseEvent event) {
            int trackIndex = TrackGroup.this.myTrackList.locationToIndex(event.getPoint());
            MouseEvent newEvent = TrackGroup.this.convertTrackListEvent(event, trackIndex);
            JLabel trackTitle = TrackGroup.this.getTrackMap().get(TrackGroup.this.getTrackModelAt(trackIndex).getId()).getTitleLabel();
            trackTitle.dispatchEvent(newEvent);
            TrackGroup.this.myTrackList.dispatchEvent(event);
        }

        public void mousePressed(MouseEvent event) {
            if (TrackGroup.this.myBoxSelectionComponent != null && TrackGroup.this.myBoxSelectionComponent.getModel().isSelectionEnabled()) {
                TrackGroup.this.myBoxSelectionComponent.clearSelection();
            }
            super.mousePressed(event);
        }
    }
}

