/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.trackgroup;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class Track {
    static final int DEFAULT_TITLE_COL_PX = 150;
    public static final String COL_SIZES = "150px,*";
    private static final int SELECTION_BORDER_PX = 2;
    private static final Icon COLLAPSE_ICON = AllIcons.General.ArrowRight;
    private static final Icon EXPAND_ICON = AllIcons.General.ArrowDown;
    static final Icon REORDER_ICON = StudioIcons.Common.REORDER;
    private static final Border TITLE_BORDER_DEFAULT = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)0, (int)1), (Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0), (boolean)false);
    private static final Border TITLE_BORDER_SELECTED = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)0, (int)1), (Border)JBUI.Borders.customLine((Color)StudioColorsKt.getSelectionBackground(), (int)2, (int)2, (int)2, (int)0), (boolean)false);
    private static final Border CONTENT_BORDER_DEFAULT = JBUI.Borders.customLine((Color)UIUtil.TRANSPARENT_COLOR, (int)2, (int)0, (int)2, (int)0);
    private static final Border CONTENT_BORDER_SELECTED = JBUI.Borders.customLine((Color)StudioColorsKt.getSelectionBackground(), (int)2, (int)0, (int)2, (int)0);
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final JPanel myTitleBackPanel;
    @NotNull
    private final JPanel myTitleFrontPanel;
    @NotNull
    private final JLabel myTitleLabel;
    @NotNull
    private final JComponent myTrackContent;

    private Track(final @NotNull TrackModel trackModel, @NotNull JComponent trackContent) {
        this.myTrackContent = trackContent;
        trackContent.setBackground((Color)StudioColorsKt.getTrackBackground());
        this.myTitleLabel = new JLabel(trackModel.getTitle());
        this.myTitleLabel.setVerticalAlignment(1);
        this.myTitleLabel.setToolTipText(trackModel.getTitleTooltip());
        this.myTitleLabel.setIconTextGap(0);
        if (trackModel.isCollapsible()) {
            this.myTitleLabel.setIcon(trackModel.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
            this.myTitleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Rectangle iconRect = new Rectangle(Track.this.myTitleLabel.getInsets().left, Track.this.myTitleLabel.getInsets().top, Track.this.myTitleLabel.getIcon().getIconWidth(), Track.this.myTitleLabel.getIcon().getIconHeight());
                    if (iconRect.contains(e.getPoint()) || e.getClickCount() == 2) {
                        trackModel.setCollapsed(!trackModel.isCollapsed());
                        Track.this.myTitleLabel.setIcon(trackModel.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
                    }
                }
            });
        }
        int leftPadding = this.myTitleLabel.getIcon() != null ? 2 : COLLAPSE_ICON.getIconWidth() + this.myTitleLabel.getIconTextGap() + 2;
        this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)leftPadding, (int)4, (int)0));
        this.myTitleFrontPanel = new JPanel(new BorderLayout());
        if (trackModel.isDragEnabled()) {
            JLabel recorderIconLabel = new JLabel(REORDER_ICON);
            recorderIconLabel.setVerticalAlignment(1);
            recorderIconLabel.setBorder((Border)JBUI.Borders.emptyTop((int)4));
            this.myTitleFrontPanel.add((Component)recorderIconLabel, "West");
        }
        this.myTitleFrontPanel.add((Component)this.myTitleLabel, "Center");
        this.myTitleBackPanel = new JPanel(new BorderLayout());
        this.myTitleBackPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        this.myTitleBackPanel.add(this.myTitleFrontPanel);
        this.myComponent = new JPanel(new TabularLayout(COL_SIZES, "Fit"));
        if (trackModel.getHideHeader()) {
            this.myComponent.add((Component)trackContent, new TabularLayout.Constraint(0, 0, 2));
        } else {
            this.myComponent.add((Component)this.myTitleBackPanel, new TabularLayout.Constraint(0, 0));
            this.myComponent.add((Component)trackContent, new TabularLayout.Constraint(0, 1));
        }
    }

    @NotNull
    public static <M, R extends Enum> Track create(@NotNull TrackModel<M, R> trackModel, @NotNull TrackRenderer<M> trackRenderer) {
        return new Track(trackModel, trackRenderer.render(trackModel));
    }

    @NotNull
    public Track updateUiStates(boolean selected) {
        this.myTitleFrontPanel.setBackground((Color)(selected ? StudioColorsKt.getSelectionOverlayBackground() : null));
        this.myTitleBackPanel.setBorder(selected ? TITLE_BORDER_SELECTED : TITLE_BORDER_DEFAULT);
        this.myTrackContent.setBorder(selected ? CONTENT_BORDER_SELECTED : CONTENT_BORDER_DEFAULT);
        this.myTitleLabel.updateUI();
        this.myTrackContent.updateUI();
        return this;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComponent getTrackContent() {
        return this.myTrackContent;
    }

    @NotNull
    public JLabel getTitleLabel() {
        return this.myTitleLabel;
    }

    @VisibleForTesting
    @NotNull
    JPanel getTitleFrontPanel() {
        return this.myTitleFrontPanel;
    }
}

