/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.menu.CommonMenuUI;
import com.android.tools.adtui.stdui.menu.CommonPopupMenu;
import com.android.tools.adtui.stdui.menu.CommonPopupMenuUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class CommonMenu
extends JMenu
implements PropertyChangeListener {
    private JPopupMenu myPopupMenu;
    private Point myCustomMenuLocation = null;
    private boolean myActionSelected;

    public CommonMenu(CommonAction action) {
        super(action);
        this.myActionSelected = action.isSelected();
        action.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "isSelected": {
                assert (event.getNewValue() instanceof Boolean);
                this.myActionSelected = (Boolean)event.getNewValue();
                this.repaint();
                break;
            }
        }
    }

    public boolean isActionSelected() {
        return this.myActionSelected;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new CommonMenuUI());
        if (this.myPopupMenu != null) {
            this.myPopupMenu.setUI(new CommonPopupMenuUI());
        }
    }

    @Override
    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.myPopupMenu.isVisible();
    }

    @Override
    public void setPopupMenuVisible(boolean b) {
        boolean isVisible = this.isPopupMenuVisible();
        if (b != isVisible && (this.isEnabled() || !b)) {
            this.ensurePopupMenuCreated();
            if (b && this.isShowing()) {
                Point p = this.myCustomMenuLocation;
                if (p == null) {
                    p = this.getPopupMenuOrigin();
                }
                this.getPopupMenu().show(this, p.x, p.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    @Override
    protected Point getPopupMenuOrigin() {
        int y;
        int x;
        Container parent;
        JPopupMenu pm = this.getPopupMenu();
        Dimension s = this.getSize();
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i2 = 0; i2 < gd.length; ++i2) {
            GraphicsConfiguration dgc;
            if (gd[i2].getType() != 0 || !(dgc = gd[i2].getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        if ((parent = this.getParent()) instanceof JPopupMenu) {
            int xOffset = 0;
            int yOffset = 0;
            if (this.getComponentOrientation().isLeftToRight()) {
                x = s.width + xOffset;
                if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                    x = 0 - xOffset - pmSize.width;
                }
            } else {
                x = 0 - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = s.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pmSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                y = s.height - yOffset - pmSize.height;
            }
        } else {
            int xOffset = 0;
            int yOffset = 0;
            if (this.getComponentOrientation().isLeftToRight()) {
                x = xOffset;
                if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                    x = s.width - xOffset - pmSize.width;
                }
            } else {
                x = s.width - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = xOffset;
                }
            }
            if (position.y + (y = s.height + yOffset) + pmSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                y = 0 - yOffset - pmSize.height;
            }
        }
        return new Point(x, y);
    }

    private void ensurePopupMenuCreated() {
        if (this.myPopupMenu == null) {
            this.myPopupMenu = new CommonPopupMenu();
            this.myPopupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.myPopupMenu);
        }
    }

    @Override
    public void setMenuLocation(int x, int y) {
        this.myCustomMenuLocation = new Point(x, y);
        if (this.myPopupMenu != null) {
            this.myPopupMenu.setLocation(x, y);
        }
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.ensurePopupMenuCreated();
        return this.myPopupMenu.add(menuItem);
    }

    @Override
    public Component add(Component c) {
        this.ensurePopupMenuCreated();
        this.myPopupMenu.add(c);
        return c;
    }

    @Override
    public Component add(Component c, int index) {
        this.ensurePopupMenuCreated();
        this.myPopupMenu.add(c, index);
        return c;
    }

    @Override
    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.myPopupMenu.addSeparator();
    }

    @Override
    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.myPopupMenu.insert(new JMenuItem(s), pos);
    }

    @Override
    public JMenuItem insert(JMenuItem mi, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.myPopupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem mi = new JMenuItem(a);
        mi.setHorizontalTextPosition(11);
        mi.setVerticalTextPosition(0);
        this.myPopupMenu.insert(mi, pos);
        return mi;
    }

    @Override
    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.myPopupMenu.insert(new JPopupMenu.Separator(), index);
    }

    @Override
    public void remove(JMenuItem item) {
        if (this.myPopupMenu != null) {
            this.myPopupMenu.remove(item);
        }
    }

    @Override
    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (pos > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.myPopupMenu != null) {
            this.myPopupMenu.remove(pos);
        }
    }

    @Override
    public void remove(Component c) {
        if (this.myPopupMenu != null) {
            this.myPopupMenu.remove(c);
        }
    }

    @Override
    public void removeAll() {
        if (this.myPopupMenu != null) {
            this.myPopupMenu.removeAll();
        }
    }

    @Override
    public int getMenuComponentCount() {
        int componentCount = 0;
        if (this.myPopupMenu != null) {
            componentCount = this.myPopupMenu.getComponentCount();
        }
        return componentCount;
    }

    @Override
    public Component getMenuComponent(int n) {
        if (this.myPopupMenu != null) {
            return this.myPopupMenu.getComponent(n);
        }
        return null;
    }

    @Override
    public Component[] getMenuComponents() {
        if (this.myPopupMenu != null) {
            return this.myPopupMenu.getComponents();
        }
        return new Component[0];
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.myPopupMenu;
    }

    @Override
    public MenuElement[] getSubElements() {
        if (this.myPopupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] result = new MenuElement[]{this.myPopupMenu};
        return result;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        if (this.myPopupMenu != null) {
            int ncomponents = this.getMenuComponentCount();
            for (int i2 = 0; i2 < ncomponents; ++i2) {
                this.getMenuComponent(i2).applyComponentOrientation(o);
            }
            this.myPopupMenu.setComponentOrientation(o);
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        if (this.myPopupMenu != null) {
            this.myPopupMenu.setComponentOrientation(o);
        }
    }
}

