/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.stdui.StandardColors;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBScrollBar;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public final class StreamingScrollbar
extends JBScrollBar {
    private static final float VIEW_ZOOM_PER_MOUSEWHEEL_FACTOR = 0.125f;
    private static final float VIEW_PAN_PERCENTAGE_PER_MOUSEHWEEL_FACTOR = 0.005f;
    private static final long MS_TO_US = TimeUnit.MILLISECONDS.toMicros(1L);
    private static final float STREAMING_POSITION_THRESHOLD_PX = 10.0f;
    @NotNull
    private final StreamingTimeline myTimeline;
    private final AspectObserver myAspectObserver = new AspectObserver();
    private boolean myUpdating;
    private boolean myCheckStream;

    public StreamingScrollbar(@NotNull StreamingTimeline timeline, @NotNull JComponent zoomPanComponent) {
        super(0);
        this.myTimeline = timeline;
        this.myTimeline.getViewRange().addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::modelChanged);
        this.myTimeline.getDataRange().addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::modelChanged);
        StreamingScrollbarUi scrollbarUi = new StreamingScrollbarUi();
        this.setUI((ScrollBarUI)((Object)scrollbarUi));
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("UI") && !(evt.getNewValue() instanceof RangeScrollBarUI)) {
                this.setUI((ScrollBarUI)((Object)scrollbarUi));
            }
        });
        this.addAdjustmentListener(e -> {
            if (!this.myUpdating) {
                this.updateModel();
                if (!e.getValueIsAdjusting()) {
                    this.myCheckStream = true;
                }
            }
        });
        zoomPanComponent.addMouseWheelListener(e -> {
            double count = e.getPreciseWheelRotation();
            boolean isMenuKeyDown = AdtUiUtils.isActionKeyDown(e);
            if (isMenuKeyDown) {
                double anchor = (float)e.getX() / (float)e.getComponent().getWidth();
                this.myTimeline.zoom(this.getZoomWheelDelta() * count, anchor);
            } else if (this.isScrollable()) {
                this.myTimeline.panView(this.getPanWheelDelta() * count);
            }
            this.myCheckStream = count > 0.0;
        });
        this.modelChanged();
    }

    @VisibleForTesting
    public double getZoomWheelDelta() {
        return this.myTimeline.getViewRange().getLength() * 0.125;
    }

    @VisibleForTesting
    public double getPanWheelDelta() {
        return this.myTimeline.getViewRange().getLength() * (double)0.005f;
    }

    private void modelChanged() {
        this.myUpdating = true;
        Range dataRangeUs = this.myTimeline.getDataRange();
        Range viewRangeUs = this.myTimeline.getViewRange();
        int dataExtentMs = (int)(dataRangeUs.getLength() / (double)MS_TO_US);
        int viewExtentMs = Math.min(dataExtentMs, (int)(viewRangeUs.getLength() / (double)MS_TO_US));
        int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)MS_TO_US));
        this.setValues(viewRelativeMinMs, viewExtentMs, 0, dataExtentMs);
        this.setBlockIncrement(viewExtentMs);
        this.myUpdating = false;
    }

    private void updateModel() {
        this.myTimeline.setStreaming(false);
        Range dataRangeUs = this.myTimeline.getDataRange();
        Range viewRangeUs = this.myTimeline.getViewRange();
        int valueMs = this.getValue();
        int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)MS_TO_US));
        double deltaUs = (long)(valueMs - viewRelativeMinMs) * MS_TO_US;
        viewRangeUs.shift(deltaUs);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myCheckStream && !this.myTimeline.isStreaming() && this.isCloseToMax() && this.myTimeline.canStream()) {
            this.myTimeline.setStreaming(true);
        }
        this.myCheckStream = false;
    }

    @VisibleForTesting
    public boolean isScrollable() {
        Range viewRange = this.myTimeline.getViewRange();
        Range dataRange = this.myTimeline.getDataRange();
        return viewRange.getMin() >= dataRange.getMin() && viewRange.getMax() <= dataRange.getMax();
    }

    private boolean isCloseToMax() {
        BoundedRangeModel model2 = this.getModel();
        float snapPercentage = 1.0f - 10.0f / (float)this.getWidth();
        return (float)(model2.getValue() + model2.getExtent()) / (float)model2.getMaximum() >= snapPercentage;
    }

    private class StreamingScrollbarUi
    extends RangeScrollBarUI {
        private StreamingScrollbarUi() {
        }

        protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds) {
            g.setColor(StandardColors.DEFAULT_CONTENT_BACKGROUND_COLOR);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

