/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.adtui.stdui.DefaultLookupUI;
import com.android.tools.adtui.stdui.LookupKt;
import com.android.tools.adtui.stdui.LookupUI;
import com.android.tools.adtui.stdui.Matcher;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.speedSearch.FilteringListModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020!H\u0002J\u0006\u0010%\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\fJ\b\u0010'\u001a\u00020!H\u0002J\u001a\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010+\u001a\u00020!J\u0006\u0010,\u001a\u00020!J\u0006\u0010-\u001a\u00020!J\u0006\u0010.\u001a\u00020!J\u0006\u0010/\u001a\u00020!J\u0006\u00100\u001a\u00020!J\u000e\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u000bJ\b\u00103\u001a\u00020!H\u0002J\b\u00104\u001a\u00020!H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/adtui/stdui/Lookup;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "", "editor", "Lcom/android/tools/adtui/stdui/CommonTextField;", "ui", "Lcom/android/tools/adtui/stdui/LookupUI;", "(Lcom/android/tools/adtui/stdui/CommonTextField;Lcom/android/tools/adtui/stdui/LookupUI;)V", "condition", "Lkotlin/Function1;", "", "", "currentValueIncluded", "dataLoaded", "dataLoading", "getEditor", "()Lcom/android/tools/adtui/stdui/CommonTextField;", "enabled", "getEnabled", "()Z", "filteredModel", "Lcom/intellij/ui/speedSearch/FilteringListModel;", "isVisible", "lastCompletionText", "Ljava/util/concurrent/atomic/AtomicReference;", "listModel", "Ljavax/swing/DefaultListModel;", "lookupCancelled", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "showBelow", "close", "", "computeLocation", "Ljava/awt/Point;", "display", "enter", "escape", "hideLookup", "restoreSelection", "currentValueSelected", "oldSelectedItem", "selectFirst", "selectLast", "selectNext", "selectNextPage", "selectPrevious", "selectPreviousPage", "showLookup", "forText", "updateFilter", "updateFrameBounds", "intellij.android.adt.ui"})
public final class Lookup<M extends CommonTextFieldModel> {
    @NotNull
    private final CommonTextField<M> editor;
    @NotNull
    private final LookupUI ui;
    @NotNull
    private final DefaultListModel<String> listModel;
    @NotNull
    private final FilteringListModel<String> filteredModel;
    @NotNull
    private Matcher matcher;
    @NotNull
    private final Function1<String, Boolean> condition;
    private boolean showBelow;
    private boolean dataLoading;
    private boolean dataLoaded;
    private boolean lookupCancelled;
    @NotNull
    private AtomicReference<String> lastCompletionText;
    private boolean currentValueIncluded;

    public Lookup(@NotNull CommonTextField<? extends M> editor, @NotNull LookupUI ui) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.editor = editor;
        this.ui = ui;
        this.listModel = new DefaultListModel();
        this.filteredModel = new FilteringListModel((ListModel)this.listModel);
        this.matcher = new Matcher();
        this.condition = (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ Lookup<M> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return Lookup.access$getMatcher$p(this.this$0).matches(element);
            }
        };
        this.showBelow = true;
        this.lastCompletionText = new AtomicReference<String>("");
        FilteringListModel<String> filteringListModel = this.filteredModel;
        Intrinsics.checkNotNull(filteringListModel, (String)"null cannot be cast to non-null type javax.swing.ListModel<kotlin.String>");
        this.ui.createList((ListModel)filteringListModel, this.matcher, (JComponent)((Object)this.editor));
        this.ui.setClickAction((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.enter();
            }
        }));
        Function1<String, Boolean> function1 = this.condition;
        this.filteredModel.setFilter(new Condition(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean value(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    public /* synthetic */ Lookup(CommonTextField commonTextField, LookupUI lookupUI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lookupUI = new DefaultLookupUI();
        }
        this(commonTextField, lookupUI);
    }

    @NotNull
    public final CommonTextField<M> getEditor() {
        return this.editor;
    }

    public final boolean isVisible() {
        return this.ui.getVisible();
    }

    public final void showLookup(@NotNull String forText) {
        Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
        EditingSupport support = this.editor.getEditorModel().getEditingSupport();
        if (this.dataLoaded && (!support.getAlwaysRefreshCompletions() || Intrinsics.areEqual((Object)forText, (Object)this.lastCompletionText.get()))) {
            this.updateFilter();
        } else {
            this.lookupCancelled = false;
            this.lastCompletionText.set(forText);
            support.getExecution().invoke((Object)new Runnable(this, support){
                final /* synthetic */ Lookup<M> this$0;
                final /* synthetic */ EditingSupport $support;
                {
                    this.this$0 = $receiver;
                    this.$support = $support;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    if (Lookup.access$getDataLoading$p(this.this$0)) {
                        return;
                    }
                    Lookup.access$setDataLoading$p(this.this$0, true);
                    Ref.ObjectRef values = new Ref.ObjectRef();
                    values.element = CollectionsKt.emptyList();
                    boolean done = false;
                    try {
                        while (!done) {
                            String lastText = (String)Lookup.access$getLastCompletionText$p(this.this$0).get();
                            Function1<String, List<String>> function1 = this.$support.getCompletion();
                            Intrinsics.checkNotNullExpressionValue((Object)lastText, (String)"lastText");
                            values.element = function1.invoke((Object)lastText);
                            done = Intrinsics.areEqual((Object)lastText, Lookup.access$getLastCompletionText$p(this.this$0).get());
                        }
                    }
                    finally {
                        Lookup.access$setDataLoading$p(this.this$0, false);
                    }
                    if (Lookup.access$getLookupCancelled$p(this.this$0)) {
                        return;
                    }
                    Lookup.access$setDataLoaded$p(this.this$0, true);
                    this.$support.getUiExecution().invoke((Object)new Runnable(this.this$0, (Ref.ObjectRef<List<String>>)values, this.$support){
                        final /* synthetic */ Lookup<M> this$0;
                        final /* synthetic */ Ref.ObjectRef<List<String>> $values;
                        final /* synthetic */ EditingSupport $support;
                        {
                            this.this$0 = $receiver;
                            this.$values = $values;
                            this.$support = $support;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            Lookup.access$getListModel$p(this.this$0).clear();
                            Lookup.access$setCurrentValueIncluded$p(this.this$0, false);
                            if (!((Collection)this.$values.element).isEmpty()) {
                                void $this$forEach$iv;
                                String currentValue = this.this$0.getEditor().getText();
                                if (this.$support.getAllowCustomValues()) {
                                    Intrinsics.checkNotNullExpressionValue((Object)currentValue, (String)"currentValue");
                                    if (((CharSequence)currentValue).length() > 0) {
                                        Lookup.access$getListModel$p(this.this$0).addElement(currentValue);
                                        Lookup.access$setCurrentValueIncluded$p(this.this$0, true);
                                    }
                                }
                                Iterable iterable = (Iterable)this.$values.element;
                                Lookup<M> lookup = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl = false;
                                    if (Intrinsics.areEqual((Object)it, (Object)currentValue)) continue;
                                    Lookup.access$getListModel$p(lookup).addElement(it);
                                }
                            }
                            Lookup.access$updateFilter(this.this$0);
                        }
                    });
                }
            });
        }
    }

    private final void updateFilter() {
        boolean isCurrentValueSelected;
        String text = this.editor.getText();
        String oldSelectedValue = this.ui.getSelectedValue();
        boolean bl = isCurrentValueSelected = this.currentValueIncluded && this.ui.getSelectedIndex() == 0;
        if (this.currentValueIncluded && this.listModel.size() > 0) {
            this.listModel.set(0, text);
        }
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        this.matcher.setPattern(text);
        this.filteredModel.refilter();
        int emptyListSize = this.currentValueIncluded ? 1 : 0;
        boolean hasMatchesToShow = this.filteredModel.getSize() > emptyListSize;
        if (hasMatchesToShow && !this.ui.getVisible()) {
            this.display();
        } else if (!hasMatchesToShow && this.ui.getVisible()) {
            this.hideLookup();
        } else if (hasMatchesToShow) {
            this.restoreSelection(isCurrentValueSelected, oldSelectedValue);
            this.updateFrameBounds();
        }
    }

    public final boolean getEnabled() {
        return this.isVisible() && this.filteredModel.getSize() > 0;
    }

    public final void selectFirst() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(0);
        }
    }

    public final void selectLast() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(this.filteredModel.getSize() - 1);
        }
    }

    public final void selectNextPage() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(Math.min(this.ui.getSelectedIndex() + this.ui.getVisibleRowCount(), this.filteredModel.getSize() - 1));
        }
    }

    public final void selectPreviousPage() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(Math.max(this.ui.getSelectedIndex() - this.ui.getVisibleRowCount(), 0));
        }
    }

    public final void selectNext() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(LookupKt.access$modulo(this.ui.getSelectedIndex() + 1, this.filteredModel.getSize()));
        }
    }

    public final void selectPrevious() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(LookupKt.access$modulo(this.ui.getSelectedIndex() - 1, this.filteredModel.getSize()));
        }
    }

    public final boolean enter() {
        if (!this.ui.getVisible()) {
            return false;
        }
        String string = this.ui.getSelectedValue();
        if (string == null) {
            return false;
        }
        String value = string;
        this.editor.setText(value);
        this.hideLookup();
        return true;
    }

    public final boolean escape() {
        if (!this.ui.getVisible()) {
            this.lookupCancelled = true;
            return false;
        }
        this.hideLookup();
        return true;
    }

    public final void close() {
        this.hideLookup();
        this.listModel.clear();
        this.dataLoaded = false;
    }

    private final void restoreSelection(boolean currentValueSelected, String oldSelectedItem) {
        if (oldSelectedItem != null && !currentValueSelected) {
            this.ui.setSelectedValue(oldSelectedItem);
        }
        if (this.ui.getSelectedIndex() < 0 || currentValueSelected) {
            this.ui.setSelectedIndex(0);
        }
    }

    private final void hideLookup() {
        this.lookupCancelled = true;
        this.showBelow = true;
        this.ui.setVisible(false);
        this.ui.setSemiFocused(false);
    }

    private final void display() {
        this.ui.updateLocation(this.computeLocation(), (JComponent)((Object)this.editor));
        this.ui.setVisible(true);
        this.ui.setSelectedIndex(0);
    }

    private final void updateFrameBounds() {
        this.ui.updateLocation(this.computeLocation(), (JComponent)((Object)this.editor));
    }

    private final Point computeLocation() {
        this.ui.setVisibleRowCount(Math.min(this.filteredModel.getSize(), 11));
        Dimension popupSize = this.ui.getPopupSize();
        Rectangle screenBounds = this.ui.screenBounds((JComponent)((Object)this.editor));
        Rectangle editorBounds = this.ui.editorBounds((JComponent)((Object)this.editor));
        int xPos = Math.max(Math.min(editorBounds.x + 4, screenBounds.x + screenBounds.width - popupSize.width), screenBounds.x);
        int yPosAbove = editorBounds.y + 4 - popupSize.height;
        int yPosBelow = editorBounds.y + editorBounds.height - 4;
        this.showBelow = !this.showBelow && yPosAbove > screenBounds.y ? false : (yPosBelow + popupSize.height < screenBounds.y + screenBounds.height ? true : yPosAbove <= screenBounds.y);
        return this.showBelow ? new Point(xPos, yPosBelow) : new Point(xPos, yPosAbove);
    }

    public static final /* synthetic */ boolean access$getDataLoading$p(Lookup $this) {
        return $this.dataLoading;
    }

    public static final /* synthetic */ void access$setDataLoading$p(Lookup $this, boolean bl) {
        $this.dataLoading = bl;
    }

    public static final /* synthetic */ AtomicReference access$getLastCompletionText$p(Lookup $this) {
        return $this.lastCompletionText;
    }

    public static final /* synthetic */ boolean access$getLookupCancelled$p(Lookup $this) {
        return $this.lookupCancelled;
    }

    public static final /* synthetic */ void access$setDataLoaded$p(Lookup $this, boolean bl) {
        $this.dataLoaded = bl;
    }

    public static final /* synthetic */ DefaultListModel access$getListModel$p(Lookup $this) {
        return $this.listModel;
    }

    public static final /* synthetic */ void access$setCurrentValueIncluded$p(Lookup $this, boolean bl) {
        $this.currentValueIncluded = bl;
    }

    public static final /* synthetic */ void access$updateFilter(Lookup $this) {
        $this.updateFilter();
    }

    public static final /* synthetic */ Matcher access$getMatcher$p(Lookup $this) {
        return $this.matcher;
    }
}

