/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.stdui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonAction
extends AbstractAction {
    public static final String CHILDREN_ACTION_CHANGED = "childrenActions";
    public static final String SHOW_EXPAND_ARROW_CHANGED = "showExpandArrow";
    public static final String SELECTED_CHANGED = "isSelected";
    @NotNull
    private final List<CommonAction> myChildrenActions;
    @Nullable
    private Runnable myAction;
    private boolean myShowExpandArrow;
    private boolean myIsSelected;

    public CommonAction(@NotNull String text, @Nullable Icon icon) {
        this(text, icon, null);
    }

    public CommonAction(@NotNull String text, @Nullable Icon icon, @Nullable Runnable action) {
        super(text, icon);
        this.myAction = action;
        this.myChildrenActions = new ArrayList<CommonAction>();
    }

    @NotNull
    public String getText() {
        return (String)this.getValue("Name");
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        if (this.myAction != null) {
            this.myAction.run();
        }
    }

    public int getChildrenActionCount() {
        return this.myChildrenActions.size();
    }

    @NotNull
    public List<CommonAction> getChildrenActions() {
        return this.myChildrenActions;
    }

    public void setAction(@NotNull Runnable action) {
        this.myAction = action;
    }

    public void setSelected(boolean value) {
        if (value == this.myIsSelected) {
            return;
        }
        this.myIsSelected = value;
        this.firePropertyChange(SELECTED_CHANGED, !this.myIsSelected, this.myIsSelected);
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public void setShowExpandArrow(boolean value) {
        if (value == this.myShowExpandArrow) {
            return;
        }
        this.myShowExpandArrow = value;
        this.firePropertyChange(SHOW_EXPAND_ARROW_CHANGED, !this.myShowExpandArrow, this.myShowExpandArrow);
    }

    public boolean getShowExpandArrow() {
        return this.myShowExpandArrow;
    }

    public void addChildrenActions(CommonAction ... actions2) {
        this.addChildrenActions(Arrays.asList(actions2));
    }

    public void addChildrenActions(@NotNull List<CommonAction> actions2) {
        ArrayList<CommonAction> oldActions = new ArrayList<CommonAction>(this.myChildrenActions);
        this.myChildrenActions.addAll(actions2);
        this.firePropertyChange(CHILDREN_ACTION_CHANGED, oldActions, this.myChildrenActions);
    }

    public void clear() {
        ArrayList<CommonAction> oldActions = new ArrayList<CommonAction>(this.myChildrenActions);
        this.myChildrenActions.clear();
        this.firePropertyChange(CHILDREN_ACTION_CHANGED, oldActions, this.myChildrenActions);
    }

    public static class SeparatorAction
    extends CommonAction {
        public SeparatorAction() {
            super("separator", null);
        }
    }
}

