/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class NumberFormatter {
    private static final Format INTEGER_FORMAT = NumberFormat.getIntegerInstance();
    private static final String[] FILE_SIZE_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final int FILE_SIZE_MULTIPLIER = 1024;
    private static final String[] FREQUENCY_UNITS = new String[]{"kHz", "MHz", "GHz"};
    private static final int FREQUENCY_MULTIPLIER = 1000;

    @NotNull
    public static String formatInteger(@NotNull Number number) {
        return INTEGER_FORMAT.format(number);
    }

    @NotNull
    public static String formatFileSize(long sizeInBytes) {
        return NumberFormatter.formatNumberWithUnit(sizeInBytes, 1024, FILE_SIZE_UNITS);
    }

    @NotNull
    public static String formatFrequency(long frequencyInKhz) {
        return NumberFormatter.formatNumberWithUnit(frequencyInKhz, 1000, FREQUENCY_UNITS);
    }

    private static String formatNumberWithUnit(long number, int multiplier, String[] units) {
        double result = number;
        String unit = units[0];
        for (int i2 = 1; i2 < units.length && !(result < (double)multiplier); result /= (double)multiplier, ++i2) {
            unit = units[i2];
        }
        String decimalFormat = result < 100.0 ? "%.1f" : "%.0f";
        return String.format(Locale.US, decimalFormat + " %s", result, unit);
    }
}

