/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.axis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.google.common.primitives.Doubles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResizingAxisComponentModel
extends AxisComponentModel {
    @Nullable
    private Range myGlobalRange;
    double myGlobalRangeMin;

    private ResizingAxisComponentModel(@NotNull AxisComponentModel.BaseBuilder<ResizingAxisComponentModel> builder) {
        super(builder);
        this.myGlobalRange = builder.myGlobalRange;
        if (this.myGlobalRange != null) {
            this.myGlobalRange.addDependency(this).onChange(Range.Aspect.RANGE, this::onGlobalRangeUpdated);
            this.myGlobalRangeMin = this.myGlobalRange.getMin();
        }
        this.updateImmediately();
    }

    private void onGlobalRangeUpdated() {
        assert (this.myGlobalRange != null);
        if (Doubles.compare((double)this.myGlobalRangeMin, (double)this.myGlobalRange.getMin()) != 0) {
            this.myGlobalRangeMin = this.myGlobalRange.getMin();
            this.updateImmediately();
        }
    }

    @Override
    public void updateImmediately() {
        this.myFirstUpdate = false;
        this.changed(AxisComponentModel.Aspect.AXIS);
    }

    @Override
    public double getZero() {
        return this.myGlobalRange != null ? this.myGlobalRange.getMin() : this.myRange.getMin();
    }

    @Override
    public double getDataRange() {
        return this.myGlobalRange == null ? super.getDataRange() : this.myGlobalRange.getLength();
    }

    public static class Builder
    extends AxisComponentModel.BaseBuilder<ResizingAxisComponentModel> {
        public Builder(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
            super(range, formatter);
        }

        @NotNull
        public Builder setGlobalRange(@NotNull Range globalRange) {
            this.myGlobalRange = globalRange;
            return this;
        }

        @Override
        @NotNull
        public ResizingAxisComponentModel build() {
            return new ResizingAxisComponentModel(this);
        }
    }
}

