/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import org.jetbrains.annotations.NotNull;

public class DefaultTimeline
implements Timeline {
    private static final double DEFAULT_ZOOM_RATIO = 0.75;
    private final Range myDataRange = new Range();
    private final Range myViewRange = new Range();
    private final Range myTooltipRange = new Range();
    private final Range mySelectionRange = new Range();
    private double myZoomRatio = 0.75;

    @Override
    @NotNull
    public Range getDataRange() {
        return this.myDataRange;
    }

    @Override
    @NotNull
    public Range getViewRange() {
        return this.myViewRange;
    }

    @Override
    @NotNull
    public Range getTooltipRange() {
        return this.myTooltipRange;
    }

    @Override
    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRange;
    }

    public void setZoomRatio(double zoomRatio) {
        this.myZoomRatio = zoomRatio;
    }

    @Override
    public void zoomIn() {
        double newMax;
        double max;
        double min = this.myViewRange.getMin();
        double mid = min + ((max = this.myViewRange.getMax()) - min) / 2.0;
        double newMin = mid - (mid - min) * this.myZoomRatio;
        if (newMin < (newMax = mid + (max - mid) * this.myZoomRatio)) {
            this.myViewRange.set(newMin, newMax);
        }
    }

    @Override
    public void zoomOut() {
        double min = this.myViewRange.getMin();
        double max = this.myViewRange.getMax();
        double mid = min + (max - min) / 2.0;
        double newMin = mid - (mid - min) / this.myZoomRatio;
        double newMax = mid + (max - mid) / this.myZoomRatio;
        this.myViewRange.set(new Range(newMin, newMax).getIntersection(this.myDataRange));
    }

    @Override
    public void resetZoom() {
        this.myViewRange.set(this.myDataRange);
    }

    @Override
    public void frameViewToRange(@NotNull Range targetRange) {
        this.myViewRange.set(targetRange.getIntersection(this.myDataRange));
    }
}

