/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.ninepatch.NinePatch;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.PathManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceArtPainter {
    @NotNull
    private static final DeviceArtPainter ourInstance = new DeviceArtPainter();
    @Nullable
    private static volatile String ourSystemPath;
    @NotNull
    private Map<Device, DeviceData> myDeviceData = Maps.newHashMap();
    @Nullable
    private List<DeviceArtDescriptor> myDescriptors;

    private DeviceArtPainter() {
    }

    @NotNull
    public static DeviceArtPainter getInstance() {
        return ourInstance;
    }

    public boolean hasDeviceFrame(@Nullable Device device) {
        DeviceData deviceData = this.getDeviceData(device);
        if (deviceData == null) {
            return false;
        }
        return !deviceData.getDescriptor().isStretchable();
    }

    @Nullable
    private DeviceData getDeviceData(@Nullable Device device) {
        if (device == null) {
            return null;
        }
        DeviceData data = this.myDeviceData.get(device);
        if (data == null) {
            DeviceArtDescriptor spec = this.findDescriptor(device);
            data = new DeviceData(device, spec);
            this.myDeviceData.put(device, data);
        }
        return data;
    }

    @NotNull
    private DeviceArtDescriptor findDescriptor(@NotNull Device device) {
        String id = device.getId();
        String name = device.getDisplayName();
        DeviceArtDescriptor descriptor = this.findDescriptor(id = id.equals("3.7in WVGA (Nexus One)") ? "nexus_one" : (id.equals("4in WVGA (Nexus S)") ? "nexus_s" : (id.equals("4.65in 720p (Galaxy Nexus)") ? "galaxy_nexus" : id.replace(' ', '_'))), name);
        if (descriptor == null) {
            boolean isTablet = DeviceArtPainter.isTablet(device);
            descriptor = this.findDescriptor(isTablet ? "tablet" : "phone", null);
            assert (descriptor != null);
        }
        return descriptor;
    }

    public static boolean isTablet(@NotNull Device device) {
        boolean isTablet = false;
        if (device.getId().contains("Tablet")) {
            isTablet = true;
        } else {
            Screen screen = device.getDefaultHardware().getScreen();
            if (screen != null && screen.getDiagonalLength() >= 7.0 && !device.getDefaultHardware().getScreen().isFoldable()) {
                isTablet = true;
            }
        }
        return isTablet;
    }

    @Nullable
    private DeviceArtDescriptor findDescriptor(@NotNull String id, @Nullable String name) {
        for (DeviceArtDescriptor descriptor : this.getDescriptors()) {
            if (!id.equalsIgnoreCase(descriptor.getId()) && (name == null || !name.equalsIgnoreCase(descriptor.getName()))) continue;
            return descriptor;
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    List<DeviceArtDescriptor> getDescriptors() {
        if (this.myDescriptors == null) {
            this.myDescriptors = DeviceArtDescriptor.getDescriptors(null);
        }
        return this.myDescriptors;
    }

    public void paintFrame(@NotNull Graphics g, @NotNull Device device, @NotNull ScreenOrientation orientation, boolean showEffects, int x1, int y1, int height) {
        DeviceData data = this.getDeviceData(device);
        if (data == null || height == 0) {
            return;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        BufferedImage image = frame.getImage(showEffects);
        if (image != null) {
            double scale = (double)height / (double)frame.getScreenHeight();
            int dx1 = (int)((double)x1 - scale * (double)frame.getScreenX());
            int dy1 = (int)((double)y1 - scale * (double)frame.getScreenY());
            int dx2 = dx1 + (int)(scale * (double)image.getWidth());
            int dy2 = dy1 + (int)(scale * (double)image.getHeight());
            g.drawImage(image, dx1, dy1, dx2, dy2, 0, 0, image.getWidth(), image.getHeight(), null);
        }
    }

    @NotNull
    public static BufferedImage createFrame(@NotNull BufferedImage image, @NotNull DeviceArtDescriptor descriptor) {
        return DeviceArtPainter.createFrame(image, descriptor, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static BufferedImage createFrame(@NotNull BufferedImage image, @NotNull DeviceArtDescriptor descriptor, boolean addShadow, boolean addReflection) {
        ScreenOrientation orientation;
        double imgAspectRatio = (double)image.getWidth() / (double)image.getHeight();
        ScreenOrientation screenOrientation = orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        if (!descriptor.canFrameImage(image, orientation)) {
            return image;
        }
        File shadow = descriptor.getDropShadow(orientation);
        File background = descriptor.getFrame(orientation);
        File reflection = descriptor.getReflectionOverlay(orientation);
        Graphics g2d = null;
        try {
            File maskFile;
            double scale;
            BufferedImage bg = ImageIO.read(background);
            Dimension screen = descriptor.getScreenSize(orientation);
            Dimension frameSize = descriptor.getFrameSize(orientation);
            Point screenPos = descriptor.getScreenPos(orientation);
            boolean stretchable = descriptor.isStretchable();
            if (stretchable) {
                assert (screen != null);
                assert (frameSize != null);
                int newWidth = image.getWidth() + frameSize.width - screen.width;
                int newHeight = image.getHeight() + frameSize.height - screen.height;
                bg = DeviceArtPainter.stretchImage(bg, newWidth, newHeight);
            } else if (screen.width < image.getWidth() && Math.abs((scale = (double)screen.width / (double)image.getWidth()) - 1.0) > 1.0E-5) {
                image = ImageUtils.scale(image, scale, scale);
            }
            g2d = bg.createGraphics();
            if (addShadow && shadow != null) {
                BufferedImage shadowImage = ImageIO.read(shadow);
                if (stretchable) {
                    shadowImage = DeviceArtPainter.stretchImage(shadowImage, bg.getWidth(), bg.getHeight());
                }
                g2d.drawImage(shadowImage, 0, 0, null, null);
            }
            if ((maskFile = descriptor.getMask(orientation)) != null) {
                BufferedImage mask = ImageIO.read(maskFile);
                Graphics2D maskG2d = mask.createGraphics();
                maskG2d.setComposite(AlphaComposite.getInstance(5));
                maskG2d.drawImage((Image)image, screenPos.x, screenPos.y, null);
                maskG2d.dispose();
                g2d.drawImage(mask, 0, 0, null);
            } else {
                g2d.drawImage(image, screenPos.x, screenPos.y, null);
            }
            if (addReflection && reflection != null) {
                BufferedImage reflectionImage = ImageIO.read(reflection);
                if (stretchable) {
                    reflectionImage = DeviceArtPainter.stretchImage(reflectionImage, bg.getWidth(), bg.getHeight());
                }
                g2d.drawImage(reflectionImage, 0, 0, null, null);
            }
            BufferedImage bufferedImage = bg;
            return bufferedImage;
        }
        catch (IOException e) {
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
    }

    @Nullable
    private static Shape getClip(@Nullable Device device, int x, int y, int width, int height) {
        boolean round;
        boolean bl = round = device != null && device.isScreenRound();
        if (round) {
            int slop = 3;
            return new Ellipse2D.Double(x - slop, y - slop, width + 2 * slop, height + 2 * slop);
        }
        return null;
    }

    public static void paintClipped(@NotNull Graphics2D g, @NotNull BufferedImage image, @Nullable Device device, int x, int y, boolean withRetina) {
        Shape prevClip = null;
        Shape clip = DeviceArtPainter.getClip(device, x, y, image.getWidth(), image.getHeight());
        if (clip != null) {
            prevClip = g.getClip();
            g.setClip(clip);
        }
        if (withRetina) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)y, null);
        } else {
            g.drawImage((Image)image, x, y, null);
        }
        if (clip != null) {
            g.setClip(prevClip);
        }
    }

    @NotNull
    public BufferedImage createFrame(@NotNull BufferedImage image, @NotNull Device device, @NotNull ScreenOrientation orientation, boolean showEffects, double scale, @Nullable Rectangle outViewRectangle) {
        BufferedImage scaledImage = ImageUtils.scale(image, scale, scale, 0, 0);
        DeviceData data = this.getDeviceData(device);
        int scaledHeight = (int)(scale * (double)image.getHeight());
        if (data == null || scaledHeight == 0) {
            return scaledImage;
        }
        scale = (double)(scaledHeight - 1) / (double)image.getHeight();
        int scaledWidth = (int)((double)image.getWidth() * scale);
        boolean portrait = orientation != ScreenOrientation.LANDSCAPE;
        FrameData frame = portrait ? data.getPortraitData(scaledHeight) : data.getLandscapeData(scaledHeight);
        BufferedImage frameImage = frame.getImage(showEffects);
        if (frameImage != null) {
            int framedWidth = (int)((double)image.getWidth() * scale * (double)frame.getFrameWidth() / (double)frame.getScreenWidth());
            int framedHeight = (int)((double)image.getHeight() * scale * (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
            if (framedWidth <= 0 || framedHeight <= 0) {
                return scaledImage;
            }
            double downScale = (double)framedHeight / (double)frame.getFrameHeight();
            int screenX = (int)(downScale * (double)frame.getScreenX());
            int screenY = (int)(downScale * (double)frame.getScreenY());
            BufferedImage result = new BufferedImage(framedWidth, framedHeight, 2);
            Graphics2D g = result.createGraphics();
            g.setColor(Gray.TRANSPARENT);
            g.fillRect(0, 0, result.getWidth(), result.getHeight());
            DeviceArtPainter.paintClipped(g, scaledImage, device, screenX, screenY, false);
            BufferedImage scaledFrameImage = ImageUtils.scale(frameImage, downScale, downScale, 0, 0);
            g.drawImage((Image)scaledFrameImage, 0, 0, null);
            g.dispose();
            if (outViewRectangle != null) {
                outViewRectangle.x = screenX;
                outViewRectangle.y = screenY;
                outViewRectangle.width = scaledWidth;
                outViewRectangle.height = scaledHeight;
            }
            return result;
        }
        return scaledImage;
    }

    @Nullable
    public Rectangle computeBounds(int imageWidth, int imageHeight, @NotNull Device device, @NotNull ScreenOrientation orientation, double scale) {
        DeviceData data = this.getDeviceData(device);
        int scaledHeight = (int)(scale * (double)imageHeight);
        if (data == null || scaledHeight == 0) {
            return null;
        }
        scale = (double)(scaledHeight - 1) / (double)imageHeight;
        int scaledWidth = (int)((double)imageWidth * scale);
        boolean portrait = orientation != ScreenOrientation.LANDSCAPE;
        FrameData frame = portrait ? data.getPortraitData(scaledHeight) : data.getLandscapeData(scaledHeight);
        int framedWidth = (int)((double)imageWidth * scale * (double)frame.getFrameWidth() / (double)frame.getScreenWidth());
        int framedHeight = (int)((double)imageHeight * scale * (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
        if (framedWidth <= 0 || framedHeight <= 0) {
            return null;
        }
        double downScale = (double)framedHeight / (double)frame.getFrameHeight();
        int screenX = (int)(downScale * (double)frame.getScreenX());
        int screenY = (int)(downScale * (double)frame.getScreenY());
        return new Rectangle(screenX, screenY, scaledWidth, scaledHeight);
    }

    @NotNull
    private static BufferedImage stretchImage(BufferedImage image, int width, int height) {
        BufferedImage composite = new BufferedImage(width, height, 2);
        Graphics2D g = composite.createGraphics();
        g.setColor(Gray.TRANSPARENT);
        g.fillRect(0, 0, composite.getWidth(), composite.getHeight());
        NinePatch ninePatch = NinePatch.load((BufferedImage)image, (boolean)true, (boolean)false);
        assert (ninePatch != null);
        ninePatch.draw(g, 0, 0, width, height);
        g.dispose();
        return composite;
    }

    @Nullable
    public Point getScreenPosition(@NotNull Device device, @NotNull ScreenOrientation orientation, int screenHeight) {
        DeviceData data = this.getDeviceData(device);
        if (data == null) {
            return null;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        int screenX = frame.getScreenX();
        int screenY = frame.getScreenY();
        double scale = (double)screenHeight / (double)frame.getScreenHeight();
        screenX = (int)((double)screenX * scale);
        screenY = (int)((double)screenY * scale);
        return new Point(screenX, screenY);
    }

    public double getFrameMaxOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data = this.getDeviceData(device);
        if (data == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return Math.max((double)frame.getFrameWidth() / (double)frame.getScreenWidth(), (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
    }

    public double getFrameWidthOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data = this.getDeviceData(device);
        if (data == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return (double)frame.getFrameHeight() / (double)frame.getScreenHeight();
    }

    public double getFrameHeightOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data = this.getDeviceData(device);
        if (data == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return (double)frame.getFrameWidth() / (double)frame.getScreenWidth();
    }

    @VisibleForTesting
    static class DeviceData {
        @NotNull
        private final DeviceArtDescriptor myDescriptor;
        private final Device myDevice;
        @Nullable
        private FrameData myPortraitData;
        @Nullable
        private FrameData myLandscapeData;
        @Nullable
        private FrameData mySmallPortraitData;
        @Nullable
        private FrameData mySmallLandscapeData;

        @VisibleForTesting
        DeviceData(Device device, @NotNull DeviceArtDescriptor descriptor) {
            this.myDevice = device;
            this.myDescriptor = descriptor;
        }

        @NotNull
        private FrameData getSmallFrameData(@NotNull FrameData large) {
            return new FrameData(this, large);
        }

        @NotNull
        public FrameData getFrameData(@NotNull ScreenOrientation orientation, int height) {
            return orientation == ScreenOrientation.PORTRAIT ? this.getPortraitData(height) : this.getLandscapeData(height);
        }

        @NotNull
        private FrameData getPortraitData(int height) {
            if (this.myPortraitData == null) {
                this.myPortraitData = new FrameData(this, ScreenOrientation.PORTRAIT);
            }
            if (height < this.myPortraitData.getScreenHeight() / 2) {
                if (this.mySmallPortraitData == null) {
                    this.mySmallPortraitData = this.getSmallFrameData(this.myPortraitData);
                }
                return this.mySmallPortraitData;
            }
            return this.myPortraitData;
        }

        @NotNull
        private FrameData getLandscapeData(int height) {
            if (this.myLandscapeData == null) {
                this.myLandscapeData = new FrameData(this, ScreenOrientation.LANDSCAPE);
            }
            if (height < this.myLandscapeData.getScreenHeight() / 2) {
                if (this.mySmallLandscapeData == null) {
                    this.mySmallLandscapeData = this.getSmallFrameData(this.myLandscapeData);
                }
                return this.mySmallLandscapeData;
            }
            return this.myLandscapeData;
        }

        @NotNull
        DeviceArtDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        public Device getDevice() {
            return this.myDevice;
        }
    }

    @VisibleForTesting
    static class FrameData {
        @NotNull
        private final DeviceData myDeviceData;
        @NotNull
        private final ScreenOrientation myOrientation;
        private final int myX;
        private final int myY;
        private final int myWidth;
        private final int myHeight;
        private final int myCropX1;
        private final int myCropY1;
        private final int myCropX2;
        private final int myCropY2;
        private int myFrameWidth;
        private int myFrameHeight;
        private final FrameData myDouble;
        @NotNull
        private SoftReference<BufferedImage> myPlainImage = new SoftReference(null);
        @NotNull
        private SoftReference<BufferedImage> myEffectsImage = new SoftReference(null);

        private boolean isPortrait() {
            return this.myOrientation == ScreenOrientation.PORTRAIT;
        }

        private FrameData(@NotNull DeviceData deviceData, @NotNull ScreenOrientation orientation) {
            this.myDeviceData = deviceData;
            this.myOrientation = orientation;
            this.myDouble = null;
            DeviceArtDescriptor descriptor = deviceData.getDescriptor();
            if (!this.isStretchable()) {
                Dimension fullSize = descriptor.getFrameSize(this.myOrientation);
                int frameWidth = fullSize.width;
                int frameHeight = fullSize.height;
                Rectangle crop = descriptor.getCrop(this.myOrientation);
                if (crop != null) {
                    this.myCropX1 = crop.x;
                    this.myCropY1 = crop.y;
                    this.myCropX2 = crop.x + crop.width;
                    this.myCropY2 = crop.y + crop.height;
                    frameWidth = crop.width;
                    frameHeight = crop.height;
                } else {
                    this.myCropX1 = 0;
                    this.myCropY1 = 0;
                    this.myCropX2 = frameWidth;
                    this.myCropY2 = frameHeight;
                }
                this.myFrameWidth = frameWidth;
                this.myFrameHeight = frameHeight;
                Point screenPos = descriptor.getScreenPos(this.myOrientation);
                this.myX = screenPos.x - this.myCropX1;
                this.myY = screenPos.y - this.myCropY1;
                Dimension screenSize = descriptor.getScreenSize(this.myOrientation);
                this.myWidth = screenSize.width;
                this.myHeight = screenSize.height;
            } else {
                Device device = this.myDeviceData.getDevice();
                Dimension screenSize = device.getScreenSize(this.myOrientation);
                Dimension screen = descriptor.getScreenSize(this.myOrientation);
                Dimension frameSize = descriptor.getFrameSize(this.myOrientation);
                Point screenPos = descriptor.getScreenPos(this.myOrientation);
                assert (screenSize != null);
                assert (screen != null);
                assert (frameSize != null);
                this.myX = screenPos.x;
                this.myY = screenPos.y;
                this.myWidth = screenSize.width;
                this.myHeight = screenSize.height;
                this.myFrameWidth = this.myWidth + frameSize.width - screen.width;
                this.myFrameHeight = this.myHeight + frameSize.height - screen.height;
                this.myCropX1 = 0;
                this.myCropY1 = 0;
                this.myCropX2 = this.myFrameWidth;
                this.myCropY2 = this.myFrameHeight;
            }
        }

        private FrameData(@NotNull DeviceData deviceData, @NotNull FrameData large) {
            this.myDeviceData = deviceData;
            this.myDouble = large;
            this.myOrientation = large.myOrientation;
            this.myX = large.myX / 2;
            this.myY = large.myY / 2;
            this.myWidth = large.myWidth / 2;
            this.myHeight = large.myHeight / 2;
            this.myFrameWidth = large.myFrameWidth / 2;
            this.myFrameHeight = large.myFrameHeight / 2;
            this.myCropX1 = 0;
            this.myCropY1 = 0;
            this.myCropX2 = this.myFrameWidth;
            this.myCropY2 = this.myFrameHeight;
        }

        public int getScreenX() {
            return this.myX;
        }

        public int getScreenY() {
            return this.myY;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }

        public int getFrameWidth() {
            return this.myFrameWidth;
        }

        public int getFrameHeight() {
            return this.myFrameHeight;
        }

        @Nullable
        private BufferedImage getImage(@Nullable File file) {
            if (file == null) {
                return null;
            }
            assert (this.myDouble == null);
            if (file.exists()) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static File getThumbnailCacheDir() {
            String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath((String)PathManager.getSystemPath()));
            return new File(path, "android-devices" + File.separator + "v4");
        }

        @NotNull
        private File getCacheFile(boolean showEffects) {
            StringBuilder sb = new StringBuilder(20);
            DeviceArtDescriptor descriptor = this.myDeviceData.getDescriptor();
            sb.append(descriptor.getId());
            if (this.isStretchable()) {
                sb.append('-');
                sb.append(Integer.toString(this.myWidth));
                sb.append('x');
                sb.append(Integer.toString(this.myHeight));
            }
            sb.append('-');
            sb.append(this.isPortrait() ? "port" : "land");
            if (this.myDouble != null) {
                sb.append("-thumb");
            }
            if (showEffects) {
                sb.append("-effects");
            }
            sb.append(".png");
            return new File(FrameData.getThumbnailCacheDir(), sb.toString());
        }

        private boolean isStretchable() {
            DeviceArtDescriptor descriptor = this.myDeviceData.getDescriptor();
            return descriptor.isStretchable();
        }

        @Nullable
        private BufferedImage getCachedImage(boolean showEffects) {
            File file = this.getCacheFile(showEffects);
            if (file.exists()) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        private void putCachedImage(boolean showEffects, @NotNull BufferedImage image) {
            block4: {
                boolean deleted;
                boolean ok;
                File dir = FrameData.getThumbnailCacheDir();
                if (!dir.exists() && !(ok = dir.mkdirs())) {
                    return;
                }
                File file = this.getCacheFile(showEffects);
                if (file.exists() && !(deleted = file.delete())) {
                    return;
                }
                try {
                    ImageIO.write((RenderedImage)image, "PNG", file);
                }
                catch (IOException e) {
                    if (!file.exists()) break block4;
                    file.delete();
                }
            }
        }

        @Nullable
        public BufferedImage getImage(boolean showEffects) {
            BufferedImage image;
            BufferedImage bufferedImage = image = showEffects ? (BufferedImage)this.myEffectsImage.get() : (BufferedImage)this.myPlainImage.get();
            if (image != null) {
                return image;
            }
            image = this.getCachedImage(showEffects);
            if (image == null && (image = this.computeImage(showEffects, this.myCropX1, this.myCropY1, this.myCropX2, this.myCropY2)) != null) {
                this.putCachedImage(showEffects, image);
            }
            if (image != null) {
                if (showEffects) {
                    this.myEffectsImage = new SoftReference((Object)image);
                } else {
                    this.myPlainImage = new SoftReference((Object)image);
                }
            }
            return image;
        }

        @VisibleForTesting
        @Nullable
        BufferedImage computeImage(boolean showEffects, int cropX1, int cropY1, int cropX2, int cropY2) {
            BufferedImage glare;
            DeviceArtDescriptor descriptor;
            BufferedImage background;
            if (this.myDouble != null) {
                BufferedImage source = this.myDouble.getImage(showEffects);
                if (source != null) {
                    int sourceWidth = source.getWidth();
                    int sourceHeight = source.getHeight();
                    int destWidth = sourceWidth / 2;
                    int destHeight = sourceHeight / 2;
                    BufferedImage dest = new BufferedImage(destWidth, destHeight, 2);
                    Graphics2D g = dest.createGraphics();
                    g.setComposite(AlphaComposite.Src);
                    g.setColor(new Color(0, true));
                    g.fillRect(0, 0, destWidth, destHeight);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
                    g.dispose();
                    return dest;
                }
                assert (false);
            }
            if ((background = this.getImage((descriptor = this.myDeviceData.getDescriptor()).getFrame(this.myOrientation))) == null) {
                return null;
            }
            boolean stretchable = this.isStretchable();
            if (stretchable) {
                background = DeviceArtPainter.stretchImage(background, this.myFrameWidth, this.myFrameHeight);
            }
            BufferedImage composite = new BufferedImage(this.myFrameWidth, this.myFrameHeight, 2);
            Graphics2D g = composite.createGraphics();
            g.setColor(Gray.TRANSPARENT);
            g.fillRect(0, 0, composite.getWidth(), composite.getHeight());
            Graphics2D g2d = g;
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            BufferedImage mask = this.getImage(descriptor.getMask(this.myOrientation));
            if (showEffects) {
                BufferedImage shadow = this.getImage(descriptor.getDropShadow(this.myOrientation));
                if (shadow != null) {
                    if (stretchable) {
                        shadow = DeviceArtPainter.stretchImage(shadow, this.myFrameWidth, this.myFrameHeight);
                    }
                    g.drawImage(shadow, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
                }
                g.setColor(new Color(0, true));
                Composite prevComposite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(2, 1.0f));
                if (mask != null) {
                    g2d.setComposite(AlphaComposite.DstOut);
                    g2d.drawImage((Image)mask, -cropX1, -cropY1, null);
                } else {
                    g2d.fillRect(this.myX, this.myY, this.myWidth, this.myHeight);
                }
                g2d.setComposite(prevComposite);
            }
            if (mask != null) {
                BufferedImage maskedImage = new BufferedImage(background.getWidth(), background.getHeight(), 2);
                Graphics2D maskGraphics = maskedImage.createGraphics();
                maskGraphics.drawImage((Image)background, 0, 0, null);
                Composite prevComposite = g2d.getComposite();
                maskGraphics.setComposite(AlphaComposite.DstOut);
                maskGraphics.drawImage((Image)mask, 0, 0, null);
                maskGraphics.dispose();
                g2d.setComposite(prevComposite);
                g.drawImage(maskedImage, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
            } else {
                int dax = 0;
                int day = 0;
                int dcy = this.myY;
                int dex = this.myX + this.myWidth;
                int dfx = this.myFrameWidth;
                int dgy = this.myY + this.myHeight;
                int dhx = this.myX;
                int dly = this.myFrameHeight;
                int ax = cropX1;
                int ay = cropY1;
                int cy = cropY1 + this.myY;
                int ex = cropX1 + this.myX + this.myWidth;
                int fx = cropX2;
                int gy = cropY1 + this.myY + this.myHeight;
                int hx = cropX1 + this.myX;
                int ly = cropY2;
                g.drawImage(background, dax, day, dfx, dcy, ax, ay, fx, cy, null);
                g.drawImage(background, dax, dgy, dfx, dly, ax, gy, fx, ly, null);
                g.drawImage(background, dax, dcy, dhx, dgy, ax, cy, hx, gy, null);
                g.drawImage(background, dex, dcy, dfx, dgy, ex, cy, fx, gy, null);
            }
            if (showEffects && (glare = this.getImage(descriptor.getReflectionOverlay(this.myOrientation))) != null) {
                if (stretchable) {
                    glare = DeviceArtPainter.stretchImage(glare, this.myFrameWidth, this.myFrameHeight);
                }
                g.drawImage(glare, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
            }
            g.dispose();
            return composite;
        }
    }
}

