/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.linechart.DefaultLineChartReducer;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineChartReducer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.NotNull;

public class LineChart
extends AnimatedComponent {
    static final float EPSILON = 1.0E-4f;
    private static final double BUCKET_BAR_PERCENTAGE = 0.7;
    public static final DoubleSupplier ALWAYS_0 = () -> 0.0;
    public static final DoubleSupplier ALWAYS_1 = () -> 1.0;
    @NotNull
    final LineChartModel myModel;
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myLinesConfig = new LinkedHashMap<RangedContinuousSeries, LineConfig>();
    @NotNull
    private final ArrayList<Path2D> myLinePaths;
    @NotNull
    private final ArrayList<RangedContinuousSeries> myLinePathSeries;
    @NotNull
    private final List<LineChartCustomRenderer> myCustomRenderers = new ArrayList<LineChartCustomRenderer>();
    @NotNull
    private Color myMaxLineColor = Color.BLACK;
    private int myMaxLineMargin;
    private boolean myShowMaxLine;
    private int myXOffset = 0;
    private int myYOffset = 0;
    private int myTopPadding = 0;
    private int mNextLineColorIndex;
    private boolean myRedraw;
    @NotNull
    private DoubleSupplier myFillEndSupplier = ALWAYS_0;
    @NotNull
    private final LineChartReducer myReducer;
    private long myRedraws;
    private long myDraws;
    private long myLastCount;
    private long myLastDraws;
    private long myLastRedraws;
    private Map<LineConfig, DashInfo> myDashInfoCache = new HashMap<LineConfig, DashInfo>();

    @VisibleForTesting
    public LineChart(@NotNull LineChartModel model2, @NotNull LineChartReducer reducer) {
        this.myLinePaths = new ArrayList();
        this.myLinePathSeries = new ArrayList();
        this.myReducer = reducer;
        this.myModel = model2;
        this.myRedraw = true;
        this.myModel.addDependency(this.myAspectObserver).onChange(LineChartModel.Aspect.LINE_CHART, this::modelChanged);
    }

    public LineChart(@NotNull LineChartModel model2) {
        this(model2, new DefaultLineChartReducer());
    }

    public LineChart(@NotNull List<RangedContinuousSeries> data) {
        this(new LineChartModel());
        this.myModel.addAll(data);
    }

    public void configure(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        this.myLinesConfig.put(series, config);
    }

    public void addCustomRenderer(@NotNull LineChartCustomRenderer renderer) {
        this.myCustomRenderers.add(renderer);
    }

    @NotNull
    public LineConfig getLineConfig(RangedContinuousSeries rangedContinuousSeries) {
        LineConfig config = this.myLinesConfig.get(rangedContinuousSeries);
        if (config == null) {
            config = new LineConfig(LineConfig.getColor(this.mNextLineColorIndex++));
            this.configure(rangedContinuousSeries, config);
        }
        return config;
    }

    private void modelChanged() {
        this.myRedraw = true;
        this.opaqueRepaint();
    }

    private void redraw(@NotNull Dimension dim) {
        long duration = System.nanoTime();
        List<SeriesData<Long>> lastStackedSeries = null;
        ArrayDeque<Path2D.Float> orderedPaths = new ArrayDeque<Path2D.Float>(this.myLinesConfig.size());
        ArrayDeque<RangedContinuousSeries> orderedSeries = new ArrayDeque<RangedContinuousSeries>(this.myLinesConfig.size());
        for (RangedContinuousSeries ranged : this.myModel.getSeries()) {
            if (ranged.getXRange().isEmpty() || ranged.getXRange().isPoint() || ranged.getYRange().isEmpty() || ranged.getYRange().isPoint()) continue;
            LineConfig config = this.getLineConfig(ranged);
            List<SeriesData<Long>> seriesList = ranged.getSeries();
            if (config.isStacked()) {
                if (lastStackedSeries == null) {
                    lastStackedSeries = ContainerUtil.map(seriesList, data -> new SeriesData<Long>(data.x, (Long)data.value));
                } else {
                    for (int i2 = 0; i2 < seriesList.size() && i2 < lastStackedSeries.size(); ++i2) {
                        SeriesData seriesData = (SeriesData)lastStackedSeries.get(i2);
                        Long.valueOf((Long)seriesData.value + (Long)((SeriesData)seriesList.get((int)i2)).value);
                        seriesData.value = seriesData.value;
                    }
                    seriesList = lastStackedSeries;
                }
            }
            Path2D.Float path = new Path2D.Float();
            double xMin = ranged.getXRange().getMin();
            double xLength = ranged.getXRange().getLength();
            double yMin = ranged.getYRange().getMin();
            double yLength = ranged.getYRange().getLength();
            double firstXd = 0.0;
            double firstX = 0.0;
            seriesList = this.myReducer.reduceData(seriesList, config);
            double xBucketInterval = config.getDataBucketInterval() / xLength;
            double xBucketBarWidth = xBucketInterval * 0.7;
            boolean optimizeYZooming = !config.isStepped() && xBucketInterval == 0.0;
            for (int i3 = 0; i3 < seriesList.size(); ++i3) {
                double barX;
                SeriesData<Long> data2 = seriesList.get(i3);
                SeriesData<Long> dataNext = seriesList.get(i3 + 1 == seriesList.size() ? i3 : i3 + 1);
                SeriesData<Long> dataPrev = seriesList.get(i3 - 1 < 0 ? i3 : i3 - 1);
                double xd = ((double)data2.x - xMin) / xLength;
                double yd = 1.0 - ((double)((Long)data2.value).longValue() - yMin) / yLength;
                double originalXd = xd;
                if (xd < 0.0) {
                    double xdNext = ((double)dataNext.x - xMin) / xLength;
                    if (xdNext < 0.0) {
                        if (data2 != dataNext) continue;
                        ((Path2D)path).moveTo(0.0, yd);
                        continue;
                    }
                    double ydNext = 1.0 - ((double)((Long)dataNext.value).longValue() - yMin) / yLength;
                    double newPosition = 0.0;
                    if (config.isDash()) {
                        newPosition = xd % 1.0;
                    }
                    if (optimizeYZooming) {
                        double ratio = (newPosition - xd) / (xdNext - xd);
                        yd = (1.0 - ratio) * yd + ratio * ydNext;
                    }
                    xd = newPosition;
                } else if (xd > 1.0) {
                    double xdPrev = ((double)dataPrev.x - xMin) / xLength;
                    if (xdPrev > 1.0) break;
                    if (optimizeYZooming) {
                        double ratio = (1.0 - xdPrev) / (xd - xdPrev);
                        double ydPrev = 1.0 - ((double)((Long)dataPrev.value).longValue() - yMin) / yLength;
                        yd = (1.0 - ratio) * ydPrev + ratio * yd;
                    }
                    xd = 1.0;
                }
                if (path.getCurrentPoint() == null) {
                    firstXd = xd;
                    firstX = data2.x;
                    ((Path2D)path).moveTo(xd, xBucketInterval != 0.0 ? 1.0 : yd);
                } else if (xBucketInterval == 0.0) {
                    if (config.isStepped()) {
                        float y = (float)path.getCurrentPoint().getY();
                        ((Path2D)path).lineTo(xd, y);
                    }
                    ((Path2D)path).lineTo(xd, yd);
                }
                if (xBucketInterval == 0.0 || !((barX = Math.min(1.0, originalXd + xBucketBarWidth)) - xd > (double)1.0E-4f)) continue;
                ((Path2D)path).lineTo(xd, 1.0);
                ((Path2D)path).lineTo(xd, yd);
                ((Path2D)path).lineTo(barX, yd);
                ((Path2D)path).lineTo(barX, 1.0);
            }
            if (path.getCurrentPoint() != null) {
                ((Path2D)path).lineTo(Math.max(path.getCurrentPoint().getX(), this.myFillEndSupplier.getAsDouble()), path.getCurrentPoint().getY());
            }
            if (config.isFilled() && path.getCurrentPoint() != null) {
                ((Path2D)path).lineTo(path.getCurrentPoint().getX(), 1.0);
                ((Path2D)path).lineTo(firstXd, 1.0);
            }
            if (config.isFilled()) {
                orderedPaths.addFirst(path);
                orderedSeries.addFirst(ranged);
            } else {
                orderedPaths.addLast(path);
                orderedSeries.addLast(ranged);
            }
            if (config.isDash() && config.isAdjustDash()) {
                if (!this.myDashInfoCache.containsKey(config)) {
                    dashInfo = new DashInfo();
                    this.myDashInfoCache.put(config, dashInfo);
                } else {
                    dashInfo = this.myDashInfoCache.get(config);
                    this.computeAdjustedDashPhase(dashInfo, config, path, dim, firstX, xMin, xLength, yLength);
                }
                dashInfo.myPreviousFirstX = firstX;
                dashInfo.myPreviousXMin = xMin;
                dashInfo.myPreviousXLength = xLength;
                dashInfo.myPreviousYLength = yLength;
                dashInfo.myPreviousDashPath = path;
                continue;
            }
            this.myDashInfoCache.remove(config);
        }
        this.myLinePaths.clear();
        this.myLinePaths.addAll(orderedPaths);
        this.myLinePathSeries.clear();
        this.myLinePathSeries.addAll(orderedSeries);
        this.addDebugInfo("postAnimate time: %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - duration));
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        int i2;
        long now;
        long drawStartTime = now = System.nanoTime();
        if ((double)(now - this.myLastCount) > 1.0E9) {
            this.myLastDraws = this.myDraws;
            this.myLastRedraws = this.myRedraws;
            this.myDraws = 0L;
            this.myRedraws = 0L;
            this.myLastCount = now;
        }
        ++this.myDraws;
        if (this.myRedraw) {
            this.myRedraw = false;
            this.redraw(dim);
            ++this.myRedraws;
        } else {
            this.addDebugInfo("postAnimate time: 0 ms", new Object[0]);
        }
        this.addDebugInfo("Draws in the last second %d", this.myLastDraws);
        this.addDebugInfo("Redraws in the last second %d", this.myLastRedraws);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform scale = new AffineTransform(dim.getWidth(), 0.0, 0.0, dim.getHeight() - (double)this.myTopPadding, (double)this.myXOffset, (double)(this.myYOffset + this.myTopPadding));
        if (this.myShowMaxLine) {
            g2d.setColor(this.myMaxLineColor);
            g2d.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
            g2d.drawLine(this.myMaxLineMargin, 0, dim.width, 0);
        }
        ArrayList<Path2D> transformedPaths = new ArrayList<Path2D>(this.myLinePaths.size());
        ArrayList<LineConfig> configs = new ArrayList<LineConfig>(this.myLinePaths.size());
        for (i2 = 0; i2 < this.myLinePaths.size(); ++i2) {
            Path2D scaledPath = new Path2D.Float(this.myLinePaths.get(i2), scale);
            LineConfig config = this.getLineConfig(this.myLinePathSeries.get(i2));
            configs.add(config);
            scaledPath = this.myReducer.reducePath(scaledPath, config);
            transformedPaths.add(scaledPath);
            if (!this.isDrawDebugInfo()) continue;
            int count = 0;
            PathIterator it = scaledPath.getPathIterator(null);
            while (!it.isDone()) {
                ++count;
                it.next();
            }
            this.addDebugInfo("# of points drawn: %d", count);
        }
        for (i2 = 0; i2 < transformedPaths.size(); ++i2) {
            LineChart.drawLine(g2d, (Path2D)transformedPaths.get(i2), (LineConfig)configs.get(i2));
        }
        this.myCustomRenderers.forEach(renderer -> renderer.renderLines(this, g2d, transformedPaths, this.myLinePathSeries));
        this.addDebugInfo("Draw time: %.2fms", (double)(System.nanoTime() - drawStartTime) / 1000000.0);
    }

    public static void drawLine(@NotNull Graphics2D g2d, @NotNull Path2D path, @NotNull LineConfig config) {
        g2d.setColor(config.getColor());
        g2d.setStroke(config.isDash() && config.isAdjustDash() ? config.getAdjustedStroke() : config.getStroke());
        if (config.isStepped()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (config.isFilled()) {
            g2d.fill(path);
        } else {
            g2d.draw(path);
        }
    }

    public void setShowMaxLine(boolean showMaxLine) {
        this.myShowMaxLine = showMaxLine;
    }

    public void setMaxLineColor(@NotNull Color maxLineColor) {
        this.myMaxLineColor = maxLineColor;
    }

    public void setMaxLineMargin(int maxLineMargin) {
        this.myMaxLineMargin = maxLineMargin;
    }

    private void computeAdjustedDashPhase(@NotNull DashInfo dashInfo, @NotNull LineConfig config, @NotNull Path2D path, @NotNull Dimension dim, double firstX, double xMin, double xLength, double yLength) {
        if (Math.abs(dashInfo.myPreviousXLength - xLength) > (double)1.0E-4f || Math.abs(dashInfo.myPreviousYLength - yLength) > (double)1.0E-4f || Math.abs(dashInfo.myPreviousXMin - xMin) > xLength / 2.0) {
            return;
        }
        Path2D pathToUse = null;
        double firstXd = 0.0;
        boolean newPathIsAhead = false;
        if (xMin - dashInfo.myPreviousXMin > (double)1.0E-4f) {
            pathToUse = dashInfo.myPreviousDashPath;
            firstXd = (firstX - dashInfo.myPreviousXMin) / xLength;
            newPathIsAhead = true;
        } else if (dashInfo.myPreviousXMin - xMin > (double)1.0E-4f) {
            pathToUse = path;
            firstXd = (dashInfo.myPreviousFirstX - xMin) / xLength;
        }
        if (pathToUse == null || pathToUse.getCurrentPoint() == null) {
            return;
        }
        float dashPatternLength = config.getDashLength();
        double deltaPathLength = 0.0;
        PathIterator iterator = pathToUse.getPathIterator(null);
        float[] coords = new float[6];
        int segType = iterator.currentSegment(coords);
        assert (segType == 0);
        if (Math.abs((double)coords[0] - firstXd) < (double)1.0E-4f) {
            return;
        }
        double prevX = coords[0];
        double prevY = coords[1];
        iterator.next();
        while (!iterator.isDone()) {
            segType = iterator.currentSegment(coords);
            assert (segType == 1);
            if ((double)coords[0] - firstXd >= (double)1.0E-4f) {
                if (!(firstXd - prevX >= (double)1.0E-4f)) break;
                deltaPathLength += (firstXd - prevX) * (double)dim.width;
                break;
            }
            deltaPathLength = config.isStepped() ? (deltaPathLength += Math.abs((double)coords[0] - prevX) * (double)dim.width + Math.abs((double)coords[1] - prevY) * (double)dim.height) : (deltaPathLength += Math.hypot(((double)coords[0] - prevX) * (double)dim.width, ((double)coords[1] - prevY) * (double)dim.height));
            prevX = coords[0];
            prevY = coords[1];
            iterator.next();
        }
        double dashPhase = config.getAdjustedDashPhase();
        if (newPathIsAhead) {
            dashPhase = (dashPhase + deltaPathLength) % (double)dashPatternLength;
        } else if ((dashPhase = (dashPhase - deltaPathLength) % (double)dashPatternLength) < 0.0) {
            dashPhase += (double)dashPatternLength;
        }
        config.setAdjustedDashPhase(dashPhase);
    }

    public void setRenderOffset(int xOffset, int yOffset) {
        this.myXOffset = xOffset;
        this.myYOffset = yOffset;
    }

    public void setTopPadding(int padding) {
        this.myTopPadding = padding;
    }

    public void setFillEndGap(boolean fillEndGap) {
        this.setFillEndSupplier(fillEndGap ? ALWAYS_1 : ALWAYS_0);
    }

    public void setFillEndSupplier(@NotNull DoubleSupplier fillEndSupplier) {
        this.myFillEndSupplier = fillEndSupplier;
    }

    private static class DashInfo {
        double myPreviousFirstX;
        double myPreviousXMin;
        double myPreviousXLength;
        double myPreviousYLength;
        Path2D myPreviousDashPath;

        private DashInfo() {
        }
    }
}

