/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.LineChartReducer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.SeriesData;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultLineChartReducer
implements LineChartReducer {
    private static final float EPS = 1.0E-6f;
    private static int PATH_ITERATOR_COORDS_COUNT = 6;

    DefaultLineChartReducer() {
    }

    @Override
    public List<SeriesData<Long>> reduceData(@NotNull List<SeriesData<Long>> dataList, @NotNull LineConfig config) {
        if (config.getDataBucketInterval() > 0.0) {
            return dataList;
        }
        ArrayList<SeriesData<Long>> reduced = new ArrayList<SeriesData<Long>>();
        for (SeriesData<Long> data : dataList) {
            while (reduced.size() >= 2) {
                SeriesData preLast = (SeriesData)reduced.get(reduced.size() - 2);
                SeriesData last = (SeriesData)reduced.get(reduced.size() - 1);
                if (!((Long)preLast.value).equals(last.value) || !config.isStepped() && !((Long)last.value).equals(data.value)) break;
                reduced.remove(reduced.size() - 1);
            }
            reduced.add(data);
        }
        return reduced;
    }

    @Override
    @NotNull
    public Path2D reducePath(@NotNull Path2D path, @NotNull LineConfig config) {
        if (path.getCurrentPoint() == null) {
            return path;
        }
        Path2D.Float resultPath = new Path2D.Float();
        float[] coords = new float[PATH_ITERATOR_COORDS_COUNT];
        float pixel = -1.0f;
        float minX = -1.0f;
        float minY = -1.0f;
        float maxX = -1.0f;
        float maxY = -1.0f;
        float curX = -1.0f;
        float curY = -1.0f;
        int minIndex = -1;
        int maxIndex = -1;
        int curIndex = 0;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(coords);
            assert (segType == 0 || segType == 1);
            float previousX = curX;
            float previousY = curY;
            curX = coords[0];
            curY = coords[1];
            if (curIndex > 0 && curX < previousX) break;
            if (curIndex == 0 || curX >= pixel) {
                if (curIndex > 0) {
                    DefaultLineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
                    DefaultLineChartReducer.addToResultPath(resultPath, config, previousX, previousY);
                }
                pixel = (float)Math.floor(curX) + 1.0f;
                minX = maxX = curX;
                minY = maxY = curY;
                minIndex = maxIndex = curIndex;
                DefaultLineChartReducer.addToResultPath(resultPath, config, curX, curY);
            } else {
                if (minY > curY) {
                    minIndex = curIndex;
                    minX = curX;
                    minY = curY;
                }
                if (maxY <= curY) {
                    maxIndex = curIndex;
                    maxX = curX;
                    maxY = curY;
                }
            }
            iterator.next();
            ++curIndex;
        }
        DefaultLineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
        DefaultLineChartReducer.addToResultPath(resultPath, config, curX, curY);
        if (config.isStepped() && (resultPath.getCurrentPoint() == null || DefaultLineChartReducer.equals((float)resultPath.getCurrentPoint().getY(), curY))) {
            DefaultLineChartReducer.addToPath(resultPath, curX, curY);
        }
        return resultPath;
    }

    private static void addMinMaxPoints(@NotNull Path2D path, @NotNull LineConfig config, int minIndex, float minX, float minY, int maxIndex, float maxX, float maxY) {
        if (minIndex < maxIndex) {
            DefaultLineChartReducer.addToResultPath(path, config, minX, minY, maxX, maxY);
        } else {
            DefaultLineChartReducer.addToResultPath(path, config, maxX, maxY, minX, minY);
        }
    }

    private static void addToResultPath(@NotNull Path2D path, @NotNull LineConfig config, float ... coords) {
        assert (coords.length % 2 == 0);
        for (int i2 = 0; i2 < coords.length; i2 += 2) {
            float x = coords[i2];
            float y = coords[i2 + 1];
            if (config.isStepped()) {
                DefaultLineChartReducer.addToSteppedLinePath(path, x, y);
                continue;
            }
            DefaultLineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToSteppedLinePath(@NotNull Path2D path, float x, float y) {
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!DefaultLineChartReducer.equals(y, (float)path.getCurrentPoint().getY())) {
            DefaultLineChartReducer.addToPath(path, x, (float)path.getCurrentPoint().getY());
            DefaultLineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToPath(@NotNull Path2D path, float x, float y) {
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!DefaultLineChartReducer.equals((float)path.getCurrentPoint().getX(), x) || !DefaultLineChartReducer.equals((float)path.getCurrentPoint().getY(), y)) {
            path.lineTo(x, y);
        }
    }

    private static boolean equals(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }
}

