/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.AbstractPaginatedTableModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010,\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020.H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0014\u0010\u0011R\u001c\u0010\u0015\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u001c\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u001cR*\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00060\u00060\u001e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u000f\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u000f\u001a\u0004\b%\u0010\u0011R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00060"}, d2={"Lcom/android/tools/adtui/PaginatedTableView;", "", "tableModel", "Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;", "pageSizeValues", "", "", "(Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;[Ljava/lang/Integer;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "firstPageButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "getFirstPageButton$annotations", "()V", "getFirstPageButton", "()Lcom/android/tools/adtui/stdui/CommonButton;", "lastPageButton", "getLastPageButton$annotations", "getLastPageButton", "nextPageButton", "getNextPageButton$annotations", "getNextPageButton", "pageInfoLabel", "Ljavax/swing/JLabel;", "getPageInfoLabel$annotations", "getPageInfoLabel", "()Ljavax/swing/JLabel;", "pageSizeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "getPageSizeComboBox$annotations", "getPageSizeComboBox", "()Lcom/intellij/openapi/ui/ComboBox;", "prevPageButton", "getPrevPageButton$annotations", "getPrevPageButton", "table", "Lcom/intellij/ui/table/JBTable;", "getTable", "()Lcom/intellij/ui/table/JBTable;", "getTableModel", "()Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;", "buildToolbar", "updateToolbar", "", "Companion", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nPaginatedTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatedTableView.kt\ncom/android/tools/adtui/PaginatedTableView\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,160:1\n26#2:161\n*S KotlinDebug\n*F\n+ 1 PaginatedTableView.kt\ncom/android/tools/adtui/PaginatedTableView\n*L\n45#1:161\n*E\n"})
public final class PaginatedTableView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractPaginatedTableModel tableModel;
    @NotNull
    private final JBTable table;
    @NotNull
    private final JComponent component;
    @NotNull
    private final CommonButton firstPageButton;
    @NotNull
    private final CommonButton lastPageButton;
    @NotNull
    private final CommonButton prevPageButton;
    @NotNull
    private final CommonButton nextPageButton;
    @NotNull
    private final JLabel pageInfoLabel;
    @NotNull
    private final ComboBox<Integer> pageSizeComboBox;
    @NotNull
    private static final Icon FIRST_PAGE_ICON;
    @NotNull
    private static final Icon LAST_PAGE_ICON;
    @NotNull
    private static final Icon PREV_PAGE_ICON;
    @NotNull
    private static final Icon NEXT_PAGE_ICON;

    /*
     * WARNING - void declaration
     */
    public PaginatedTableView(@NotNull AbstractPaginatedTableModel tableModel, @NotNull Integer[] pageSizeValues) {
        void $this$_init__u24lambda_u242;
        void $this$lambda_u241_u24lambda_u240;
        Object $this$_init__u24lambda_u241;
        TableRowSorter<TableModel> tableRowSorter;
        Object object;
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)pageSizeValues, (String)"pageSizeValues");
        this.tableModel = tableModel;
        this.firstPageButton = new CommonButton(FIRST_PAGE_ICON);
        this.lastPageButton = new CommonButton(LAST_PAGE_ICON);
        this.prevPageButton = new CommonButton(PREV_PAGE_ICON);
        this.nextPageButton = new CommonButton(NEXT_PAGE_ICON);
        this.pageInfoLabel = new JLabel();
        this.pageSizeComboBox = new ComboBox((Object[])pageSizeValues);
        JBTable jBTable = object = new JBTable((TableModel)this.tableModel);
        PaginatedTableView paginatedTableView = this;
        boolean bl = false;
        TableRowSorter<TableModel> tableRowSorter2 = tableRowSorter = new TableRowSorter<TableModel>(this.tableModel);
        void var8_9 = $this$_init__u24lambda_u241;
        boolean bl2 = false;
        $this$lambda_u241_u24lambda_u240.addRowSorterListener(new RowSorterListener((JBTable)$this$_init__u24lambda_u241, this, (TableRowSorter<AbstractPaginatedTableModel>)$this$lambda_u241_u24lambda_u240){
            final /* synthetic */ JBTable $this_apply;
            final /* synthetic */ PaginatedTableView this$0;
            final /* synthetic */ TableRowSorter<AbstractPaginatedTableModel> $this_apply$1;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                this.$this_apply$1 = $receiver3;
            }

            public final void sorterChanged(RowSorterEvent event) {
                if (event.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                    this.$this_apply.clearSelection();
                    AbstractPaginatedTableModel abstractPaginatedTableModel = this.this$0.getTableModel();
                    List<RowSorter.SortKey> list = ((RowSorter)event.getSource()).getSortKeys();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"event.source.sortKeys");
                    abstractPaginatedTableModel.sortData(list);
                    this.$this_apply$1.allRowsChanged();
                }
            }
        });
        var8_9.setRowSorter((RowSorter)tableRowSorter);
        paginatedTableView.table = object;
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public final void tableChanged(TableModelEvent it) {
                this.updateToolbar();
            }
        });
        $this$_init__u24lambda_u241 = object = new JPanel(new BorderLayout());
        paginatedTableView = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.add((Component)this.buildToolbar(), "North");
        $this$_init__u24lambda_u242.add((Component)new JBScrollPane((Component)this.table), "Center");
        paginatedTableView.component = (JComponent)object;
    }

    public /* synthetic */ PaginatedTableView(AbstractPaginatedTableModel abstractPaginatedTableModel, Integer[] integerArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean $i$f$emptyArray = false;
            integerArray = new Integer[]{};
        }
        this(abstractPaginatedTableModel, integerArray);
    }

    @NotNull
    public final AbstractPaginatedTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final JBTable getTable() {
        return this.table;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final CommonButton getFirstPageButton() {
        return this.firstPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFirstPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getLastPageButton() {
        return this.lastPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getPrevPageButton() {
        return this.prevPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPrevPageButton$annotations() {
    }

    @NotNull
    public final CommonButton getNextPageButton() {
        return this.nextPageButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNextPageButton$annotations() {
    }

    @NotNull
    public final JLabel getPageInfoLabel() {
        return this.pageInfoLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPageInfoLabel$annotations() {
    }

    @NotNull
    public final ComboBox<Integer> getPageSizeComboBox() {
        return this.pageSizeComboBox;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPageSizeComboBox$annotations() {
    }

    private final void updateToolbar() {
        int firstRowIndex = this.tableModel.getPageIndex() * this.tableModel.getPageSize() + 1;
        int lastRowIndex = firstRowIndex + this.tableModel.getRowCount() - 1;
        this.pageInfoLabel.setText(firstRowIndex + " - " + lastRowIndex + " of " + this.tableModel.getDataSize());
        this.firstPageButton.setEnabled(!this.tableModel.isOnFirstPage());
        this.lastPageButton.setEnabled(!this.tableModel.isOnLastPage());
        this.prevPageButton.setEnabled(!this.tableModel.isOnFirstPage());
        this.nextPageButton.setEnabled(!this.tableModel.isOnLastPage());
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildToolbar() {
        void $this$buildToolbar_u24lambda_u249_u24lambda_u248;
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox<Integer> comboBox;
        ComboBox<Integer> $this$buildToolbar_u24lambda_u243 = comboBox = this.firstPageButton;
        boolean bl = false;
        $this$buildToolbar_u24lambda_u243.setDisabledIcon(IconLoader.getDisabledIcon((Icon)FIRST_PAGE_ICON));
        $this$buildToolbar_u24lambda_u243.setToolTipText("Go to first page");
        $this$buildToolbar_u24lambda_u243.addActionListener(new ActionListener(this){
            final /* synthetic */ PaginatedTableView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getTableModel().goToFirstPage();
            }
        });
        ComboBox<Integer> $this$buildToolbar_u24lambda_u244 = comboBox = this.lastPageButton;
        boolean bl2 = false;
        $this$buildToolbar_u24lambda_u244.setDisabledIcon(IconLoader.getDisabledIcon((Icon)LAST_PAGE_ICON));
        $this$buildToolbar_u24lambda_u244.setToolTipText("Go to last page");
        $this$buildToolbar_u24lambda_u244.addActionListener(new ActionListener(this){
            final /* synthetic */ PaginatedTableView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getTableModel().goToLastPage();
            }
        });
        ComboBox<Integer> $this$buildToolbar_u24lambda_u245 = comboBox = this.prevPageButton;
        boolean bl3 = false;
        $this$buildToolbar_u24lambda_u245.setDisabledIcon(IconLoader.getDisabledIcon((Icon)PREV_PAGE_ICON));
        $this$buildToolbar_u24lambda_u245.setToolTipText("Go to previous page");
        $this$buildToolbar_u24lambda_u245.addActionListener(new ActionListener(this){
            final /* synthetic */ PaginatedTableView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getTableModel().goToPrevPage();
            }
        });
        ComboBox<Integer> $this$buildToolbar_u24lambda_u246 = comboBox = this.nextPageButton;
        boolean bl4 = false;
        $this$buildToolbar_u24lambda_u246.setDisabledIcon(IconLoader.getDisabledIcon((Icon)NEXT_PAGE_ICON));
        $this$buildToolbar_u24lambda_u246.setToolTipText("Go to next page");
        $this$buildToolbar_u24lambda_u246.addActionListener(new ActionListener(this){
            final /* synthetic */ PaginatedTableView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getTableModel().goToNextPage();
            }
        });
        ComboBox<Integer> $this$buildToolbar_u24lambda_u247 = comboBox = this.pageSizeComboBox;
        boolean bl5 = false;
        $this$buildToolbar_u24lambda_u247.setVisible($this$buildToolbar_u24lambda_u247.getItemCount() > 0);
        $this$buildToolbar_u24lambda_u247.setSelectedItem((Object)this.tableModel.getPageSize());
        $this$buildToolbar_u24lambda_u247.addActionListener(new ActionListener(this, $this$buildToolbar_u24lambda_u247){
            final /* synthetic */ PaginatedTableView this$0;
            final /* synthetic */ ComboBox<Integer> $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public final void actionPerformed(ActionEvent it) {
                AbstractPaginatedTableModel abstractPaginatedTableModel = this.this$0.getTableModel();
                Object object = this.$this_apply.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item");
                abstractPaginatedTableModel.updatePageSize(((Number)object).intValue());
            }
        });
        JPanel $this$buildToolbar_u24lambda_u249 = jPanel2 = new JPanel(new BorderLayout());
        boolean bl6 = false;
        $this$buildToolbar_u24lambda_u249.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        $this$buildToolbar_u24lambda_u249.add((Component)this.pageInfoLabel, "Before");
        JPanel jPanel3 = jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = $this$buildToolbar_u24lambda_u249;
        boolean bl7 = false;
        $this$buildToolbar_u24lambda_u249_u24lambda_u248.add(this.firstPageButton);
        $this$buildToolbar_u24lambda_u249_u24lambda_u248.add(this.prevPageButton);
        $this$buildToolbar_u24lambda_u249_u24lambda_u248.add((Component)this.pageSizeComboBox);
        $this$buildToolbar_u24lambda_u249_u24lambda_u248.add(this.nextPageButton);
        $this$buildToolbar_u24lambda_u249_u24lambda_u248.add(this.lastPageButton);
        jPanel4.add((Component)jPanel, "After");
        JPanel toolbar = jPanel2;
        this.updateToolbar();
        return toolbar;
    }

    static {
        Icon icon = StudioIcons.LayoutEditor.Motion.GO_TO_START;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GO_TO_START");
        FIRST_PAGE_ICON = icon;
        Icon icon2 = StudioIcons.LayoutEditor.Motion.GO_TO_END;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GO_TO_END");
        LAST_PAGE_ICON = icon2;
        Icon icon3 = StudioIcons.LayoutEditor.Motion.PREVIOUS_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PREVIOUS_TICK");
        PREV_PAGE_ICON = icon3;
        Icon icon4 = StudioIcons.LayoutEditor.Motion.NEXT_TICK;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"NEXT_TICK");
        NEXT_PAGE_ICON = icon4;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/adtui/PaginatedTableView$Companion;", "", "()V", "FIRST_PAGE_ICON", "Ljavax/swing/Icon;", "LAST_PAGE_ICON", "NEXT_PAGE_ICON", "PREV_PAGE_ICON", "intellij.android.adt.ui"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

