/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.stdui.StandardColors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class HoverRowTable
extends JBTable {
    private int myHoveredRow = -1;
    private final Color myHoverColor = StandardColors.HOVER_COLOR;

    public HoverRowTable(@NotNull TableModel model2) {
        super(model2);
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(HoverRowTable.this.rowAtPoint(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(-1);
            }
        };
        this.addMouseMotionListener(mouseAdapter2);
        this.addMouseListener(mouseAdapter2);
        this.getEmptyText().clear();
        this.setIntercellSpacing(new Dimension());
    }

    private void hoveredRowChanged(int row) {
        if (row == this.myHoveredRow) {
            return;
        }
        this.myHoveredRow = row;
        this.repaint();
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component comp;
        Component toChangeComp = comp = super.prepareRenderer(renderer, row, column);
        if (comp instanceof ExpandedItemRendererComponentWrapper) {
            toChangeComp = ((ExpandedItemRendererComponentWrapper)comp).getComponent(0);
        }
        if (this.getRowSelectionAllowed() && this.isRowSelected(row)) {
            toChangeComp.setForeground(this.getSelectionForeground());
            toChangeComp.setBackground(this.getSelectionBackground());
        } else if (row == this.myHoveredRow) {
            toChangeComp.setBackground(this.myHoverColor);
            toChangeComp.setForeground(this.getForeground());
        } else {
            toChangeComp.setBackground(this.getBackground());
            toChangeComp.setForeground(this.getForeground());
        }
        return comp;
    }

    public void paint(@NotNull Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, UIUtil.getLcdContrastValue());
        }
        super.paint(g);
        if (this.isEmpty() && !StringUtil.isEmpty((String)this.getEmptyText().getText())) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        ArrayList<Integer> columnX = new ArrayList<Integer>();
        int x2 = 0;
        for (int index = 0; index < columnModel.getColumnCount() - 1; ++index) {
            int column = this.getComponentOrientation().isLeftToRight() ? index : columnModel.getColumnCount() - 1 - index;
            columnX.add((x2 += columnModel.getColumn(column).getWidth()) - 1);
        }
        g.setColor(this.getGridColor());
        int lastRowBottom = this.getRowCount() * this.getRowHeight();
        columnX.forEach(x -> g.drawLine((int)x, lastRowBottom, (int)x, this.getHeight()));
        if (this.getSelectedRow() != -1 && this.getCellSelectionEnabled()) {
            g.setColor(AdtUiUtils.overlayColor(this.getSelectionBackground().getRGB(), this.getGridColor().getRGB(), 0.25f));
            Rectangle selectedRowRect = this.getCellRect(this.getSelectedRow(), 0, true);
            columnX.forEach(x -> g.drawLine((int)x, selectedRowRect.y, (int)x, selectedRowRect.y + selectedRowRect.height - 1));
        }
    }
}

