/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class AndroidSdkPathStore {
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";

    public static AndroidSdkPathStore getInstance() {
        return (AndroidSdkPathStore)ApplicationManager.getApplication().getService(AndroidSdkPathStore.class);
    }

    public void setAndroidSdkPath(@Nullable Path path) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String sdkPath = path == null ? null : path.toAbsolutePath().toString();
        PropertiesComponent component = PropertiesComponent.getInstance();
        component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
    }

    @Nullable
    public Path getAndroidSdkPath() {
        PropertiesComponent component = PropertiesComponent.getInstance();
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        return sdkPath == null ? null : Paths.get(sdkPath, new String[0]);
    }
}

