/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        String name = path.getName();
        boolean isJarFile = FileUtil.extensionEquals((String)name, (String)"jar") || FileUtil.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        Object url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)path.getPath()));
        if (isJarFile) {
            url = (String)url + "!/";
        }
        return url;
    }

    @Nullable
    public static Path getJarFromJarUrl(@NotNull String url) {
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return FilePaths.toSystemDependentPath(path);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static Path toSystemDependentPath(@Nullable String path) {
        return path == null ? null : Paths.get(path, new String[0]);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static File stringToFile(@Nullable String path) {
        return path == null ? null : new File(path);
    }
}

